/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.registry;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import weblogic.xml.XMLLogger;
import weblogic.xml.jaxp.ReParsingStatus;
import weblogic.xml.registry.EntityCache;
import weblogic.xml.registry.ReParsingEntityNotChangedException;
import weblogic.xml.registry.RefreshCacheLock;
import weblogic.xml.registry.XMLRegistry;
import weblogic.xml.registry.XMLRegistryException;
import weblogic.xml.registry.XMLRegistryExceptionCacheEntryExpired;
import weblogic.xml.registry.XMLRegistryRemoteAccessException;
import weblogic.xml.util.InputSourceUtil;
import weblogic.xml.util.Tools;
import weblogic.xml.util.cache.entitycache.CX;

public class RegistryEntityResolver
implements EntityResolver {
    XMLRegistry[] registryPath = null;
    private ReParsingStatus status;

    RegistryEntityResolver(XMLRegistry[] xMLRegistryArray) {
        this.registryPath = xMLRegistryArray;
    }

    public XMLRegistry[] getRegistryPath() {
        try {
            return XMLRegistry.getXMLRegistryPath();
        }
        catch (XMLRegistryException xMLRegistryException) {
            XMLLogger.logStackTrace((String)"XMLRegistryException on the path.", (Throwable)((Object)xMLRegistryException));
            return this.registryPath;
        }
    }

    public RegistryEntityResolver() throws XMLRegistryException {
        this.registryPath = XMLRegistry.getXMLRegistryPath();
    }

    public boolean hasDocumentSpecificParserEntries() {
        for (int i = 0; i < this.registryPath.length; ++i) {
            if (!this.registryPath[i].hasDocumentSpecificParserEntries()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDocumentSpecificEntityEntries() {
        for (int i = 0; i < this.registryPath.length; ++i) {
            if (!this.registryPath[i].hasDocumentSpecificEntityEntries()) continue;
            return true;
        }
        return false;
    }

    public TransformerFactory getTransformerFactory() throws XMLRegistryException {
        TransformerFactory transformerFactory = null;
        for (int i = 0; i < this.registryPath.length && (transformerFactory = this.registryPath[i].getTransformerFactory()) == null; ++i) {
        }
        return transformerFactory;
    }

    public TransformerFactory getTransformerFactory(String string, String string2, String string3) throws XMLRegistryException {
        if (string == null && string2 == null && string3 == null) {
            return null;
        }
        TransformerFactory transformerFactory = null;
        for (int i = 0; i < this.registryPath.length && (transformerFactory = this.registryPath[i].getTransformerFactory(string, string2, string3)) == null; ++i) {
        }
        return transformerFactory;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() throws XMLRegistryException {
        DocumentBuilderFactory documentBuilderFactory = null;
        for (int i = 0; i < this.registryPath.length && (documentBuilderFactory = this.registryPath[i].getDocumentBuilderFactory()) == null; ++i) {
        }
        return documentBuilderFactory;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory(String string, String string2, String string3) throws XMLRegistryException {
        if (string == null && string2 == null && string3 == null) {
            return null;
        }
        DocumentBuilderFactory documentBuilderFactory = null;
        for (int i = 0; i < this.getRegistryPath().length && (documentBuilderFactory = this.registryPath[i].getDocumentBuilderFactory(string, string2, string3)) == null; ++i) {
        }
        return documentBuilderFactory;
    }

    public Parser getParser(String string, String string2, String string3) throws XMLRegistryException {
        Parser parser2 = null;
        for (int i = 0; i < this.registryPath.length && (parser2 = this.registryPath[i].getParser(string, string2, string3)) == null; ++i) {
        }
        return parser2;
    }

    public SAXParserFactory getSAXParserFactory(String string, String string2, String string3) throws XMLRegistryException {
        if (string == null && string2 == null && string3 == null) {
            return null;
        }
        SAXParserFactory sAXParserFactory = null;
        for (int i = 0; i < this.registryPath.length && (sAXParserFactory = this.registryPath[i].getSAXParserFactory(string, string2, string3)) == null; ++i) {
        }
        return sAXParserFactory;
    }

    public SAXParserFactory getSAXParserFactory() throws XMLRegistryException {
        SAXParserFactory sAXParserFactory = null;
        for (int i = 0; i < this.registryPath.length && (sAXParserFactory = this.registryPath[i].getSAXParserFactory()) == null; ++i) {
        }
        return sAXParserFactory;
    }

    public String getHandleEntityInvalidation(String string, String string2) throws XMLRegistryException {
        if (string == null && string2 == null) {
            return null;
        }
        String string3 = null;
        for (int i = 0; !(i >= this.getRegistryPath().length || this.registryPath[i].hasHandleEntityInvalidationSetSupport() && (string3 = this.registryPath[i].getHandleEntityInvalidation(string, string2)) != null); ++i) {
        }
        return string3;
    }

    public String getHandleEntityInvalidation() throws XMLRegistryException {
        String string = null;
        for (int i = 0; !(i >= this.getRegistryPath().length || this.registryPath[i].hasHandleEntityInvalidationSetSupport() && (string = this.registryPath[i].getHandleEntityInvalidation()) != null); ++i) {
        }
        return string;
    }

    public boolean hasHandleEntityInvalidationSetSupport() {
        for (int i = 0; i < this.getRegistryPath().length; ++i) {
            if (!this.registryPath[i].hasHandleEntityInvalidationSetSupport()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        boolean bl;
        boolean bl2 = bl = this.status == null;
        if (bl) {
            this.status = new ReParsingStatus();
        }
        try {
            this.status.usedRegistryResolver = true;
            if (this.status.lastEntity != null) {
                InputSourceUtil.resetInputSource(this.status.lastEntity);
            }
            InputSource inputSource = this.status.lastEntity = this.resolveEntityI(string, string2, true);
            Object var6_5 = null;
            if (bl) {
                this.status = null;
            }
            return inputSource;
        }
        catch (Throwable throwable) {
            block5: {
                Object var6_6 = null;
                if (!bl) break block5;
                this.status = null;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputSource resolveEntityI(String string, String string2, boolean bl) throws SAXException, IOException {
        InputSource inputSource = null;
        String string3 = Tools.getEntityDescriptor(string, string2, null);
        this.status.usedCache = true;
        for (int i = 0; i < this.registryPath.length; ++i) {
            XMLRegistry xMLRegistry = this.registryPath[i];
            ResolveContext resolveContext = new ResolveContext();
            resolveContext.desc = string3;
            try {
                inputSource = this.getEntityFromCache(xMLRegistry, string, string2, false, resolveContext);
                if (inputSource == null && resolveContext.expired && this.status.isReParsing()) {
                    inputSource = this.getEntityFromCache(xMLRegistry, string, string2, true, resolveContext);
                }
                if (!this.status.isReParsing() && inputSource == null || this.status.isReParsing() && InputSourceUtil.isEqual(inputSource, this.status.lastEntity)) {
                    Object var12_13;
                    RefreshCacheLock refreshCacheLock = xMLRegistry.getLock();
                    try {
                        refreshCacheLock.lock(string, string2);
                        inputSource = this.getEntityFromCache(xMLRegistry, string, string2, false, resolveContext);
                        if (inputSource == null && resolveContext.expired && this.status.isReParsing()) {
                            inputSource = this.getEntityFromCache(xMLRegistry, string, string2, true, resolveContext);
                        }
                        if (!this.status.isReParsing() && inputSource == null || this.status.isReParsing() && InputSourceUtil.isEqual(inputSource, this.status.lastEntity)) {
                            XMLRegistry.ResolvedEntity resolvedEntity = this.getEntityFromNonCache(xMLRegistry, string, string2, resolveContext);
                            InputSource inputSource2 = inputSource = resolvedEntity != null ? resolvedEntity.inputSource() : null;
                            if (inputSource != null) {
                                this.status.usedCache = false;
                                if (bl && resolvedEntity.isSubjectToCaching()) {
                                    this.addToCache(xMLRegistry, resolvedEntity, string, string2, resolveContext);
                                }
                            }
                        }
                        var12_13 = null;
                        refreshCacheLock.unlock(string, string2);
                    }
                    catch (Throwable throwable) {
                        var12_13 = null;
                        refreshCacheLock.unlock(string, string2);
                        throw throwable;
                    }
                }
                if (inputSource == null && resolveContext.expired) {
                    inputSource = this.getEntityFromCache(xMLRegistry, string, string2, true, resolveContext);
                }
                if (inputSource == null && resolveContext.remoteAccessException != null) {
                    throw resolveContext.remoteAccessException;
                }
            }
            catch (XMLRegistryException xMLRegistryException) {
                throw new SAXException((Exception)((Object)xMLRegistryException));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            if (inputSource != null) break;
        }
        if (this.status.isReParsing() && InputSourceUtil.isEqual(inputSource, this.status.lastEntity)) {
            throw new ReParsingEntityNotChangedException();
        }
        return inputSource;
    }

    private InputSource getEntityFromCache(XMLRegistry xMLRegistry, String string, String string2, boolean bl, ResolveContext resolveContext) throws XMLRegistryException, IOException {
        InputSource inputSource = null;
        EntityCache entityCache = xMLRegistry.getCache();
        if (entityCache == null) {
            return inputSource;
        }
        if (bl) {
            entityCache.renew(string, string2);
        }
        try {
            inputSource = entityCache.get(string, string2);
            InputSourceUtil.transformInputSource(inputSource);
        }
        catch (XMLRegistryExceptionCacheEntryExpired xMLRegistryExceptionCacheEntryExpired) {
            resolveContext.expired = true;
        }
        catch (XMLRegistryException xMLRegistryException) {
            XMLLogger.logEntityCacheBroken();
        }
        return inputSource;
    }

    private XMLRegistry.ResolvedEntity getEntityFromNonCache(XMLRegistry xMLRegistry, String string, String string2, ResolveContext resolveContext) throws XMLRegistryException, IOException {
        try {
            XMLRegistry.ResolvedEntity resolvedEntity = xMLRegistry.getEntity(string, string2);
            if (resolvedEntity != null) {
                InputSourceUtil.transformInputSource(resolvedEntity.inputSource());
            }
            return resolvedEntity;
        }
        catch (XMLRegistryRemoteAccessException xMLRegistryRemoteAccessException) {
            resolveContext.remoteAccessException = xMLRegistryRemoteAccessException;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addToCache(XMLRegistry xMLRegistry, XMLRegistry.ResolvedEntity resolvedEntity, String string, String string2, ResolveContext resolveContext) throws IllegalArgumentException, IOException {
        try {
            EntityCache entityCache = xMLRegistry.getCache();
            if (entityCache == null) {
                return;
            }
            InputSource inputSource = resolvedEntity.inputSource();
            int n = xMLRegistry.getCacheTimeoutInterval(resolvedEntity.getEntry());
            boolean bl = true;
            bl = !resolvedEntity.isLocal();
            try {
                try {
                    entityCache.add(inputSource, bl, n * 1000);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Object var12_12 = null;
                    InputSourceUtil.resetInputSource(inputSource);
                    return;
                }
                catch (CX.EntryTooLarge entryTooLarge) {
                    Object var12_13 = null;
                    InputSourceUtil.resetInputSource(inputSource);
                    return;
                }
                catch (XMLRegistryException xMLRegistryException) {
                    XMLLogger.logEntityCacheBroken();
                    Object var12_14 = null;
                    InputSourceUtil.resetInputSource(inputSource);
                    return;
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                InputSourceUtil.resetInputSource(inputSource);
                throw throwable;
            }
            InputSourceUtil.resetInputSource(inputSource);
            return;
        }
        catch (XMLRegistryException xMLRegistryException) {
            // empty catch block
        }
    }

    public void hookStatus(ReParsingStatus reParsingStatus) {
        this.status = reParsingStatus;
    }

    private class ResolveContext {
        public String desc = null;
        public boolean expired = false;
        public XMLRegistryRemoteAccessException remoteAccessException = null;

        private ResolveContext() {
        }
    }
}

