/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.registry;

import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.XmlBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.xml.registry.XMLRegistry;
import weblogic.xml.registry.XMLRegistryException;

public class XMLModule
implements Module {
    private static boolean debug = false;
    private AppDeploymentMBean deployableMBean;
    private ApplicationContext appCtx;
    private XmlBean xmlDD;
    private final String WEBLOGIC_APPLICATION_DESCRIPTOR = "weblogic-application.xml";
    private final String REGISTRY_DIR = "lib/xml/registry";
    private String[] changedFiles = null;
    private boolean loadDescriptorEnabled = false;
    private boolean cleanUp = false;
    private boolean cleanUpCache = false;
    private boolean reInitialize = true;
    private ClassLoader classLoader;

    public XMLModule(XmlBean xmlBean) {
        this.xmlDD = xmlBean;
    }

    public String getId() {
        return "weblogic.xml.registry.XMLModule";
    }

    public String getType() {
        return null;
    }

    public DescriptorBean[] getDescriptors() {
        if (this.xmlDD != null) {
            return new DescriptorBean[]{(DescriptorBean)this.xmlDD};
        }
        return new DescriptorBean[0];
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return new ComponentRuntimeMBean[0];
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.init(applicationContext, genericClassLoader, registration);
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.classLoader = genericClassLoader;
        this.appCtx = applicationContext;
        this.deployableMBean = applicationContext.getAppDeploymentMBean();
        return genericClassLoader;
    }

    public void setDelta(String[] stringArray, long[] lArray) {
        this.changedFiles = stringArray;
        if (debug) {
            Debug.say((String)("ChangedFiles is " + stringArray));
        }
        if (stringArray == null) {
            this.reInitialize = true;
            return;
        }
        if (debug) {
            Debug.say((String)("Changed Files length is : " + stringArray.length));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].endsWith("weblogic-application.xml")) {
                if (debug) {
                    Debug.say((String)"----> weblogic-application.xml descriptor has changes");
                }
                this.reInitialize = true;
                this.cleanUp = true;
            }
            if (!stringArray[i].startsWith("lib/xml/registry")) continue;
            this.cleanUpCache = true;
        }
    }

    public void prepare() throws ModuleException {
        Object object;
        if (this.cleanUp) {
            try {
                XMLRegistry.cleanUpAppScopedXMLRegistry(this.deployableMBean.getName());
            }
            catch (XMLRegistryException xMLRegistryException) {
                throw new ModuleException(xMLRegistryException.getMessage());
            }
        }
        if (this.reInitialize) {
            if (debug) {
                Debug.say((String)"Preparing XMLModule ------>>>>>> \n ");
            }
            try {
                object = ((ApplicationContextInternal)this.appCtx).getStagingPath();
                if (debug) {
                    Debug.say((String)("---------> Path is " + (String)object));
                }
                XMLRegistry.initializeAppScopedXMLRegistry(this.xmlDD, this.deployableMBean, (String)object);
            }
            catch (XMLRegistryException xMLRegistryException) {
                throw new ModuleException(xMLRegistryException.getMessage());
            }
        }
        if (!this.cleanUp && this.cleanUpCache) {
            try {
                object = XMLRegistry.getXMLRegistry(this.appCtx.getApplicationId());
                ((XMLRegistry)object).cleanUpCache(this.changedFiles);
            }
            catch (XMLRegistryException xMLRegistryException) {
                throw new ModuleException(xMLRegistryException.getMessage());
            }
        }
        this.cleanUp = false;
        this.cleanUpCache = false;
        this.reInitialize = false;
    }

    public void unprepare() throws IllegalStateException, ModuleException {
        try {
            if (debug) {
                Debug.say((String)"----> Rolling Back XML Module ");
            }
            XMLRegistry.cleanUpAppScopedXMLRegistry(this.deployableMBean.getName());
        }
        catch (XMLRegistryException xMLRegistryException) {
            throw new ModuleException((Throwable)((Object)xMLRegistryException));
        }
        catch (Exception exception) {
            throw new ModuleException(exception);
        }
    }

    public void activate() {
    }

    public void start() {
    }

    public void destroy(UpdateListener.Registration registration) {
    }

    public void deactivate() throws IllegalStateException, ModuleException {
    }

    public void remove() throws IllegalStateException, ModuleException {
    }

    public void adminToProduction() {
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) {
    }

    public void forceProductionToAdmin() {
    }
}

