/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.registry;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationFactoryManager;
import weblogic.j2ee.descriptor.wl.ParserFactoryBean;
import weblogic.j2ee.descriptor.wl.XmlBean;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.XMLEntityCacheMBean;
import weblogic.management.configuration.XMLEntitySpecRegistryEntryMBean;
import weblogic.management.configuration.XMLParserSelectRegistryEntryMBean;
import weblogic.management.configuration.XMLRegistryMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.xml.XMLLogger;
import weblogic.xml.jaxp.XMLContext;
import weblogic.xml.registry.ConfigAbstraction;
import weblogic.xml.registry.DocumentType;
import weblogic.xml.registry.EntityCache;
import weblogic.xml.registry.RefreshCacheLock;
import weblogic.xml.registry.RegistryEntityResolver;
import weblogic.xml.registry.XMLAbstractRegistryEntry;
import weblogic.xml.registry.XMLEntitySpecRegistryEntry;
import weblogic.xml.registry.XMLModuleFactory;
import weblogic.xml.registry.XMLParserSelectRegistryEntry;
import weblogic.xml.registry.XMLRegistryDir;
import weblogic.xml.registry.XMLRegistryException;
import weblogic.xml.registry.XMLRegistryRemoteAccessException;
import weblogic.xml.util.Tools;
import weblogic.xml.util.XMLConstants;
import weblogic.xml.util.cache.entitycache.EntityCache;
import weblogic.xml.util.cache.entitycache.EntityCacheCumulativeStats;
import weblogic.xml.util.cache.entitycache.EntityCacheCurrentStats;
import weblogic.xml.util.cache.entitycache.Event;

public class XMLRegistry
implements XMLConstants {
    private static final String defaultAppName = "BEAWeblogicDefaultApplicationContext";
    private static final double MemCheckFactor = 0.5;
    private static Hashtable registryExtent = new Hashtable();
    private static final int defaultCacheTimeoutInterval = 120;
    EntityCacheCumulativeStats sessionCacheStatsMBean = null;
    EntityCacheCumulativeStats historicalCacheStatsMBean = null;
    EntityCacheCurrentStats currentCacheStatsMBean = null;
    private static XMLRegistry defaultRegistry = null;
    private static ServerListener serverListener = null;
    private RegistryListener registryListener = null;
    private final String REGISTRY_DIR = "lib/xml/registry";
    private boolean isAppScopedRegistry = false;
    private boolean cleanupTempEntities = false;
    private AppDeploymentMBean deployableMBean = null;
    private final ApplicationAccess applicationAccess = ApplicationAccess.getApplicationAccess();
    private CacheListener cacheListener = null;
    private HashSet newEntitySpecMBeans = new HashSet();
    private HashSet newParserSelectMBeans = new HashSet();
    private static XMLRegistryMBean xmlDefaultRegistryAdminMBean = null;
    private XMLRegistryMBean xmlRegistryConfigMBean = null;
    private ConfigAbstraction.RegistryConfig config = null;
    private String privateRegistryDir;
    private String basePath = null;
    private String registryName;
    private String applicationName = null;
    private XMLRegistryDir publicRegistryDir;
    private Map psIndex = new HashMap();
    private Map esIndex = new HashMap();
    private boolean hasCustomParserEntries = false;
    private boolean hasDocumentSpecificParserEntries = false;
    private boolean hasDocumentSpecificEntityEntries = false;
    private static weblogic.xml.util.cache.entitycache.EntityCache underlyingCache = null;
    private EntityCache entityCache = null;
    private static RefreshCacheLock lock = new RefreshCacheLock(10);
    private int cacheDefaultTimeoutInterval = -1;
    static XMLEntityCacheMBean cacheConfigMBean = null;
    static ServerMBean serverConfigMBean = null;

    static void init() throws XMLRegistryException {
        ApplicationFactoryManager applicationFactoryManager = ApplicationFactoryManager.getApplicationFactoryManager();
        applicationFactoryManager.addWLAppModuleFactory(new XMLModuleFactory());
        XMLContext.init();
        try {
            XMLRegistry.initializeDefaultRegistry();
        }
        catch (XMLRegistryException xMLRegistryException) {
            throw xMLRegistryException;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private XMLRegistry(XMLRegistryMBean xMLRegistryMBean, String string) throws XMLRegistryException {
        this.xmlRegistryConfigMBean = xMLRegistryMBean;
        this.privateRegistryDir = "lib/xml/registry";
        this.applicationName = string;
        this.loadPrivateRegistry();
        this.installRegistryInstance(string);
    }

    private XMLRegistry(XmlBean xmlBean, String string, String string2) throws XMLRegistryException {
        this.basePath = string2;
        try {
            this.applicationName = string;
            this.config = ConfigAbstraction.getRegistryConfig(xmlBean, this.applicationName);
            this.registryName = "_._" + this.config.getName();
            this.setUpEntityCache();
        }
        catch (Exception exception) {
            throw new XMLRegistryException(exception);
        }
        this.installRegistryInstance(string);
    }

    static ServerMBean getServerConfigMBean() {
        if (serverConfigMBean == null) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            serverConfigMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServer();
        }
        return serverConfigMBean;
    }

    private XMLRegistryMBean getRegistryConfigMBean() {
        if (this.xmlRegistryConfigMBean == null) {
            this.xmlRegistryConfigMBean = XMLRegistry.getServerConfigMBean().getXMLRegistry();
        }
        return this.xmlRegistryConfigMBean;
    }

    private static XMLRegistryMBean getRegistryConfigMBeanStatic() {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        return ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getXMLRegistry();
    }

    XMLRegistryMBean getXMLRegistryMBean(String string) {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(authenticatedSubject);
        DomainMBean domainMBean = runtimeAccess.getDomain();
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        if (serverMBeanArray == null) {
            return null;
        }
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            XMLRegistryMBean xMLRegistryMBean = serverMBeanArray[i].getXMLRegistry();
            if (xMLRegistryMBean == null || !xMLRegistryMBean.getName().equals(string)) continue;
            return xMLRegistryMBean;
        }
        return null;
    }

    static XMLEntityCacheMBean getCacheConfigMBean() {
        if (cacheConfigMBean == null) {
            try {
                cacheConfigMBean = XMLRegistry.getServerConfigMBean().getXMLEntityCache();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cacheConfigMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeDefaultRegistry() throws XMLRegistryException {
        Class<XMLRegistry> clazz = XMLRegistry.class;
        synchronized (XMLRegistry.class) {
            XMLRegistryMBean xMLRegistryMBean = XMLRegistry.getRegistryConfigMBeanStatic();
            defaultRegistry = new XMLRegistry(xMLRegistryMBean, defaultAppName);
            defaultRegistry.loadFromMBean(XMLRegistry.getRegistryConfigMBeanStatic());
            if (serverListener == null) {
                serverListener = new ServerListener();
                serverConfigMBean.addPropertyChangeListener(serverListener);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private AppDeploymentMBean getAppDeploymentMBean() {
        return this.deployableMBean;
    }

    static void initializeAppScopedXMLRegistry(XmlBean xmlBean, AppDeploymentMBean appDeploymentMBean, String string) throws XMLRegistryException {
        String string2 = appDeploymentMBean.getName();
        XMLRegistry xMLRegistry = new XMLRegistry(xmlBean, string2, string);
        xMLRegistry.isAppScopedRegistry = true;
        xMLRegistry.cleanupTempEntities = true;
        xMLRegistry.deployableMBean = appDeploymentMBean;
        xMLRegistry.loadPublicEntries();
        ParserFactoryBean parserFactoryBean = xmlBean.getParserFactory();
        xMLRegistry.basePath = string;
    }

    static void cleanUpAppScopedXMLRegistry(String string) throws XMLRegistryException {
        XMLRegistry xMLRegistry = XMLRegistry.getXMLRegistry(string);
        xMLRegistry.cleanupTempEntities = true;
        for (XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry : xMLRegistry.esIndex.values()) {
            ConfigAbstraction.EntryConfig entryConfig;
            PropertyChangeListener propertyChangeListener;
            if (xMLRegistry.getCache() != null) {
                xMLRegistry.getCache().remove(xMLEntitySpecRegistryEntry.getPublicId(), xMLEntitySpecRegistryEntry.getSystemId());
            }
            if ((propertyChangeListener = xMLEntitySpecRegistryEntry.getListener()) != null && (entryConfig = xMLEntitySpecRegistryEntry.getMBean()) != null) {
                entryConfig.removePropertyChangeListener(propertyChangeListener);
            }
            xMLEntitySpecRegistryEntry.setListener(null);
        }
        registryExtent.remove(string);
        xMLRegistry.config = null;
    }

    void cleanUpCache(String[] stringArray) throws XMLRegistryException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("lib/xml/registry")) continue;
            if (stringArray[i].equals("lib/xml/registry")) {
                this.cleanUpCache();
                break;
            }
            for (XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry : this.esIndex.values()) {
                String string;
                if (xMLEntitySpecRegistryEntry.getEntityURI() == null || !(string = stringArray[i].substring("lib/xml/registry".length() + 1)).equals(xMLEntitySpecRegistryEntry.getEntityURI())) continue;
                this.getCache().remove(xMLEntitySpecRegistryEntry.getPublicId(), xMLEntitySpecRegistryEntry.getSystemId());
            }
        }
    }

    private void cleanUpCache() throws XMLRegistryException {
        for (XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry : this.esIndex.values()) {
            this.getCache().remove(xMLEntitySpecRegistryEntry.getPublicId(), xMLEntitySpecRegistryEntry.getSystemId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reinitializeDefaultRegistry() throws XMLRegistryException {
        Class<XMLRegistry> clazz = XMLRegistry.class;
        synchronized (XMLRegistry.class) {
            defaultRegistry.cleanupRegistry();
            XMLRegistry.initializeDefaultRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            XMLRegistry.defaultRegistry.config.removePropertyChangeListener(XMLRegistry.defaultRegistry.registryListener);
            XMLRegistry.defaultRegistry.registryListener = null;
            return;
        }
    }

    private void cleanupRegistry() {
        Object object;
        defaultRegistry = null;
        xmlDefaultRegistryAdminMBean = null;
        if (this.config != null) {
            this.config.removePropertyChangeListener(this.registryListener);
        }
        this.registryListener = null;
        for (Object object2 : this.psIndex.values()) {
            Object object3 = ((XMLAbstractRegistryEntry)object2).getListener();
            if (object3 != null && (object = ((XMLAbstractRegistryEntry)object2).getMBean()) != null) {
                object.removePropertyChangeListener((PropertyChangeListener)object3);
            }
            ((XMLAbstractRegistryEntry)object2).setListener(null);
        }
        for (Object object3 : this.esIndex.values()) {
            ConfigAbstraction.EntryConfig entryConfig;
            object = ((XMLAbstractRegistryEntry)object3).getListener();
            if (object != null && (entryConfig = ((XMLAbstractRegistryEntry)object3).getMBean()) != null) {
                entryConfig.removePropertyChangeListener((PropertyChangeListener)object);
            }
            ((XMLAbstractRegistryEntry)object3).setListener(null);
        }
    }

    public String getName() {
        return this.registryName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public RefreshCacheLock getLock() {
        return lock;
    }

    public EntityCache getCache() throws XMLRegistryException {
        return this.entityCache;
    }

    private String getCacheBeanName() {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        return "XMLCacheMBean_" + ManagementService.getRuntimeAccess(authenticatedSubject).getServerName();
    }

    XMLEntityCacheMBean getEntityCacheMBean() {
        if (cacheConfigMBean == null) {
            cacheConfigMBean = XMLRegistry.getServerConfigMBean().getXMLEntityCache();
        }
        return cacheConfigMBean;
    }

    protected weblogic.xml.util.cache.entitycache.EntityCache getUnderlyingCache() throws XMLRegistryException {
        block7: {
            if (underlyingCache == null) {
                try {
                    XMLEntityCacheMBean xMLEntityCacheMBean = this.getEntityCacheMBean();
                    if (xMLEntityCacheMBean == null) {
                        return null;
                    }
                    String string = xMLEntityCacheMBean.getCacheLocation();
                    String string2 = "XML-Entity-Cache";
                    int n = xMLEntityCacheMBean.getCacheMemorySize();
                    int n2 = xMLEntityCacheMBean.getCacheDiskSize();
                    EntityCache.CacheSpec cacheSpec = new EntityCache.CacheSpec();
                    cacheSpec.name = string2;
                    cacheSpec.path = string;
                    cacheSpec.memSize = n * 1000;
                    cacheSpec.diskSize = n2 * 1000000;
                    cacheSpec.cacheListener = new CacheLogListener();
                    underlyingCache = weblogic.xml.util.cache.entitycache.EntityCache.getCache(cacheSpec, cacheConfigMBean);
                    if (underlyingCache == null) break block7;
                    Runtime runtime = Runtime.getRuntime();
                    try {
                        long l = runtime.freeMemory();
                        if (!((double)n > (double)l * 0.5)) break block7;
                        if ((long)n > l) {
                            XMLLogger.logCacheMemoryWarningExceeds((long)n, (long)l);
                            break block7;
                        }
                        XMLLogger.logCacheMemoryWarningClose((long)n, (long)l);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    throw new XMLRegistryException(exception);
                }
            }
        }
        return underlyingCache;
    }

    private void loadFromMBean(XMLRegistryMBean xMLRegistryMBean) throws XMLRegistryException {
        if (xMLRegistryMBean != null) {
            this.config = ConfigAbstraction.getRegistryConfig(xMLRegistryMBean);
            this.registryName = xMLRegistryMBean.getName();
            if (this.registryName == null || this.registryName.length() == 0) {
                String string = "Registry does not have a name";
                throw new XMLRegistryException(string);
            }
            this.publicRegistryDir = new XMLRegistryDir(this.registryName);
            this.setUpEntityCache();
            this.loadPublicRegistry();
            this.registryListener = new RegistryListener(this);
            this.config.addPropertyChangeListener(this.registryListener);
        }
    }

    private void installRegistryInstance(String string) {
        registryExtent.put(string, this);
    }

    public static XMLRegistry getXMLRegistry(String string) {
        return (XMLRegistry)registryExtent.get(string);
    }

    private void setUpEntityCache() throws XMLRegistryException {
        weblogic.xml.util.cache.entitycache.EntityCache entityCache = this.getUnderlyingCache();
        if (entityCache != null) {
            this.entityCache = new EntityCache(this, entityCache);
            XMLEntityCacheMBean xMLEntityCacheMBean = this.getEntityCacheMBean();
            if (xMLEntityCacheMBean != null) {
                this.cacheListener = new CacheListener(this);
                xMLEntityCacheMBean.addPropertyChangeListener(this.cacheListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLRegistry[] getXMLRegistryPath() throws XMLRegistryException {
        XMLRegistry[] xMLRegistryArray = null;
        String string = null;
        string = ApplicationAccess.getApplicationAccess().getCurrentApplicationName();
        if (string == null) {
            string = defaultAppName;
        }
        Class<XMLRegistry> clazz = XMLRegistry.class;
        synchronized (XMLRegistry.class) {
            XMLRegistry xMLRegistry = null;
            xMLRegistry = (XMLRegistry)registryExtent.get(string);
            if (xMLRegistry == null && defaultRegistry == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return new XMLRegistry[0];
            }
            xMLRegistryArray = xMLRegistry == null || xMLRegistry == defaultRegistry ? new XMLRegistry[]{defaultRegistry} : new XMLRegistry[]{xMLRegistry, defaultRegistry};
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return xMLRegistryArray;
        }
    }

    void setCacheDefaultTimeoutInterval(int n) {
        this.cacheDefaultTimeoutInterval = n;
    }

    public int getCacheTimeoutInterval(String string, String string2) throws XMLRegistryException {
        XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry = this.lookupEntitySpecEntry(string, string2);
        return this.getCacheTimeoutInterval(xMLEntitySpecRegistryEntry);
    }

    int getCacheTimeoutInterval(XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry) throws XMLRegistryException {
        int n = xMLEntitySpecRegistryEntry.getCacheTimeoutInterval();
        if (n < 0) {
            if (this.cacheDefaultTimeoutInterval == -1) {
                XMLEntityCacheMBean xMLEntityCacheMBean = this.getEntityCacheMBean();
                if (xMLEntityCacheMBean != null) {
                    try {
                        this.cacheDefaultTimeoutInterval = xMLEntityCacheMBean.getCacheTimeoutInterval();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                if (this.cacheDefaultTimeoutInterval == -1) {
                    this.cacheDefaultTimeoutInterval = 120;
                }
            }
            n = this.cacheDefaultTimeoutInterval;
        }
        return n;
    }

    public ResolvedEntity getEntity(String string, String string2) throws XMLRegistryException {
        InputStream inputStream;
        String string3;
        ResolvedEntity resolvedEntity = new ResolvedEntity();
        String string4 = Tools.getEntityDescriptor(string, string2, null);
        XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry = this.lookupEntitySpecEntry(string, string2);
        InputSource inputSource = null;
        if (xMLEntitySpecRegistryEntry != null && (string3 = xMLEntitySpecRegistryEntry.getEntityURI()) != null && (inputStream = this.retrieveEntity(string3)) != null) {
            inputSource = new InputSource(inputStream);
            inputSource.setSystemId(string2);
            inputSource.setPublicId(string);
            resolvedEntity.inputSource = inputSource;
            resolvedEntity.entry = xMLEntitySpecRegistryEntry;
            String string5 = xMLEntitySpecRegistryEntry.getWhenToCache();
            String string6 = this.applicationAccess.getCurrentApplicationName();
            if (string5 == null || string5.equals("defer-to-registry-setting")) {
                string5 = this.config.getWhenToCache();
            }
            if (string5 != null && string5.equals("cache-never")) {
                resolvedEntity.isSubjectToCaching = false;
            }
            resolvedEntity.isLocal = inputStream instanceof FileInputStream || this.publicRegistryDir != null && this.publicRegistryDir.isLocal();
        }
        return resolvedEntity;
    }

    public Parser getParser(String string, String string2, String string3) throws XMLRegistryException {
        String string4;
        XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry = this.lookupParserSelectEntry(string, string2, string3);
        Parser parser2 = null;
        if (xMLParserSelectRegistryEntry != null && (string4 = xMLParserSelectRegistryEntry.getParserClassName()) != null) {
            try {
                Object obj = Class.forName(string4).newInstance();
                if (obj instanceof XMLReader) {
                    XMLReader xMLReader = (XMLReader)obj;
                    parser2 = new XMLReaderAdapter(xMLReader);
                } else {
                    parser2 = (Parser)obj;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new XMLRegistryException("ClassNotFoundException. Class " + classNotFoundException.getMessage() + " cannot be located.", classNotFoundException);
            }
            catch (ClassCastException classCastException) {
                throw new XMLRegistryException("ClassCastException. Class " + classCastException.getMessage() + " is not of type org.xml.sax.Parser.", classCastException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XMLRegistryException("IllegalAccessException. Class " + illegalAccessException.getMessage() + " is not accessible.", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new XMLRegistryException("InstantiationException. " + instantiationException.getMessage() + " Class instantiation fails. " + "This Class represents an abstract class, an interface, an array class, a primitive type, or void, or instantiation fails for some other reason", instantiationException);
            }
            catch (SecurityException securityException) {
                throw new XMLRegistryException("SecurityException. There is no permission to create a new instance " + securityException.getMessage(), securityException);
            }
            catch (Exception exception) {
                throw new XMLRegistryException(exception);
            }
        }
        return parser2;
    }

    public SAXParserFactory getSAXParserFactory(String string, String string2, String string3) throws XMLRegistryException {
        XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry = this.lookupParserSelectEntry(string, string2, string3);
        SAXParserFactory sAXParserFactory = null;
        if (xMLParserSelectRegistryEntry != null) {
            String string4 = xMLParserSelectRegistryEntry.getSAXParserFactory();
            String string5 = null;
            if (string4 != null) {
                try {
                    String string6 = this.applicationAccess.getCurrentApplicationName();
                    if (string6 != null && XMLRegistry.getXMLRegistry(string6) != null) {
                        Thread thread2 = Thread.currentThread();
                        ClassLoader classLoader = thread2.getContextClassLoader();
                        string5 = XMLRegistry.getXMLRegistry((String)string6).config.getSAXParserFactory();
                        if (string5 != null) {
                            sAXParserFactory = (SAXParserFactory)Class.forName(string5, true, classLoader).newInstance();
                        }
                    }
                    if (sAXParserFactory == null) {
                        sAXParserFactory = (SAXParserFactory)Class.forName(string4).newInstance();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new XMLRegistryException("ClassNotFoundException. Class " + classNotFoundException.getMessage() + " cannot be located.", classNotFoundException);
                }
                catch (ClassCastException classCastException) {
                    throw new XMLRegistryException("ClassCastException. Class " + classCastException.getMessage() + " is not of type javax.xml.parsers.SAXParserFactory.", classCastException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new XMLRegistryException("IllegalAccessException. Class " + illegalAccessException.getMessage() + " is not accessible.", illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    throw new XMLRegistryException("InstantiationException. " + instantiationException.getMessage() + " Class instantiation fails. " + "This Class represents an abstract class, an interface, an array class, a primitive type, or void, or instantiation fails for some other reason", instantiationException);
                }
                catch (SecurityException securityException) {
                    throw new XMLRegistryException("SecurityException. There is no permission to create a new instance " + securityException.getMessage(), securityException);
                }
                catch (Exception exception) {
                    throw new XMLRegistryException(exception);
                }
            }
        }
        return sAXParserFactory;
    }

    public SAXParserFactory getSAXParserFactory() throws XMLRegistryException {
        String string;
        SAXParserFactory sAXParserFactory = null;
        if (this.havePublicData() && (string = this.config.getSAXParserFactory()) != null) {
            try {
                String string2 = this.applicationAccess.getCurrentApplicationName();
                if (string2 != null && this.isAppScopedRegistry) {
                    Thread thread2 = Thread.currentThread();
                    ClassLoader classLoader = thread2.getContextClassLoader();
                    sAXParserFactory = (SAXParserFactory)Class.forName(string, true, classLoader).newInstance();
                } else {
                    sAXParserFactory = (SAXParserFactory)Class.forName(string).newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new XMLRegistryException("ClassNotFoundException. Class " + classNotFoundException.getMessage() + " cannot be located.", classNotFoundException);
            }
            catch (ClassCastException classCastException) {
                throw new XMLRegistryException("ClassCastException. Class " + classCastException.getMessage() + " is not of type javax.xml.parsers.SAXParserFactory.", classCastException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XMLRegistryException("IllegalAccessException. Class " + illegalAccessException.getMessage() + " is not accessible.", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new XMLRegistryException("InstantiationException. " + instantiationException.getMessage() + " Class instantiation fails. " + "This Class represents an abstract class, an interface, an array class, a primitive type, or void, or instantiation fails for some other reason", instantiationException);
            }
            catch (SecurityException securityException) {
                throw new XMLRegistryException("SecurityException. There is no permission to create a new instance " + securityException.getMessage(), securityException);
            }
            catch (Exception exception) {
                throw new XMLRegistryException(exception);
            }
        }
        return sAXParserFactory;
    }

    public TransformerFactory getTransformerFactory(String string, String string2, String string3) throws XMLRegistryException {
        String string4;
        XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry = this.lookupParserSelectEntry(string, string2, string3);
        TransformerFactory transformerFactory = null;
        String string5 = null;
        if (xMLParserSelectRegistryEntry != null && (string4 = xMLParserSelectRegistryEntry.getTransformerFactory()) != null) {
            try {
                String string6 = this.applicationAccess.getCurrentApplicationName();
                if (string6 != null && XMLRegistry.getXMLRegistry(string6) != null) {
                    Thread thread2 = Thread.currentThread();
                    ClassLoader classLoader = thread2.getContextClassLoader();
                    string5 = XMLRegistry.getXMLRegistry((String)string6).config.getTransformerFactory();
                    if (string5 != null) {
                        transformerFactory = (TransformerFactory)Class.forName(string5, true, classLoader).newInstance();
                    }
                }
                if (transformerFactory == null) {
                    transformerFactory = (TransformerFactory)Class.forName(string4).newInstance();
                }
            }
            catch (Exception exception) {
                throw new XMLRegistryException(exception);
            }
        }
        return transformerFactory;
    }

    public TransformerFactory getTransformerFactory() throws XMLRegistryException {
        String string;
        TransformerFactory transformerFactory = null;
        if (this.havePublicData() && (string = this.config.getTransformerFactory()) != null) {
            try {
                String string2 = this.applicationAccess.getCurrentApplicationName();
                if (string2 != null && this.isAppScopedRegistry) {
                    Thread thread2 = Thread.currentThread();
                    ClassLoader classLoader = thread2.getContextClassLoader();
                    transformerFactory = (TransformerFactory)Class.forName(string, true, classLoader).newInstance();
                } else {
                    transformerFactory = (TransformerFactory)Class.forName(string).newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new XMLRegistryException("ClassNotFoundException. Class " + classNotFoundException.getMessage() + " cannot be located.", classNotFoundException);
            }
            catch (ClassCastException classCastException) {
                throw new XMLRegistryException("ClassCastException. Class " + classCastException.getMessage() + " is not of type javax.xml.transform.TransformerFactory.", classCastException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XMLRegistryException("IllegalAccessException. Class " + illegalAccessException.getMessage() + " is not accessible.", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new XMLRegistryException("InstantiationException. " + instantiationException.getMessage() + " Class instantiation fails. " + "This Class represents an abstract class, an interface, an array class, a primitive type, or void, or instantiation fails for some other reason", instantiationException);
            }
            catch (SecurityException securityException) {
                throw new XMLRegistryException("SecurityException. There is no permission to create a new instance " + securityException.getMessage(), securityException);
            }
            catch (Exception exception) {
                throw new XMLRegistryException(exception);
            }
        }
        return transformerFactory;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory(String string, String string2, String string3) throws XMLRegistryException {
        XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry = this.lookupParserSelectEntry(string, string2, string3);
        DocumentBuilderFactory documentBuilderFactory = null;
        if (xMLParserSelectRegistryEntry != null) {
            String string4 = xMLParserSelectRegistryEntry.getDocumentBuilderFactory();
            String string5 = null;
            if (string4 != null) {
                try {
                    String string6 = this.applicationAccess.getCurrentApplicationName();
                    if (string6 != null && XMLRegistry.getXMLRegistry(string6) != null) {
                        Thread thread2 = Thread.currentThread();
                        ClassLoader classLoader = thread2.getContextClassLoader();
                        string5 = XMLRegistry.getXMLRegistry((String)string6).config.getDocumentBuilderFactory();
                        if (string5 != null) {
                            documentBuilderFactory = (DocumentBuilderFactory)Class.forName(string5, true, classLoader).newInstance();
                        }
                    }
                    if (documentBuilderFactory == null) {
                        documentBuilderFactory = (DocumentBuilderFactory)Class.forName(string4).newInstance();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new XMLRegistryException("ClassNotFoundException. Class " + classNotFoundException.getMessage() + " cannot be located.", classNotFoundException);
                }
                catch (ClassCastException classCastException) {
                    throw new XMLRegistryException("ClassCastException. Class " + classCastException.getMessage() + " is not of type javax.xml.parsers.DocumentBuilderFactory.", classCastException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new XMLRegistryException("IllegalAccessException. Class " + illegalAccessException.getMessage() + " is not accessible.", illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    throw new XMLRegistryException("InstantiationException. " + instantiationException.getMessage() + " Class instantiation fails. " + "This Class represents an abstract class, an interface, an array class, a primitive type, or void, or instantiation fails for some other reason", instantiationException);
                }
                catch (SecurityException securityException) {
                    throw new XMLRegistryException("SecurityException. There is no permission to create a new instance " + securityException.getMessage(), securityException);
                }
                catch (Exception exception) {
                    throw new XMLRegistryException(exception);
                }
            }
        }
        return documentBuilderFactory;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() throws XMLRegistryException {
        String string;
        DocumentBuilderFactory documentBuilderFactory = null;
        if (this.havePublicData() && (string = this.config.getDocumentBuilderFactory()) != null) {
            try {
                String string2 = this.applicationAccess.getCurrentApplicationName();
                if (string2 != null && this.isAppScopedRegistry) {
                    Thread thread2 = Thread.currentThread();
                    ClassLoader classLoader = thread2.getContextClassLoader();
                    documentBuilderFactory = (DocumentBuilderFactory)Class.forName(string, true, classLoader).newInstance();
                } else {
                    documentBuilderFactory = (DocumentBuilderFactory)Class.forName(string).newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new XMLRegistryException("ClassNotFoundException. Class " + classNotFoundException.getMessage() + " cannot be located.", classNotFoundException);
            }
            catch (ClassCastException classCastException) {
                throw new XMLRegistryException("ClassCastException. Class " + classCastException.getMessage() + " is not of type javax.xml.parsers.DocumentBuilderFactory.", classCastException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XMLRegistryException("IllegalAccessException. Class " + illegalAccessException.getMessage() + " is not accessible.", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new XMLRegistryException("InstantiationException. " + instantiationException.getMessage() + " Class instantiation fails. " + "This Class represents an abstract class, an interface, an array class, a primitive type, or void, or instantiation fails for some other reason", instantiationException);
            }
            catch (SecurityException securityException) {
                throw new XMLRegistryException("SecurityException. There is no permission to create a new instance " + securityException.getMessage(), securityException);
            }
            catch (Exception exception) {
                throw new XMLRegistryException(exception);
            }
        }
        return documentBuilderFactory;
    }

    public boolean hasDocumentSpecificParserEntries() {
        return this.hasDocumentSpecificParserEntries;
    }

    public boolean hasDocumentSpecificEntityEntries() {
        return this.hasDocumentSpecificEntityEntries;
    }

    public boolean hasCustomParserEntries() {
        return this.hasCustomParserEntries;
    }

    public boolean hasHandleEntityInvalidationSetSupport() {
        return !this.isAppScopedRegistry;
    }

    public String getHandleEntityInvalidation(String string, String string2) throws XMLRegistryException {
        if (!this.hasHandleEntityInvalidationSetSupport()) {
            return null;
        }
        String string3 = null;
        XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry = this.lookupEntitySpecEntry(string, string2);
        if (xMLEntitySpecRegistryEntry != null && (string3 = xMLEntitySpecRegistryEntry.getHandleEntityInvalidation()) != null && "defer-to-registry-setting".equals(string3)) {
            string3 = this.config.getHandleEntityInvalidation();
        }
        return string3;
    }

    public String getHandleEntityInvalidation() throws XMLRegistryException {
        if (!this.hasHandleEntityInvalidationSetSupport()) {
            return null;
        }
        if (this.havePublicData()) {
            return this.config.getHandleEntityInvalidation();
        }
        return null;
    }

    String getExtendedLibraryPath(String string) {
        return this.privateRegistryDir + File.separatorChar + string;
    }

    String getApplicationExtendedLibraryPath(String string) {
        return this.privateRegistryDir + "/" + string;
    }

    private boolean isURL(String string) {
        String string2 = string.trim().toLowerCase(Locale.ENGLISH);
        return string2.startsWith("http://") || string2.startsWith("file://") || string2.startsWith("jdbc:") || string2.startsWith("ftp://");
    }

    private InputStream retrieveEntity(String string) throws XMLRegistryException {
        if (this.isURL(string)) {
            return this.retrieveEntityFromURL(string);
        }
        if (this.basePath != null) {
            String string2 = this.basePath.toLowerCase(Locale.ENGLISH);
            return this.retrieveEntityFromApplication(string);
        }
        InputStream inputStream = null;
        inputStream = this.retrieveEntityFromLocalDirectory(string);
        if (inputStream == null) {
            inputStream = this.retrieveEntityFromAdminServer(string);
        }
        return inputStream;
    }

    private InputStream retrieveEntityFromURL(String string) throws XMLRegistryException {
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            String string2 = "Can't read provided URL: " + string;
            throw new XMLRegistryRemoteAccessException(string2, iOException);
        }
        return inputStream;
    }

    private InputStream retrieveEntityFromLocalDirectory(String string) throws XMLRegistryException {
        FileInputStream fileInputStream = null;
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.getExtendedLibraryPath(string));
        }
        if (file.exists()) {
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return fileInputStream;
    }

    private InputStream retrieveEntityFromAdminServer(String string) throws XMLRegistryException {
        InputStream inputStream = null;
        if (this.havePublicData()) {
            inputStream = this.publicRegistryDir.getEntity(string);
        }
        return inputStream;
    }

    private InputStream retrieveEntityFromZip(String string) throws XMLRegistryException {
        InputStream inputStream = null;
        ZipFile zipFile = null;
        this.basePath = "d:/weblogic/src_131sj/config/mydomain/mydeployments/examples/examples.ear";
        try {
            zipFile = new ZipFile(this.basePath);
        }
        catch (IOException iOException) {
            return null;
        }
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry != null) {
            try {
                inputStream = zipFile.getInputStream(zipEntry);
            }
            catch (IOException iOException) {
                throw new XMLRegistryException("Can't read zip entry: " + string + " in zip: " + this.basePath, iOException);
            }
        }
        return inputStream;
    }

    private InputStream retrieveEntityFromApplication(String string) throws XMLRegistryException {
        Object object;
        Object object2;
        File file = null;
        InputStream inputStream = null;
        VirtualJarFile virtualJarFile = null;
        try {
            object2 = ApplicationAccess.getApplicationAccess();
            object = ((ApplicationAccess)object2).getApplicationContext(this.getAppDeploymentMBean().getName());
            if (object == null) {
                return null;
            }
            virtualJarFile = object.getApplicationFileManager().getVirtualJarFile();
        }
        catch (IOException iOException) {
            return null;
        }
        object2 = virtualJarFile.getEntry("lib/xml/registry/" + string);
        try {
            if (!new File(this.basePath).isDirectory()) {
                object = null;
                File file2 = new File(this.basePath).getParentFile();
                if (file2.isDirectory()) {
                    file = new File(file2, string);
                    if (this.cleanupTempEntities) {
                        if (file.getParentFile() != null && !file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                            file.getParentFile().deleteOnExit();
                        }
                        file.createNewFile();
                        file.deleteOnExit();
                        object = new BufferedOutputStream(new FileOutputStream(file));
                        InputStream inputStream2 = virtualJarFile.getInputStream((ZipEntry)object2);
                        byte[] byArray = new byte[4096];
                        int n = 0;
                        while ((n = inputStream2.read(byArray, 0, 4096)) != -1) {
                            ((BufferedOutputStream)object).write(byArray, 0, n);
                        }
                        ((BufferedOutputStream)object).flush();
                        inputStream2.close();
                        ((FilterOutputStream)object).close();
                        if (!this.isAppScopedRegistry) {
                            this.cleanupTempEntities = false;
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new XMLRegistryException("Can't read zip entry: " + string + " in zip: " + this.basePath, iOException);
        }
        if (object2 != null) {
            object = null;
            try {
                inputStream = !new File(this.basePath).isDirectory() ? this.retrieveEntityFromLocalDirectory(file.getAbsolutePath()) : virtualJarFile.getInputStream((ZipEntry)object2);
            }
            catch (IOException iOException) {
                throw new XMLRegistryException("Can't read zip entry: " + string + " in zip: " + this.basePath, iOException);
            }
        }
        try {
            virtualJarFile.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return inputStream;
    }

    private void loadPrivateRegistry() throws XMLRegistryException {
        this.psIndex = new HashMap();
        this.esIndex = new HashMap();
        this.initializePrivateEntries();
    }

    private void loadPublicRegistry() throws XMLRegistryException {
        if (this.havePublicData()) {
            this.hasCustomParserEntries = false;
            this.hasDocumentSpecificParserEntries = false;
            this.hasDocumentSpecificEntityEntries = false;
            this.loadPublicEntries();
        }
        this.preLoadCache();
    }

    void preLoadCache() {
        if (!this.havePublicData()) {
            return;
        }
        RegistryEntityResolver registryEntityResolver = null;
        Iterator iterator = this.esIndex.values().iterator();
        while (iterator.hasNext()) {
            InputSource inputSource = null;
            XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry = (XMLEntitySpecRegistryEntry)iterator.next();
            String string = Tools.getEntityDescriptor(xMLEntitySpecRegistryEntry.getPublicId(), xMLEntitySpecRegistryEntry.getSystemId());
            String string2 = xMLEntitySpecRegistryEntry.getWhenToCache();
            if (string2 == null || string2.equals("defer-to-registry-setting")) {
                string2 = this.config.getWhenToCache();
            }
            if (string2 == null || !string2.equals("cache-at-initialization")) continue;
            if (registryEntityResolver == null) {
                try {
                    registryEntityResolver = new RegistryEntityResolver(new XMLRegistry[]{this});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                inputSource = registryEntityResolver.resolveEntity(xMLEntitySpecRegistryEntry.getPublicId(), xMLEntitySpecRegistryEntry.getSystemId());
            }
            catch (Exception exception) {}
        }
    }

    private XMLParserSelectRegistryEntry lookupParserSelectEntry(String string, String string2, String string3) throws XMLRegistryException {
        if (string == null && string2 == null && string3 == null) {
            throw new XMLRegistryException("Invalid parameters: at least one of publicId, systemId, rootTag must be non-null");
        }
        for (Object object : this.psIndex.values()) {
            if (!this.matches((XMLAbstractRegistryEntry)object, string, string2, string3)) continue;
            return object;
        }
        for (Object object : this.newParserSelectMBeans) {
            if (!this.matchesParserSelectMBean((XMLParserSelectRegistryEntryMBean)object, string, string2, null)) continue;
            XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry = this.loadParserSelectEntry(ConfigAbstraction.getParserSelectEntryConfig((XMLParserSelectRegistryEntryMBean)object), true);
            this.newParserSelectMBeans.remove(object);
            return xMLParserSelectRegistryEntry;
        }
        return null;
    }

    private XMLEntitySpecRegistryEntry lookupEntitySpecEntry(String string, String string2) throws XMLRegistryException {
        if (string == null && string2 == null) {
            throw new XMLRegistryException("Invalid parameters: at least one of publicId or systemId must be non-null");
        }
        for (Object object : this.esIndex.values()) {
            if (!this.matches((XMLAbstractRegistryEntry)object, string, string2, null)) continue;
            return object;
        }
        for (Object object : this.newEntitySpecMBeans) {
            if (!this.matchesEntitySpecMBean((XMLEntitySpecRegistryEntryMBean)object, string, string2, null)) continue;
            XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry = this.loadEntitySpecEntry(ConfigAbstraction.getEntitySpecEntryConfig((XMLEntitySpecRegistryEntryMBean)object), true);
            this.newEntitySpecMBeans.remove(object);
            return xMLEntitySpecRegistryEntry;
        }
        return null;
    }

    private boolean matches(XMLAbstractRegistryEntry xMLAbstractRegistryEntry, String string, String string2, String string3) {
        if (string != null && string.equals(xMLAbstractRegistryEntry.getPublicId())) {
            return true;
        }
        if (string2 != null && string2.equals(xMLAbstractRegistryEntry.getSystemId())) {
            return true;
        }
        return string3 != null && string3.equals(xMLAbstractRegistryEntry.getRootElementTag());
    }

    private boolean matchesParserSelectMBean(XMLParserSelectRegistryEntryMBean xMLParserSelectRegistryEntryMBean, String string, String string2, String string3) {
        if (string != null && string.equals(xMLParserSelectRegistryEntryMBean.getPublicId())) {
            return true;
        }
        return string2 != null && string2.equals(xMLParserSelectRegistryEntryMBean.getSystemId());
    }

    private boolean matchesEntitySpecMBean(XMLEntitySpecRegistryEntryMBean xMLEntitySpecRegistryEntryMBean, String string, String string2, String string3) {
        if (string != null && string.equals(xMLEntitySpecRegistryEntryMBean.getPublicId())) {
            return true;
        }
        return string2 != null && string2.equals(xMLEntitySpecRegistryEntryMBean.getSystemId());
    }

    private void loadPublicEntries() throws XMLRegistryException {
        Enumeration enumeration;
        if (!this.havePublicData()) {
            return;
        }
        if (!this.isAppScopedRegistry) {
            enumeration = this.config.getParserSelectRegistryEntries();
            while (enumeration != null && enumeration.hasMoreElements()) {
                this.loadParserSelectEntry((ConfigAbstraction.ParserSelectEntryConfig)enumeration.nextElement(), true);
            }
        }
        enumeration = this.config.getEntitySpecRegistryEntries();
        while (enumeration.hasMoreElements()) {
            this.loadEntitySpecEntry((ConfigAbstraction.EntitySpecEntryConfig)enumeration.nextElement(), true);
        }
    }

    private synchronized XMLParserSelectRegistryEntry loadParserSelectEntry(ConfigAbstraction.ParserSelectEntryConfig parserSelectEntryConfig, boolean bl) {
        XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry = this.readParserSelectEntry(parserSelectEntryConfig);
        if (this.hasCustomParser(xMLParserSelectRegistryEntry)) {
            this.hasCustomParserEntries = true;
        }
        if (this.hasDocumentSpecificParserEntry(xMLParserSelectRegistryEntry)) {
            this.hasDocumentSpecificParserEntries = true;
        }
        DocumentType documentType = this.getDocumentType(xMLParserSelectRegistryEntry);
        if (bl) {
            xMLParserSelectRegistryEntry.setListener(new ParserSelectEntryListener(parserSelectEntryConfig, xMLParserSelectRegistryEntry));
            parserSelectEntryConfig.addPropertyChangeListener(xMLParserSelectRegistryEntry.getListener());
        }
        this.psIndex.put(documentType, xMLParserSelectRegistryEntry);
        return xMLParserSelectRegistryEntry;
    }

    private synchronized XMLEntitySpecRegistryEntry loadEntitySpecEntry(ConfigAbstraction.EntitySpecEntryConfig entitySpecEntryConfig, boolean bl) {
        XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry = this.readEntitySpecEntry(entitySpecEntryConfig);
        if (this.hasDocumentSpecificEntityEntry(xMLEntitySpecRegistryEntry)) {
            this.hasDocumentSpecificEntityEntries = true;
        }
        if (bl) {
            xMLEntitySpecRegistryEntry.setListener(new EntitySpecEntryListener(entitySpecEntryConfig, xMLEntitySpecRegistryEntry));
            entitySpecEntryConfig.addPropertyChangeListener(xMLEntitySpecRegistryEntry.getListener());
        }
        DocumentType documentType = this.getDocumentType(xMLEntitySpecRegistryEntry);
        this.esIndex.put(documentType, xMLEntitySpecRegistryEntry);
        return xMLEntitySpecRegistryEntry;
    }

    private boolean hasCustomParser(XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry) {
        return xMLParserSelectRegistryEntry.getParserClassName() != null;
    }

    private boolean hasDocumentSpecificParserEntry(XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry) {
        return xMLParserSelectRegistryEntry.getSAXParserFactory() != null || xMLParserSelectRegistryEntry.getDocumentBuilderFactory() != null || xMLParserSelectRegistryEntry.getTransformerFactory() != null || xMLParserSelectRegistryEntry.getParserClassName() != null;
    }

    private boolean hasDocumentSpecificEntityEntry(XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry) {
        return xMLEntitySpecRegistryEntry.getEntityURI() != null || xMLEntitySpecRegistryEntry.getWhenToCache() != null || xMLEntitySpecRegistryEntry.getHandleEntityInvalidation() != null;
    }

    private XMLParserSelectRegistryEntry readParserSelectEntry(ConfigAbstraction.ParserSelectEntryConfig parserSelectEntryConfig) {
        String string = parserSelectEntryConfig.getPublicId();
        String string2 = parserSelectEntryConfig.getSystemId();
        String string3 = parserSelectEntryConfig.getRootElementTag();
        XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry = new XMLParserSelectRegistryEntry(string, string2, string3, parserSelectEntryConfig);
        xMLParserSelectRegistryEntry.setDocumentBuilderFactory(parserSelectEntryConfig.getDocumentBuilderFactory());
        xMLParserSelectRegistryEntry.setSAXParserFactory(parserSelectEntryConfig.getSAXParserFactory());
        xMLParserSelectRegistryEntry.setTransformerFactory(parserSelectEntryConfig.getTransformerFactory());
        xMLParserSelectRegistryEntry.setParserClassName(parserSelectEntryConfig.getParserClassName());
        return xMLParserSelectRegistryEntry;
    }

    private XMLEntitySpecRegistryEntry readEntitySpecEntry(ConfigAbstraction.EntitySpecEntryConfig entitySpecEntryConfig) {
        String string = entitySpecEntryConfig.getPublicId();
        String string2 = entitySpecEntryConfig.getSystemId();
        XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry = new XMLEntitySpecRegistryEntry(string, string2, entitySpecEntryConfig);
        xMLEntitySpecRegistryEntry.setEntityURI(entitySpecEntryConfig.getEntityURI());
        xMLEntitySpecRegistryEntry.setWhenToCache(entitySpecEntryConfig.getWhenToCache());
        int n = entitySpecEntryConfig.getCacheTimeoutInterval();
        xMLEntitySpecRegistryEntry.setCacheTimeoutInterval(n);
        String string3 = entitySpecEntryConfig.getHandleEntityInvalidation();
        xMLEntitySpecRegistryEntry.setHandleEntityInvalidation(string3);
        return xMLEntitySpecRegistryEntry;
    }

    private synchronized XMLEntitySpecRegistryEntry updateEntitySpecEntry(ConfigAbstraction.EntitySpecEntryConfig entitySpecEntryConfig, XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry) {
        xMLEntitySpecRegistryEntry.setEntityURI(entitySpecEntryConfig.getEntityURI());
        xMLEntitySpecRegistryEntry.setWhenToCache(entitySpecEntryConfig.getWhenToCache());
        xMLEntitySpecRegistryEntry.setCacheTimeoutInterval(entitySpecEntryConfig.getCacheTimeoutInterval());
        xMLEntitySpecRegistryEntry.setHandleEntityInvalidation(entitySpecEntryConfig.getHandleEntityInvalidation());
        return xMLEntitySpecRegistryEntry;
    }

    private synchronized XMLParserSelectRegistryEntry updateParserSelectEntry(ConfigAbstraction.ParserSelectEntryConfig parserSelectEntryConfig, XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry) {
        xMLParserSelectRegistryEntry.setDocumentBuilderFactory(parserSelectEntryConfig.getDocumentBuilderFactory());
        xMLParserSelectRegistryEntry.setSAXParserFactory(parserSelectEntryConfig.getSAXParserFactory());
        xMLParserSelectRegistryEntry.setTransformerFactory(parserSelectEntryConfig.getTransformerFactory());
        xMLParserSelectRegistryEntry.setParserClassName(parserSelectEntryConfig.getParserClassName());
        return xMLParserSelectRegistryEntry;
    }

    private void initializePrivateEntries() {
        this.addPrivateResolverEntry("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", "http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd", "ejb11-jar.dtd");
        this.addPrivateResolverEntry("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "http://java.sun.com/j2ee/dtds/ejb-jar_2_0.dtd", "ejb20-jar.dtd");
        this.addPrivateResolverEntry("-//BEA Systems, Inc.//DTD WebLogic 5.1.0 EJB//EN", "http://www.bea.com/servers/wls510/dtd/weblogic-ejb-jar.dtd", "weblogic510-ejb-jar.dtd");
        this.addPrivateResolverEntry("-//BEA Systems, Inc.//DTD WebLogic 6.0.0 EJB//EN", "http://www.bea.com/servers/wls600/dtd/weblogic-ejb-jar.dtd", "weblogic600-ejb-jar.dtd");
        this.addPrivateResolverEntry("-//BEA Systems, Inc.//DTD WebLogic 5.1.0 EJB RDBMS Persistence//EN", "http://www.bea.com/servers/wls510/dtd/weblogic-rdbms-persistence.dtd", "weblogic-rdbms-persistence.dtd");
        this.addPrivateResolverEntry("-//BEA Systems, Inc.//DTD WebLogic 6.0.0 EJB RDBMS Persistence//EN", "http://www.bea.com/servers/wls600/dtd/weblogic-rdbms20-persistence-600.dtd", "weblogic-rdbms20-persistence-600.dtd");
    }

    private void addPrivateResolverEntry(String string, String string2, String string3) {
        DocumentType documentType = new DocumentType(string, string2, null);
        if (!this.esIndex.containsKey(documentType)) {
            XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry = new XMLEntitySpecRegistryEntry(string, string2, null);
            xMLEntitySpecRegistryEntry.setEntityURI(string3);
            xMLEntitySpecRegistryEntry.setPrivate(true);
            xMLEntitySpecRegistryEntry.setCacheTimeoutInterval(600);
            this.esIndex.put(documentType, xMLEntitySpecRegistryEntry);
        }
    }

    private DocumentType getDocumentType(XMLAbstractRegistryEntry xMLAbstractRegistryEntry) {
        return new DocumentType(xMLAbstractRegistryEntry.getPublicId(), xMLAbstractRegistryEntry.getSystemId(), xMLAbstractRegistryEntry.getRootElementTag());
    }

    public boolean havePublicData() {
        return this.config != null;
    }

    void removeEntry(XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry) {
        try {
            this.getCache().remove(xMLEntitySpecRegistryEntry.getPublicId(), xMLEntitySpecRegistryEntry.getSystemId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        DocumentType documentType = this.getDocumentType(xMLEntitySpecRegistryEntry);
        this.esIndex.remove(documentType);
    }

    void removeEntry(XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry) {
        DocumentType documentType = this.getDocumentType(xMLParserSelectRegistryEntry);
        this.psIndex.remove(documentType);
    }

    static class ServerListener
    implements PropertyChangeListener {
        ServerListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equalsIgnoreCase("xmlregistry")) {
                try {
                    XMLRegistry.reinitializeDefaultRegistry();
                }
                catch (XMLRegistryException xMLRegistryException) {
                    // empty catch block
                }
            }
        }
    }

    class CacheListener
    implements PropertyChangeListener {
        XMLRegistry registry = null;

        CacheListener(XMLRegistry xMLRegistry2) {
            this.registry = xMLRegistry2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            if ("CacheMemorySize".equals(string) && object != null) {
                try {
                    this.registry.getCache().setMemorySize((Integer)object * 1000);
                }
                catch (Exception exception) {}
            } else if ("CacheDiskSize".equals(string) && object != null) {
                try {
                    this.registry.getCache().setDiskSize((Integer)object * 1000000);
                }
                catch (Exception exception) {}
            } else if ("CacheTimeoutInterval".equals(string)) {
                try {
                    if (object != null) {
                        this.registry.setCacheDefaultTimeoutInterval((Integer)object * 1000);
                    } else {
                        this.registry.setCacheDefaultTimeoutInterval(-1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class RegistryListener
    implements PropertyChangeListener {
        XMLRegistry registry = null;

        RegistryListener(XMLRegistry xMLRegistry2) {
            this.registry = xMLRegistry2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                this.addNewMBean(string, (WebLogicMBean)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getNewValue() == null) {
                this.removeOldMBean(string, (WebLogicMBean)propertyChangeEvent.getOldValue());
            } else if (propertyChangeEvent.getNewValue() != null && (string.equalsIgnoreCase("ParserSelectRegistryEntries") || string.equalsIgnoreCase("EntitySpecRegistryEntries"))) {
                WebLogicMBean webLogicMBean = this.findDeletedMBean(string, (Object[])propertyChangeEvent.getOldValue(), (Object[])propertyChangeEvent.getNewValue());
                this.removeOldMBean(string, webLogicMBean);
            }
        }

        WebLogicMBean findDeletedMBean(String string, Object[] objectArray, Object[] objectArray2) {
            try {
                Object object = null;
                Object object2 = null;
                for (int i = 0; i < objectArray.length; ++i) {
                    object = objectArray[i];
                    int n = 0;
                    for (n = 0; n < objectArray2.length && !object.equals(object2 = objectArray2[n]); ++n) {
                    }
                    if (n != objectArray2.length) continue;
                    return (WebLogicMBean)object;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        void addNewMBean(String string, WebLogicMBean webLogicMBean) {
            if ("ParserSelectRegistryEntries".equals(string)) {
                XMLParserSelectRegistryEntryMBean xMLParserSelectRegistryEntryMBean = (XMLParserSelectRegistryEntryMBean)webLogicMBean;
                if (xMLParserSelectRegistryEntryMBean.getPublicId() == null && xMLParserSelectRegistryEntryMBean.getSystemId() == null && xMLParserSelectRegistryEntryMBean.getRootElementTag() == null) {
                    XMLRegistry.this.newParserSelectMBeans.add(xMLParserSelectRegistryEntryMBean);
                    this.registry.hasDocumentSpecificParserEntries = true;
                } else {
                    XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry = this.registry.loadParserSelectEntry(ConfigAbstraction.getParserSelectEntryConfig(xMLParserSelectRegistryEntryMBean), true);
                }
            } else if ("EntitySpecRegistryEntries".equals(string)) {
                XMLEntitySpecRegistryEntryMBean xMLEntitySpecRegistryEntryMBean = (XMLEntitySpecRegistryEntryMBean)webLogicMBean;
                if (xMLEntitySpecRegistryEntryMBean.getPublicId() == null && xMLEntitySpecRegistryEntryMBean.getSystemId() == null) {
                    XMLRegistry.this.newEntitySpecMBeans.add(xMLEntitySpecRegistryEntryMBean);
                    this.registry.hasDocumentSpecificEntityEntries = true;
                } else {
                    XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry = this.registry.loadEntitySpecEntry(ConfigAbstraction.getEntitySpecEntryConfig(xMLEntitySpecRegistryEntryMBean), true);
                }
            }
        }

        void removeOldMBean(String string, WebLogicMBean webLogicMBean) {
            try {
                if ("ParserSelectRegistryEntries".equals(string)) {
                    XMLParserSelectRegistryEntryMBean xMLParserSelectRegistryEntryMBean = (XMLParserSelectRegistryEntryMBean)webLogicMBean;
                    XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry = this.registry.readParserSelectEntry(ConfigAbstraction.getParserSelectEntryConfig(xMLParserSelectRegistryEntryMBean));
                    this.registry.removeEntry(xMLParserSelectRegistryEntry);
                } else if ("EntitySpecRegistryEntries".equals(string)) {
                    XMLEntitySpecRegistryEntryMBean xMLEntitySpecRegistryEntryMBean = (XMLEntitySpecRegistryEntryMBean)webLogicMBean;
                    XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry = this.registry.readEntitySpecEntry(ConfigAbstraction.getEntitySpecEntryConfig(xMLEntitySpecRegistryEntryMBean));
                    this.registry.removeEntry(xMLEntitySpecRegistryEntry);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class EntitySpecEntryListener
    implements PropertyChangeListener {
        ConfigAbstraction.EntitySpecEntryConfig mbean = null;
        XMLEntitySpecRegistryEntry entry = null;

        EntitySpecEntryListener(ConfigAbstraction.EntitySpecEntryConfig entitySpecEntryConfig, XMLEntitySpecRegistryEntry xMLEntitySpecRegistryEntry) {
            this.mbean = entitySpecEntryConfig;
            this.entry = xMLEntitySpecRegistryEntry;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!string.equalsIgnoreCase("parent")) {
                Object object = propertyChangeEvent.getOldValue();
                Object object2 = propertyChangeEvent.getNewValue();
                if (object == null) {
                    object = "";
                }
                if (object2 == null) {
                    object2 = "";
                }
                if (!object.equals(object2)) {
                    if (string.equalsIgnoreCase("publicid") || string.equalsIgnoreCase("systemid")) {
                        if (this.entry != null) {
                            XMLRegistry.this.removeEntry(this.entry);
                        }
                        this.entry = XMLRegistry.this.loadEntitySpecEntry(this.mbean, false);
                    } else if (this.entry != null) {
                        XMLRegistry.this.updateEntitySpecEntry(this.mbean, this.entry);
                        try {
                            XMLRegistry.this.getCache().putrify(this.mbean.getPublicId(), this.mbean.getSystemId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    class ParserSelectEntryListener
    implements PropertyChangeListener {
        ConfigAbstraction.ParserSelectEntryConfig mbean = null;
        XMLParserSelectRegistryEntry entry = null;

        ParserSelectEntryListener(ConfigAbstraction.ParserSelectEntryConfig parserSelectEntryConfig, XMLParserSelectRegistryEntry xMLParserSelectRegistryEntry) {
            this.mbean = parserSelectEntryConfig;
            this.entry = xMLParserSelectRegistryEntry;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!string.equalsIgnoreCase("parent")) {
                String string2 = (String)propertyChangeEvent.getOldValue();
                String string3 = (String)propertyChangeEvent.getNewValue();
                if (string2 == null) {
                    string2 = "";
                }
                if (string3 == null) {
                    string3 = "";
                }
                if (!string2.equals(string3)) {
                    if (string.equalsIgnoreCase("publicid") || string.equalsIgnoreCase("systemid") || string.equalsIgnoreCase("rootelementtag")) {
                        if (this.entry != null) {
                            XMLRegistry.this.removeEntry(this.entry);
                        }
                        this.entry = XMLRegistry.this.loadParserSelectEntry(this.mbean, false);
                    } else if (this.entry != null) {
                        XMLRegistry.this.updateParserSelectEntry(this.mbean, this.entry);
                    }
                }
            }
        }
    }

    public class ResolvedEntity {
        XMLEntitySpecRegistryEntry entry = null;
        InputSource inputSource = null;
        boolean isLocal = false;
        boolean isSubjectToCaching = true;

        public InputSource inputSource() {
            return this.inputSource;
        }

        public boolean isSubjectToCaching() {
            return this.isSubjectToCaching;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public XMLEntitySpecRegistryEntry getEntry() {
            return this.entry;
        }
    }

    class CacheLogListener
    implements weblogic.xml.util.cache.entitycache.CacheListener {
        CacheLogListener() {
        }

        public void notify(Event.CacheUtilityEvent cacheUtilityEvent) {
            try {
                if (cacheUtilityEvent instanceof Event.MemoryPurgeEvent) {
                    Event.MemoryPurgeEvent memoryPurgeEvent = (Event.MemoryPurgeEvent)cacheUtilityEvent;
                    XMLLogger.logCacheMemoryPurge((int)memoryPurgeEvent.cacheEntries.size(), (long)memoryPurgeEvent.combinedMemorySize, (long)memoryPurgeEvent.currentMemorySize);
                } else if (cacheUtilityEvent instanceof Event.DiskPurgeEvent) {
                    Event.DiskPurgeEvent diskPurgeEvent = (Event.DiskPurgeEvent)cacheUtilityEvent;
                    XMLLogger.logCacheDiskPurge((int)diskPurgeEvent.cacheEntries.size(), (long)diskPurgeEvent.combinedDiskSize, (long)diskPurgeEvent.currentDiskSize);
                } else if (cacheUtilityEvent instanceof Event.EntryDiskRejectionEvent) {
                    Event.EntryDiskRejectionEvent entryDiskRejectionEvent = (Event.EntryDiskRejectionEvent)cacheUtilityEvent;
                    XMLLogger.logCacheDiskRejection((String)XMLRegistry.this.getName(), (String)XMLRegistry.this.getCache().getDescription(entryDiskRejectionEvent.cacheEntry.getCacheKey()), (long)entryDiskRejectionEvent.diskSize);
                } else if (cacheUtilityEvent instanceof Event.EntryRejectionEvent) {
                    Event.EntryRejectionEvent entryRejectionEvent = (Event.EntryRejectionEvent)cacheUtilityEvent;
                    XMLLogger.logCacheRejection((String)XMLRegistry.this.getName(), (String)XMLRegistry.this.getCache().getDescription(entryRejectionEvent.cacheEntry.getCacheKey()), (long)entryRejectionEvent.memorySize);
                } else if (cacheUtilityEvent instanceof Event.EntryAddEvent) {
                    Event.EntryAddEvent entryAddEvent = (Event.EntryAddEvent)cacheUtilityEvent;
                    XMLLogger.logCacheEntryAdd((String)XMLRegistry.this.getName(), (String)XMLRegistry.this.getCache().getDescription(entryAddEvent.cacheEntry.getCacheKey()), (long)entryAddEvent.memorySize, (String)(entryAddEvent.cacheEntry.isPersistent() ? "Persistent" : "Transient"), (long)entryAddEvent.currentMemorySize);
                } else if (cacheUtilityEvent instanceof Event.EntryDeleteEvent) {
                    Event.EntryDeleteEvent entryDeleteEvent = (Event.EntryDeleteEvent)cacheUtilityEvent;
                    XMLLogger.logCacheEntryDelete((String)XMLRegistry.this.getName(), (String)XMLRegistry.this.getCache().getDescription(entryDeleteEvent.cacheEntry.getCacheKey()), (long)entryDeleteEvent.memorySize, (long)entryDeleteEvent.diskSize, (long)entryDeleteEvent.currentMemorySize, (long)entryDeleteEvent.currentDiskSize);
                } else if (cacheUtilityEvent instanceof Event.EntryPersistEvent) {
                    Event.EntryPersistEvent entryPersistEvent = (Event.EntryPersistEvent)cacheUtilityEvent;
                    XMLLogger.logCacheEntryPersist((String)XMLRegistry.this.getName(), (String)XMLRegistry.this.getCache().getDescription(entryPersistEvent.cacheEntry.getCacheKey()), (long)entryPersistEvent.diskSize, (long)entryPersistEvent.currentDiskSize);
                } else if (cacheUtilityEvent instanceof Event.EntryLoadEvent) {
                    Event.EntryLoadEvent entryLoadEvent = (Event.EntryLoadEvent)cacheUtilityEvent;
                    XMLLogger.logCacheEntryLoad((String)XMLRegistry.this.getName(), (String)XMLRegistry.this.getCache().getDescription(entryLoadEvent.cacheEntry.getCacheKey()), (long)entryLoadEvent.memorySize, (long)entryLoadEvent.currentMemorySize);
                } else if (cacheUtilityEvent instanceof Event.StatCheckpointEvent) {
                    Event.StatCheckpointEvent statCheckpointEvent = (Event.StatCheckpointEvent)cacheUtilityEvent;
                    XMLLogger.logCacheStatisticsCheckpoint();
                } else if (cacheUtilityEvent instanceof Event.CacheCreationEvent) {
                    Event.CacheCreationEvent cacheCreationEvent = (Event.CacheCreationEvent)cacheUtilityEvent;
                    XMLLogger.logCacheCreation((long)cacheCreationEvent.currentMemorySize, (long)cacheCreationEvent.currentDiskSize);
                } else if (cacheUtilityEvent instanceof Event.CacheLoadEvent) {
                    Event.CacheLoadEvent cacheLoadEvent = (Event.CacheLoadEvent)cacheUtilityEvent;
                    XMLLogger.logCacheLoad((long)cacheLoadEvent.currentMemorySize, (long)cacheLoadEvent.currentDiskSize);
                } else if (cacheUtilityEvent instanceof Event.CacheCloseEvent) {
                    Event.CacheCloseEvent cacheCloseEvent = (Event.CacheCloseEvent)cacheUtilityEvent;
                    XMLLogger.logCacheClose((long)cacheCloseEvent.currentDiskSize);
                } else if (cacheUtilityEvent instanceof Event.CacheCorruptionEvent) {
                    Event.CacheCorruptionEvent cacheCorruptionEvent = (Event.CacheCorruptionEvent)cacheUtilityEvent;
                    XMLLogger.logCacheCorrupted((String)cacheCorruptionEvent.path);
                } else if (cacheUtilityEvent instanceof Event.EntryCorruptionEvent) {
                    Event.EntryCorruptionEvent entryCorruptionEvent = (Event.EntryCorruptionEvent)cacheUtilityEvent;
                    XMLLogger.logCacheEntryCorrupted((String)XMLRegistry.this.getName(), (String)entryCorruptionEvent.path, (String)XMLRegistry.this.getCache().getDescription(entryCorruptionEvent.key));
                } else if (cacheUtilityEvent instanceof Event.StatisticsCorruptionEvent) {
                    Event.StatisticsCorruptionEvent statisticsCorruptionEvent = (Event.StatisticsCorruptionEvent)cacheUtilityEvent;
                    XMLLogger.logCacheStatisticsCorrupted((String)statisticsCorruptionEvent.path);
                } else if (cacheUtilityEvent instanceof Event.FileAccessErrorForEntryEvent) {
                    Event.FileAccessErrorForEntryEvent fileAccessErrorForEntryEvent = (Event.FileAccessErrorForEntryEvent)cacheUtilityEvent;
                    if (fileAccessErrorForEntryEvent.onWrite) {
                        XMLLogger.logCacheEntrySaveError((String)XMLRegistry.this.getName(), (String)fileAccessErrorForEntryEvent.path, (String)XMLRegistry.this.getCache().getDescription(fileAccessErrorForEntryEvent.cacheEntry.getCacheKey()));
                    } else {
                        XMLLogger.logCacheEntryReadError((String)XMLRegistry.this.getName(), (String)fileAccessErrorForEntryEvent.path, (String)XMLRegistry.this.getCache().getDescription(fileAccessErrorForEntryEvent.cacheEntry.getCacheKey()));
                    }
                } else if (cacheUtilityEvent instanceof Event.FileAccessErrorForCacheEvent) {
                    Event.FileAccessErrorForCacheEvent fileAccessErrorForCacheEvent = (Event.FileAccessErrorForCacheEvent)cacheUtilityEvent;
                    if (fileAccessErrorForCacheEvent.onWrite) {
                        XMLLogger.logCacheSaveError((String)fileAccessErrorForCacheEvent.path);
                    } else {
                        XMLLogger.logCacheReadError((String)fileAccessErrorForCacheEvent.path);
                    }
                } else if (cacheUtilityEvent instanceof Event.FileAccessErrorForStatisticsEvent) {
                    Event.FileAccessErrorForStatisticsEvent fileAccessErrorForStatisticsEvent = (Event.FileAccessErrorForStatisticsEvent)cacheUtilityEvent;
                    if (fileAccessErrorForStatisticsEvent.onWrite) {
                        XMLLogger.logCacheStatisticsSaveError((String)fileAccessErrorForStatisticsEvent.path);
                    } else {
                        XMLLogger.logCacheStatisticsReadError((String)fileAccessErrorForStatisticsEvent.path);
                    }
                } else if (cacheUtilityEvent instanceof Event.OutOfMemoryLoadingEntryEvent) {
                    Event.OutOfMemoryLoadingEntryEvent outOfMemoryLoadingEntryEvent = (Event.OutOfMemoryLoadingEntryEvent)cacheUtilityEvent;
                    XMLLogger.logCacheOutOfMemoryOnEntryLoad((String)XMLRegistry.this.getName(), (String)XMLRegistry.this.getCache().getDescription(outOfMemoryLoadingEntryEvent.key), (String)outOfMemoryLoadingEntryEvent.path);
                } else if (cacheUtilityEvent instanceof Event.OutOfMemoryLoadingCacheEvent) {
                    Event.OutOfMemoryLoadingCacheEvent outOfMemoryLoadingCacheEvent = (Event.OutOfMemoryLoadingCacheEvent)cacheUtilityEvent;
                    XMLLogger.logCacheOutOfMemoryOnLoad((String)outOfMemoryLoadingCacheEvent.path);
                } else if (cacheUtilityEvent instanceof Event.OutOfMemoryLoadingStatisticsEvent) {
                    Event.OutOfMemoryLoadingStatisticsEvent outOfMemoryLoadingStatisticsEvent = (Event.OutOfMemoryLoadingStatisticsEvent)cacheUtilityEvent;
                    XMLLogger.logCacheOutOfMemoryOnStatisticsLoad((String)outOfMemoryLoadingStatisticsEvent.path);
                } else if (cacheUtilityEvent instanceof Event.CacheFailureEvent) {
                    Event.CacheFailureEvent cacheFailureEvent = (Event.CacheFailureEvent)cacheUtilityEvent;
                    String string = cacheFailureEvent.path;
                    if (cacheFailureEvent.cache != null) {
                        string = cacheFailureEvent.cache.getName();
                    }
                    XMLLogger.logCacheUnexpectedProblem((String)cacheFailureEvent.message);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void cacheUpdateOccured(Object object, String string) {
        }
    }
}

