/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.servlet.ConnectionSigner;
import weblogic.management.servlet.FileDistributionServlet;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;
import weblogic.xml.registry.XMLRegistryException;
import weblogic.xml.registry.XMLRegistryRemoteAccessException;

public final class XMLRegistryDir {
    private static final boolean verbose = true;
    private boolean localDir = false;
    private String registryName;
    private URL adminFileServletURL;
    private static AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public XMLRegistryDir(String string) {
        if (!ManagementService.getRuntimeAccess(KERNEL_ID).isAdminServer() || !ManagementService.getRuntimeAccess(KERNEL_ID).isAdminServerAvailable()) {
            try {
                this.adminFileServletURL = FileDistributionServlet.getURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Throwable)malformedURLException);
            }
        }
        this.registryName = string;
    }

    public InputStream getEntity(String string) throws XMLRegistryException {
        if (this.isLocal()) {
            return this.getLocalEntity(string);
        }
        return this.getRemoteEntity(string);
    }

    boolean isLocal() {
        return this.adminFileServletURL == null;
    }

    private InputStream getLocalEntity(String string) throws XMLRegistryException {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain();
        String string2 = domainMBean.getRootDirectory();
        File file = new File(string2, "xml/registries/" + this.registryName);
        if (!file.exists()) {
            throw new XMLRegistryException("XML Registry directory " + file.getAbsolutePath() + " not found");
        }
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            file2 = new File(file, string);
        }
        if (!file2.exists()) {
            throw new XMLRegistryException("Entity " + string + " not found in registry entity directory " + file);
        }
        try {
            return new FileInputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AssertionError();
        }
    }

    private InputStream getRemoteEntity(String string) throws XMLRegistryException {
        try {
            URLConnection uRLConnection = this.adminFileServletURL.openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            ConnectionSigner.signConnection(uRLConnection, KERNEL_ID);
            httpURLConnection.setRequestProperty("wl_request_type", "wl_xml_entity_request");
            httpURLConnection.setRequestProperty("xml-registry-name", this.registryName);
            httpURLConnection.setRequestProperty("xml-entity-path", string);
            httpURLConnection.setRequestProperty("Connection", "Close");
            return httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            throw new XMLRegistryRemoteAccessException("Unable to open url: " + this.adminFileServletURL.toString(), iOException);
        }
    }
}

