/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.sax;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.xml.XMLLogger;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.sax.OpenBufferedInputStream;
import weblogic.xml.sax.OpenBufferedReader;
import weblogic.xml.util.DocumentType;

public class XMLInputSource
extends InputSource {
    private InputSource inputSource;
    private OpenBufferedInputStream byteStream;
    private OpenBufferedReader characterStream;
    private String localRootTag;
    private String qRootTag;
    private String rootTagInternal;
    private String publicId;
    private String publicIdInternal;
    private String doctypeSystemId;
    private String doctypeSystemIdInternal;
    private String namespaceURI;
    private String DTDName;
    private boolean startElementPassed = false;
    private boolean parsed = false;
    private Map externalEntitiesSystemIds;
    private Map externalEntitiesPublicIds;
    final int BYTE_LIMIT = 16384;

    public XMLInputSource() {
    }

    public XMLInputSource(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Failed to create weblogic.xml.sax.XMLInputSource with systemId parameter. InputStream cannot be null.");
        }
        this.setSystemId(string);
    }

    public XMLInputSource(InputStream inputStream) {
        super(inputStream);
        if (inputStream == null) {
            throw new IllegalArgumentException("Failed to create weblogic.xml.sax.XMLInputSource with java.io.InputStream parameter. InputStream cannot be null.");
        }
        this.setByteStream(inputStream);
    }

    public XMLInputSource(Reader reader) {
        super(reader);
        if (reader == null) {
            throw new IllegalArgumentException("Failed to create weblogic.xml.sax.XMLInputSource with java.io.Reader parameter. Reader cannot be null.");
        }
        this.setCharacterStream(reader);
    }

    public XMLInputSource(InputSource inputSource) throws IOException {
        String string;
        InputStream inputStream;
        if (inputSource == null) {
            throw new IllegalArgumentException("InputSource is missing.");
        }
        this.inputSource = inputSource;
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            this.setCharacterStream(reader);
        }
        if ((inputStream = inputSource.getByteStream()) != null) {
            this.setByteStream(inputStream);
        }
        if ((string = inputSource.getSystemId()) != null) {
            super.setSystemId(string);
            if (this.inputSource == null) {
                this.inputSource = new InputSource(string);
            } else {
                this.inputSource.setSystemId(string);
            }
            if (reader == null && inputStream == null) {
                try {
                    URL uRL = new URL(string);
                    this.setByteStream(uRL.openStream());
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public String getPublicId() {
        return this.getPublicIdInternal();
    }

    public String getPublicIdInternal() {
        String string = super.getPublicId();
        if (string != null) {
            return string;
        }
        if (this.parsed) {
            return this.publicIdInternal;
        }
        if (this.inputSource == null) {
            return null;
        }
        try {
            this.parseDocumentTypeInternal();
        }
        catch (SAXException sAXException) {
            XMLLogger.logSAXException((String)("Failed to retrieve PUBLIC id. " + sAXException.getMessage()));
            return null;
        }
        catch (IOException iOException) {
            XMLLogger.logIOException((String)("Failed to retrieve PUBLIC id. " + iOException.getMessage()));
            return null;
        }
        return this.publicIdInternal;
    }

    public String getDoctypeSystemId() {
        if (this.startElementPassed) {
            return this.doctypeSystemId;
        }
        if (this.inputSource == null) {
            return null;
        }
        try {
            this.parseDocumentTypeInternal();
        }
        catch (SAXException sAXException) {
            XMLLogger.logSAXException((String)("Failed to retrieve SYSTEM id. " + sAXException.getMessage()));
            return null;
        }
        catch (IOException iOException) {
            XMLLogger.logIOException((String)("Failed to retrieve SYSTEM id. " + iOException.getMessage()));
            return null;
        }
        return this.doctypeSystemId;
    }

    public String getDoctypeSystemIdInternal() {
        if (this.parsed) {
            return this.doctypeSystemIdInternal;
        }
        if (this.inputSource == null) {
            return null;
        }
        try {
            this.parseDocumentTypeInternal();
        }
        catch (SAXException sAXException) {
            XMLLogger.logSAXException((String)("Failed to retrieve SYSTEM id. " + sAXException.getMessage()));
            return null;
        }
        catch (IOException iOException) {
            XMLLogger.logIOException((String)("Failed to retrieve SYSTEM id. " + iOException.getMessage()));
            return null;
        }
        return this.doctypeSystemIdInternal;
    }

    public void setSystemId(String string) {
        super.setSystemId(string);
        if (this.inputSource == null) {
            this.inputSource = new InputSource(string);
        } else {
            this.inputSource.setSystemId(string);
        }
        if (this.getCharacterStream() == null && this.getByteStream() == null) {
            try {
                URL uRL = new URL(string);
                this.setByteStream(uRL.openStream());
            }
            catch (MalformedURLException malformedURLException) {
                XMLLogger.logIOException((String)("Failed to set SYSTEM id. " + malformedURLException.getMessage()));
            }
            catch (IOException iOException) {
                XMLLogger.logIOException((String)("Failed to set SYSTEM id. " + iOException.getMessage()));
            }
        }
    }

    public String getRootTag() {
        if (this.inputSource == null) {
            return null;
        }
        if (!this.startElementPassed) {
            try {
                this.parseDocumentTypeInternal();
            }
            catch (SAXException sAXException) {
                XMLLogger.logSAXException((String)("Failed to retrieve root tag. " + sAXException.getMessage()));
                return null;
            }
            catch (IOException iOException) {
                XMLLogger.logIOException((String)("Failed to retrieve root tag. " + iOException.getMessage()));
                return null;
            }
        }
        if (this.namespaceURI != null && this.namespaceURI.equals("")) {
            return this.localRootTag;
        }
        return this.qRootTag;
    }

    public String getRootTagInternal() {
        if (this.inputSource == null) {
            return null;
        }
        if (!this.parsed) {
            try {
                this.parseDocumentTypeInternal();
            }
            catch (SAXException sAXException) {
                XMLLogger.logSAXException((String)("Failed to retrieve root tag. " + sAXException.getMessage()));
                return null;
            }
            catch (IOException iOException) {
                XMLLogger.logIOException((String)("Failed to retrieve root tag. " + iOException.getMessage()));
                return null;
            }
        }
        return this.rootTagInternal;
    }

    public String getQualifiedRootTag() {
        if (this.startElementPassed) {
            return this.qRootTag;
        }
        if (this.inputSource == null) {
            return null;
        }
        try {
            this.parseDocumentTypeInternal();
        }
        catch (SAXException sAXException) {
            XMLLogger.logSAXException((String)("Failed to retrieve qualified root tag. " + sAXException.getMessage()));
            return null;
        }
        catch (IOException iOException) {
            XMLLogger.logIOException((String)("Failed to retrieve qualified root tag. " + iOException.getMessage()));
            return null;
        }
        return this.qRootTag;
    }

    public String getDTDName() {
        if (this.startElementPassed) {
            return this.DTDName;
        }
        if (this.inputSource == null) {
            return null;
        }
        try {
            this.parseDocumentTypeInternal();
        }
        catch (SAXException sAXException) {
            XMLLogger.logSAXException((String)("Failed to retrieve DTD name. " + sAXException.getMessage()));
            return null;
        }
        catch (IOException iOException) {
            XMLLogger.logIOException((String)("Failed to retrieve DTD name. " + iOException.getMessage()));
            return null;
        }
        return this.DTDName;
    }

    public String getLocalRootTag() {
        if (this.startElementPassed) {
            return this.localRootTag;
        }
        if (this.inputSource == null) {
            return null;
        }
        try {
            this.parseDocumentTypeInternal();
        }
        catch (SAXException sAXException) {
            XMLLogger.logSAXException((String)("Failed to retrieve local root tag. " + sAXException.getMessage()));
            return null;
        }
        catch (IOException iOException) {
            XMLLogger.logIOException((String)("Failed to retrieve local root tag. " + iOException.getMessage()));
            return null;
        }
        return this.localRootTag;
    }

    public String getNamespaceURI() {
        if (this.startElementPassed) {
            return this.namespaceURI;
        }
        if (this.inputSource == null) {
            return null;
        }
        try {
            this.parseDocumentTypeInternal();
        }
        catch (SAXException sAXException) {
            XMLLogger.logSAXException((String)("Failed to retrieve namespace URI. " + sAXException.getMessage()));
            return null;
        }
        catch (IOException iOException) {
            XMLLogger.logIOException((String)("Failed to retrieve namespace URI. " + iOException.getMessage()));
            return null;
        }
        return this.namespaceURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDocumentTypeInternal() throws SAXException, IOException {
        if (this.parsed) {
            return;
        }
        try {
            DocumentType documentType = null;
            if (this.characterStream != null) {
                documentType = new DocumentType(this.characterStream, false);
            } else if (this.byteStream != null) {
                documentType = new DocumentType(new OpenBufferedReader(new InputStreamReader(this.byteStream)), false);
            }
            if (documentType != null) {
                this.publicIdInternal = documentType.getPublicId();
                this.doctypeSystemIdInternal = documentType.getSystemId();
                this.rootTagInternal = documentType.getRootElementTag();
            }
        }
        catch (XMLParsingException xMLParsingException) {
        }
        finally {
            this.reset();
            this.parsed = true;
        }
    }

    private void reset() throws IOException {
        try {
            if (this.characterStream != null) {
                this.characterStream.reset();
                this.characterStream.allowClose(true);
            } else if (this.byteStream != null) {
                this.byteStream.reset();
                this.byteStream.allowClose(true);
            }
        }
        catch (IOException iOException) {
            XMLLogger.logIOException((String)"Failed to retrieve PUBLIC id or SYSTEM id from the document. Decrease the number of char between the beginning of the document and its root element.");
        }
    }

    public void setCharacterStream(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Character stream is missing.");
        }
        try {
            this.characterStream = new OpenBufferedReader(reader, 16384);
            this.characterStream.mark(16384);
            if (this.inputSource == null) {
                this.inputSource = new InputSource(this.characterStream);
            } else {
                this.inputSource.setCharacterStream(this.characterStream);
            }
        }
        catch (IOException iOException) {
            XMLLogger.logIOException((String)("Failed to set character stream. " + iOException.getMessage()));
        }
    }

    public Reader getCharacterStream() {
        return this.characterStream;
    }

    public void setByteStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Byte stream is missing.");
        }
        this.byteStream = new OpenBufferedInputStream(inputStream, 16384);
        this.byteStream.mark(16384);
        if (this.inputSource == null) {
            this.inputSource = new InputSource(this.byteStream);
        } else {
            this.inputSource.setByteStream(this.byteStream);
        }
    }

    public InputStream getByteStream() {
        return this.byteStream;
    }

    public String toString() {
        String string = "\nPublic Id = " + this.publicId + "\nSystem Id = " + this.doctypeSystemId + "\nNamespace URI = " + this.namespaceURI + "\nLocal Root Tag = " + this.localRootTag + "\nQualified Root Tag = " + this.qRootTag;
        return string;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    public Map getExternalEntitiesSystemIds() {
        if (this.startElementPassed) {
            return this.externalEntitiesSystemIds;
        }
        if (this.inputSource == null) {
            return null;
        }
        try {
            this.parseDocumentTypeInternal();
        }
        catch (SAXException sAXException) {
            XMLLogger.logSAXException((String)("Failed to retrieve external entities system ids. " + sAXException.getMessage()));
            return null;
        }
        catch (IOException iOException) {
            XMLLogger.logIOException((String)("Failed to retrieve external entities system ids. " + iOException.getMessage()));
            return null;
        }
        return this.externalEntitiesSystemIds;
    }

    public Map getExternalEntitiesPublicIds() {
        if (this.startElementPassed) {
            return this.externalEntitiesPublicIds;
        }
        if (this.inputSource == null) {
            return null;
        }
        try {
            this.parseDocumentTypeInternal();
        }
        catch (SAXException sAXException) {
            XMLLogger.logSAXException((String)("Failed to retrieve external entities public ids. " + sAXException.getMessage()));
            return null;
        }
        catch (IOException iOException) {
            XMLLogger.logIOException((String)("Failed to retrieve external entities public ids. " + iOException.getMessage()));
            return null;
        }
        return this.externalEntitiesPublicIds;
    }
}

