/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import weblogic.xml.security.utils.Utils;

public class UserInfo {
    private final byte[] username;
    private final byte[] password;
    private final byte[] passwordDigest;
    private final String nonce;
    private final String created;

    public UserInfo(String string) {
        this.username = string.getBytes();
        this.password = null;
        this.nonce = null;
        this.created = null;
        this.passwordDigest = null;
    }

    public UserInfo(String string, String string2) {
        this.username = string.getBytes();
        this.password = string2.getBytes();
        this.nonce = null;
        this.created = null;
        this.passwordDigest = null;
    }

    public UserInfo(String string, byte[] byArray, String string2, String string3) {
        this.username = string.getBytes();
        this.passwordDigest = byArray;
        this.password = null;
        this.nonce = string2;
        this.created = string3;
    }

    public String getUsername() {
        return new String(this.username);
    }

    public String getPassword() {
        return new String(this.password);
    }

    public byte[] getPasswordDigest() {
        return this.passwordDigest;
    }

    public boolean verifyPassword(String string) throws NoSuchAlgorithmException {
        if (string != null) {
            return this.getPassword().equals(string);
        }
        if (this.passwordDigest == null) {
            return string == null;
        }
        return Arrays.equals(this.passwordDigest, Utils.passwordDigest(this.nonce, this.created, string));
    }
}

