/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.assertion;

import java.security.cert.X509Certificate;
import javax.xml.namespace.QName;
import weblogic.xml.security.assertion.ElementAssertion;
import weblogic.xml.security.assertion.ElementAssertionUtils;
import weblogic.xml.security.assertion.IntegrityAssertion;
import weblogic.xml.security.specs.ElementIdentifier;
import weblogic.xml.stream.XMLName;

public class ElementIntegrityAssertion
extends IntegrityAssertion
implements ElementAssertion {
    private final QName qname;
    private final String localName;
    private final String namespace;
    private final String restriction;

    public ElementIntegrityAssertion(String string, X509Certificate x509Certificate, String string2, String string3, String string4) {
        super(string, ElementIntegrityAssertion.createIdString(string3, string2, string4), x509Certificate);
        this.localName = string2;
        this.namespace = string3;
        this.restriction = string4;
        if ("body".equals(string4) && string2 == null) {
            this.qname = null;
        } else {
            if (string2 == null || string3 == null) {
                throw new AssertionError((Object)"must provide a fully qualified type name");
            }
            this.qname = new QName(string3, string2);
        }
    }

    private static String createIdString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string3 != null) {
            stringBuffer.append(string3).append(":");
        }
        if ("body".equals(string3) && string2 == null) {
            stringBuffer.append("body");
        } else {
            if (string != null) {
                stringBuffer.append("[").append(string).append("]");
            }
            stringBuffer.append(string2);
        }
        String string4 = stringBuffer.toString();
        return string4;
    }

    public ElementIntegrityAssertion(String string, X509Certificate x509Certificate, XMLName xMLName, String string2) {
        this(string, x509Certificate, xMLName.getLocalName(), xMLName.getNamespaceUri(), string2);
    }

    public String getPolicyString() {
        return "Integrity{" + this.id + "}";
    }

    public String getRestriction() {
        return this.restriction;
    }

    public QName getElementName() {
        return this.qname;
    }

    public String getElementLocalName() {
        return this.localName;
    }

    public String getElementNamespace() {
        return this.namespace;
    }

    public String getId() {
        return this.id;
    }

    public final boolean isAssertionType(String string) {
        return "http://www.bea.com/servers/xml/security/assertion/TypeIntegrity".equals(string);
    }

    public final String getAssertionType() {
        return "http://www.bea.com/servers/xml/security/assertion/TypeIntegrity";
    }

    public final int getAssertionTypeCode() {
        return 2;
    }

    public final boolean satisfies(ElementIdentifier elementIdentifier) {
        return ElementAssertionUtils.satisfies(this.localName, this.namespace, this.restriction, elementIdentifier);
    }

    public final String toString() {
        X509Certificate x509Certificate;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(").append("ElementIntegrityAssertion");
        stringBuffer.append(" ").append(this.qname);
        stringBuffer.append("\n    :signatureMethod \"").append(this.getSignatureMethod()).append("\"");
        stringBuffer.append("\n    :repudiable \"").append(this.repudiable()).append("\"");
        if (this.restriction != null) {
            stringBuffer.append("\n    :restriction \"").append(this.restriction).append("\"");
        }
        if ((x509Certificate = this.getCertificate()) != null) {
            stringBuffer.append("\n    :certificate \"").append(x509Certificate.getSubjectDN()).append("\"");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

