/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.assertion;

import java.security.cert.X509Certificate;
import weblogic.xml.security.SecurityAssertion;
import weblogic.xml.security.UserInfo;

public class IdentityAssertion
implements SecurityAssertion {
    private static final String type = "http://www.bea.com/servers/xml/security/assertion/Identity";
    private final UserInfo ui;
    private final X509Certificate cert;
    private final int proof;
    private final boolean repudiable;
    public static final int NO_PROOF = 0;
    public static final String STRING_NO_PROOF = "No Proof";
    public static final int POSSESSION_PROOF = 1;
    public static final String STRING_POSSESSION_PROOF = "Possession Proof";
    public static final int SHARED_SECRET_PROOF = 2;
    public static final String STRING_SHARED_SECRET_PROOF = "Shared Secret Proof";

    public IdentityAssertion(UserInfo userInfo) {
        this.ui = userInfo;
        this.cert = null;
        this.proof = this.ui.getPassword() != null ? 2 : (this.ui.getPasswordDigest() != null ? 1 : 0);
        this.repudiable = true;
    }

    public IdentityAssertion(X509Certificate x509Certificate, boolean bl) {
        this.ui = null;
        this.cert = x509Certificate;
        this.proof = bl ? 1 : 0;
        this.repudiable = bl;
    }

    public String getAssertionType() {
        return type;
    }

    public int getAssertionTypeCode() {
        return 0;
    }

    public boolean isAssertionType(String string) {
        return string == type || type.equals(string);
    }

    public boolean repudiable() {
        return this.repudiable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(").append("IdentityAssertion");
        if (this.ui != null) {
            stringBuffer.append(" ").append(this.ui.getUsername());
        } else if (this.cert != null) {
            stringBuffer.append(" \"").append(this.cert.getSubjectDN()).append("\"");
        }
        stringBuffer.append("\n    :proof \"").append(this.proofAsString()).append("\"");
        stringBuffer.append("\n    :repudiable \"").append(this.repudiable).append("\")");
        return stringBuffer.toString();
    }

    public String proofAsString() {
        switch (this.proof) {
            case 0: {
                return STRING_NO_PROOF;
            }
            case 1: {
                return STRING_POSSESSION_PROOF;
            }
            case 2: {
                return STRING_SHARED_SECRET_PROOF;
            }
        }
        return "Unknown";
    }

    public int getProofType() {
        return this.proof;
    }

    public UserInfo getUserInfo() {
        return this.ui;
    }

    public X509Certificate getX509Certificate() {
        return this.cert;
    }
}

