/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.assertion;

import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import weblogic.xml.security.SecurityAssertion;

public class IntegrityAssertion
implements SecurityAssertion {
    private static final String type = "http://www.bea.com/servers/xml/security/assertion/Integrity";
    private final boolean repudiable;
    private final String signatureMethod;
    private final X509Certificate cert;
    protected final String id;
    private Object serverSubject = null;

    public IntegrityAssertion(String string, String string2, X509Certificate x509Certificate) {
        this.signatureMethod = string;
        this.id = string2;
        this.cert = x509Certificate;
        this.repudiable = x509Certificate == null;
    }

    public String getId() {
        return this.id;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public static String getType() {
        return type;
    }

    public String getAssertionType() {
        return type;
    }

    public int getAssertionTypeCode() {
        return 1;
    }

    public boolean isAssertionType(String string) {
        return string == type || type.equals(string);
    }

    public boolean repudiable() {
        return this.repudiable;
    }

    final Object getSubject() {
        return this.serverSubject;
    }

    final void setSubject(Subject subject) {
        this.serverSubject = subject;
    }

    public String getPolicyString() {
        return "Integrity{id:" + this.id + "}";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(").append("IntegrityAssertion");
        stringBuffer.append(" :id ").append(this.id);
        stringBuffer.append("\n    :signatureMethod \"").append(this.getSignatureMethod()).append("\"");
        stringBuffer.append("\n    :repudiable \"").append(this.repudiable()).append("\"");
        if (this.cert != null) {
            stringBuffer.append("\n    :certificate \"").append(this.cert.getSubjectDN()).append("\"");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

