/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.io.InputStream;
import java.io.OutputStream;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.utils.io.UnsyncByteArrayOutputStream;
import weblogic.xml.security.encryption.CipherData;
import weblogic.xml.security.encryption.Utils;
import weblogic.xml.security.encryption.XMLEncConstants;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class CipherValue
extends CipherData
implements XMLEncConstants {
    private String cipherValue;
    private UnsyncByteArrayOutputStream baos;

    public CipherValue() {
    }

    public CipherValue(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public byte[] getCipherBytes() {
        return Utils.base64(this.cipherValue);
    }

    public InputStream getInputStream() {
        return new UnsyncByteArrayInputStream(this.getCipherBytes());
    }

    public void setCipherBytes(byte[] byArray) {
        this.cipherValue = Utils.base64(byArray);
    }

    public OutputStream getOutputStream() {
        if (this.baos != null) {
            return this.baos;
        }
        this.baos = new UnsyncByteArrayOutputStream();
        return this.baos;
    }

    public void clear() {
        this.cipherValue = null;
        this.baos.reset();
    }

    public String toString() {
        return "CipherValue: " + this.cipherValue;
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        StreamUtils.addStart(xMLOutputStream, string, "CipherData", n);
        if (this.baos != null) {
            this.cipherValue = Utils.base64(this.baos.toByteArray());
        }
        StreamUtils.addElement(xMLOutputStream, string, "CipherValue", this.cipherValue, n + 2, 2);
        StreamUtils.addEnd(xMLOutputStream, string, "CipherData", n);
    }

    static CipherData fromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        if (StreamUtils.peekElement(xMLInputStream, string, "CipherValue")) {
            return new CipherValue(xMLInputStream, string);
        }
        return null;
    }

    public void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.cipherValue = StreamUtils.getValue(xMLInputStream, string, "CipherValue");
    }
}

