/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.xml.security.encryption.CipherWrapper;
import weblogic.xml.security.encryption.EncryptionException;

public final class CipherWrapperInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private final CipherWrapper cipher;
    private final InputStream source;
    private final int blockLength;
    private final int bufferLength;
    private final byte[] buffer;
    private int boff;
    private int blen;
    private int threshold;
    private static final Logger LOGGER = Logger.getLogger(CipherWrapperInputStream.class.getName());

    public CipherWrapperInputStream(InputStream inputStream, CipherWrapper cipherWrapper) {
        this(inputStream, cipherWrapper, 2048);
    }

    public CipherWrapperInputStream(InputStream inputStream, CipherWrapper cipherWrapper, int n) {
        this.source = inputStream;
        this.cipher = cipherWrapper;
        this.blockLength = cipherWrapper.getBlockSize();
        this.bufferLength = Math.max(this.blockLength * 2, n);
        this.buffer = new byte[n];
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        this.read(byArray, 0, 1);
        return byArray[0];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.blen == -1) {
            return -1;
        }
        if (this.boff >= this.threshold) {
            for (n3 = 0; n3 < this.blen; ++n3) {
                this.buffer[n3] = this.buffer[this.boff + n3];
            }
            this.boff = 0;
            n3 = this.bufferLength - this.blen;
            int n4 = this.source.read(this.buffer, this.blen, n3);
            if (n4 == -1) {
                try {
                    this.cipher.doFinal(this.buffer, this.blen);
                }
                catch (EncryptionException encryptionException) {
                    CipherWrapperInputStream.throwIOException(encryptionException);
                }
                if (this.blen == 0) {
                    return -1;
                }
                byte by = this.buffer[this.blen - 1];
                int n5 = this.blen - by;
                if (n5 <= 0) {
                    return -1;
                }
                n5 = Math.min(n5, n2);
                System.arraycopy(this.buffer, this.boff, byArray, n, n5);
                this.boff += n5;
                this.blen = this.blen - this.boff == by ? -1 : (this.blen -= n5);
                return n5;
            }
            try {
                this.cipher.update(this.buffer, this.blen, n4, this.buffer, this.blen);
            }
            catch (EncryptionException encryptionException) {
                CipherWrapperInputStream.throwIOException(encryptionException);
            }
            this.blen += n4;
            this.threshold = this.blen - this.blockLength;
            if (this.threshold < 0) {
                this.threshold = 0;
                return 0;
            }
        }
        n3 = Math.min(this.threshold - this.boff, n2);
        System.arraycopy(this.buffer, this.boff, byArray, n, n3);
        this.boff += n3;
        this.blen -= n3;
        return n3;
    }

    private static void throwIOException(EncryptionException encryptionException) throws IOException {
        String string = "Found a cipher exception";
        Throwable throwable = encryptionException.getCause();
        if (throwable != null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, throwable.getMessage());
            }
            throw new IOException(string);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, encryptionException.getMessage());
        }
        throw new IOException(string);
    }
}

