/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.io.IOException;
import java.io.OutputStream;
import weblogic.xml.security.encryption.CipherWrapper;

final class CipherWrapperOutputStream
extends OutputStream {
    private final OutputStream dest;
    private final int blockSize;
    private final CipherWrapper cipher;
    private int cnt = 0;
    private int n = 0;

    CipherWrapperOutputStream(OutputStream outputStream, CipherWrapper cipherWrapper) {
        this.dest = outputStream;
        this.blockSize = cipherWrapper.getBlockSize();
        this.cipher = cipherWrapper;
    }

    public void write(int n) throws IOException {
        this.dest.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray.length < this.blockSize) {
            byte[] byArray2 = new byte[this.blockSize];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        }
        int n3 = this.cipher.update(byArray, n, n2, byArray, n);
        this.dest.write(byArray, n, n3);
        this.cnt += n3;
        this.n += n2;
    }

    public void flush() throws IOException {
        int n = this.blockSize - this.n % this.blockSize;
        byte[] byArray = new byte[n];
        byArray[n - 1] = (byte)n;
        this.write(byArray, 0, byArray.length);
        this.dest.write(this.cipher.doFinal());
        this.dest.flush();
    }

    public void close() throws IOException {
        this.flush();
    }
}

