/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import weblogic.xml.security.encryption.DataReference;
import weblogic.xml.security.encryption.EncryptedData;
import weblogic.xml.security.encryption.EncryptedType;
import weblogic.xml.security.encryption.KeyReference;
import weblogic.xml.security.encryption.ReferenceList;
import weblogic.xml.security.encryption.XMLEncConstants;
import weblogic.xml.security.encryption.XMLEncReader;
import weblogic.xml.security.keyinfo.KeyResolver;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ReferenceResolver;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;

public final class DecryptXMLInputStream
implements XMLInputStream,
XMLEncConstants {
    private final XMLInputStream source;
    private final String encoding;
    private final Set refs;
    private KeyResolver keyResolver;
    private DecryptXMLInputStream clearTextStream;

    public DecryptXMLInputStream(XMLInputStream xMLInputStream) {
        this(xMLInputStream, (Set)null, "UTF-8");
    }

    public DecryptXMLInputStream(XMLInputStream xMLInputStream, ReferenceList referenceList, String string) {
        this(xMLInputStream, referenceList != null ? new HashSet() : null, string);
        if (referenceList != null) {
            Iterator iterator = referenceList.getReferences();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof DataReference) {
                    this.refs.add(((DataReference)e).getURI());
                    continue;
                }
                this.refs.add(((KeyReference)e).getURI());
            }
        }
    }

    public DecryptXMLInputStream(XMLInputStream xMLInputStream, ReferenceList referenceList) {
        this(xMLInputStream, referenceList, "UTF-8");
    }

    private DecryptXMLInputStream(XMLInputStream xMLInputStream, Set set, String string) {
        this.refs = set;
        this.source = xMLInputStream;
        this.encoding = string;
    }

    public void setKeyResolver(KeyResolver keyResolver) {
        this.keyResolver = keyResolver;
    }

    public KeyResolver getKeyResolver() {
        return this.keyResolver;
    }

    public XMLEvent next() throws XMLStreamException {
        return this.getStream().next();
    }

    private static String getId(StartElement startElement) {
        AttributeIterator attributeIterator = startElement.getAttributes();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            if (!attribute.getName().getLocalName().toLowerCase(Locale.ENGLISH).equals("id")) continue;
            return attribute.getValue();
        }
        return null;
    }

    private XMLInputStream getStream() throws XMLStreamException {
        XMLEvent xMLEvent;
        if (this.clearTextStream != null) {
            xMLEvent = this.clearTextStream.peek();
            if (xMLEvent != null && !xMLEvent.isEndDocument() && !xMLEvent.isNull()) {
                return this.clearTextStream;
            }
            this.clearTextStream = null;
        }
        if ((xMLEvent = this.source.peek()) != null && xMLEvent.isStartElement() && "EncryptedData".equals(xMLEvent.getName().getLocalName())) {
            Object object;
            StartElement startElement = (StartElement)xMLEvent;
            if (!(this.refs == null || (object = DecryptXMLInputStream.getId(startElement)) != null && this.refs.contains("#" + (String)object))) {
                return this.source;
            }
            object = (EncryptedData)XMLEncReader.read(this.source, 1);
            if (object != null) {
                ((EncryptedType)object).setKeyResolver(this.keyResolver);
                this.clearTextStream = new DecryptXMLInputStream(((EncryptedData)object).getXMLInputStream(this.encoding), this.refs, this.encoding);
                this.clearTextStream.setKeyResolver(this.getKeyResolver());
                this.clearTextStream.setReferenceResolver(this.getReferenceResolver());
                if (this.clearTextStream.skip(256)) {
                    this.clearTextStream.skip();
                }
                return this.getStream();
            }
        }
        return this.source;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.getStream().hasNext();
    }

    public void skip() throws XMLStreamException {
        this.getStream().skip();
    }

    public void skipElement() throws XMLStreamException {
        this.getStream().skipElement();
    }

    public XMLEvent peek() throws XMLStreamException {
        return this.getStream().peek();
    }

    public boolean skip(int n) throws XMLStreamException {
        if (this.clearTextStream != null) {
            if (this.clearTextStream.skip(n)) {
                return true;
            }
            if (this.source.skip(n)) {
                this.clearTextStream = null;
                return true;
            }
            return false;
        }
        return this.source.skip(n);
    }

    public boolean skip(XMLName xMLName) throws XMLStreamException {
        if (this.clearTextStream != null) {
            if (this.clearTextStream.skip(xMLName)) {
                return true;
            }
            if (this.source.skip(xMLName)) {
                this.clearTextStream = null;
                return true;
            }
            return false;
        }
        return this.source.skip(xMLName);
    }

    public boolean skip(XMLName xMLName, int n) throws XMLStreamException {
        if (this.clearTextStream != null) {
            if (this.clearTextStream.skip(xMLName, n)) {
                return true;
            }
            if (this.source.skip(xMLName, n)) {
                this.clearTextStream = null;
                return true;
            }
            return false;
        }
        return this.source.skip(xMLName, n);
    }

    public XMLInputStream getSubStream() throws XMLStreamException {
        return this.getStream().getSubStream();
    }

    public void close() throws XMLStreamException {
        if (this.clearTextStream != null) {
            this.clearTextStream.close();
        }
        this.source.close();
    }

    public ReferenceResolver getReferenceResolver() {
        return this.source.getReferenceResolver();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.source.setReferenceResolver(referenceResolver);
    }
}

