/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.io.OutputStream;
import java.util.Map;
import weblogic.xml.babel.stream.XMLOutputStreamBase;
import weblogic.xml.security.encryption.EncryptedData;
import weblogic.xml.security.encryption.XMLEncConstants;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.utils.XMLEventBuffer;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public class EncryptXMLOutputStream
extends XMLOutputStreamBase
implements XMLEncConstants,
NSOutputStream {
    private NSOutputStream dest;
    private XMLOutputStream cipherTextStream;
    private EncryptedData encryptedData;
    private XMLEvent lastSpace;
    private int nesting;
    private int nodeCount;
    private String encoding;
    private final XMLEventBuffer debugBuffer = VERBOSE ? new XMLEventBuffer() : null;

    public EncryptXMLOutputStream(XMLOutputStream xMLOutputStream) {
        this(xMLOutputStream, "UTF-8");
    }

    public EncryptXMLOutputStream(XMLOutputStream xMLOutputStream, String string) {
        this.dest = !(xMLOutputStream instanceof NSOutputStream) ? new NamespaceAwareXOS(xMLOutputStream) : (NSOutputStream)xMLOutputStream;
        this.encoding = string;
        this.addPrefix("http://www.w3.org/2001/04/xmlenc#", "xenc");
    }

    public void beginEncrypt(EncryptedData encryptedData) throws XMLStreamException {
        this.dest.flush();
        this.flush();
        this.encryptedData = encryptedData;
        this.nesting = 0;
        this.nodeCount = 0;
        this.cipherTextStream = encryptedData.getXMLOutputStream(this.encoding);
    }

    public void endEncrypt() throws XMLStreamException {
        if (VERBOSE) {
            System.out.println("<!-- -- Begin data to be encrypted ----->");
            XMLOutputStream xMLOutputStream = XMLOutputStreamFactory.newInstance().newOutputStream((OutputStream)System.out);
            while (this.debugBuffer.hasNext()) {
                xMLOutputStream.add(this.debugBuffer.next());
            }
            xMLOutputStream.close(true);
            System.out.println("<!-----  End data to be encrypted  -- -->");
        }
        this.flush();
        this.cipherTextStream.flush();
        int n = this.calculateIndent();
        if (this.nodeCount > 1 || CONTENT_ONLY) {
            this.encryptedData.setType(2);
        } else {
            this.encryptedData.setType(1);
        }
        this.encryptedData.toXML(this.dest, "http://www.w3.org/2001/04/xmlenc#", n);
        this.cipherTextStream = null;
    }

    private int calculateIndent() {
        if (this.lastSpace == null) {
            return 0;
        }
        String string = ((CharacterData)this.lastSpace).getContent();
        int n = string.lastIndexOf(10);
        if (n == -1) {
            return string.length();
        }
        return string.length() - (n + 1);
    }

    protected boolean writeXMLEvent(XMLEvent xMLEvent) throws XMLStreamException {
        if (this.cipherTextStream != null) {
            if (VERBOSE) {
                this.debugBuffer.add(xMLEvent);
            }
            switch (xMLEvent.getType()) {
                case 128: 
                case 512: 
                case 1024: 
                case 2048: 
                case 4096: {
                    break;
                }
                case 4: {
                    --this.nesting;
                    break;
                }
                case 2: {
                    if (this.nesting == 0) {
                        ++this.nodeCount;
                    }
                    ++this.nesting;
                    break;
                }
                default: {
                    if (this.nesting != 0) break;
                    ++this.nodeCount;
                }
            }
            this.cipherTextStream.add(xMLEvent);
        } else {
            this.dest.add(xMLEvent);
        }
        if (xMLEvent.isSpace()) {
            this.lastSpace = xMLEvent;
        }
        return true;
    }

    public void flush() throws XMLStreamException {
        this.lastStartElement = null;
        this.write();
        this.dest.flush();
    }

    public void close() throws XMLStreamException {
        this.flush();
        this.dest.close();
    }

    public void close(boolean bl) throws XMLStreamException {
        if (bl) {
            this.flush();
        }
        this.dest.close(bl);
    }

    public void addPrefix(String string, String string2) {
        this.dest.addPrefix(string, string2);
    }

    public Map getNamespaces() {
        return this.dest.getNamespaces();
    }
}

