/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.Key;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.xml.security.encryption.EncryptedType;
import weblogic.xml.security.encryption.EncryptionAlgorithm;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.EncryptionMethod;
import weblogic.xml.security.encryption.XMLEncConstants;
import weblogic.xml.security.encryption.XMLEncReader;
import weblogic.xml.security.keyinfo.KeyPurpose;
import weblogic.xml.security.keyinfo.KeyResolverException;
import weblogic.xml.security.keyinfo.KeyResult;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public class EncryptedData
extends EncryptedType
implements XMLEncConstants {
    private static final XMLInputStreamFactory factory = XMLInputStreamFactory.newInstance();
    private EncryptionAlgorithm encryptionMethod;

    public EncryptedData() {
    }

    EncryptedData(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public XMLInputStream getXMLInputStream(String string) throws XMLStreamException {
        InputStream inputStream = this.getInputStream();
        InputStreamReader inputStreamReader = this.getReader(inputStream, string);
        return factory.newFragmentInputStream((Reader)inputStreamReader, this.nsMap);
    }

    private InputStreamReader getReader(InputStream inputStream, String string) {
        try {
            if (string != null) {
                return new InputStreamReader(inputStream, string);
            }
            return new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new InputStreamReader(inputStream);
        }
    }

    public InputStream getInputStream() throws EncryptionException {
        Object object;
        Key key = this.getKey();
        if (key == null && this.encryptionMethod != null) {
            object = null;
            try {
                object = this.resolveKey(KeyPurpose.DECRYPT, this.encryptionMethod.getURI(), this.getKeyInfo());
            }
            catch (KeyResolverException keyResolverException) {
                throw new EncryptionException("Unable to resolve decryption key", (Throwable)((Object)keyResolverException));
            }
            if (object != null) {
                key = ((KeyResult)object).getKey();
            }
        }
        if (key == null) {
            throw new EncryptionException("Cannot find key to perform decryption");
        }
        if (this.encryptionMethod == null) {
            throw new EncryptionException("Cannot determine EncryptionMethod");
        }
        object = this.encryptionMethod.decrypt(key, this.getCipherData().getInputStream());
        if (VERBOSE) {
            try {
                object = this.debugInput((InputStream)object);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                object = this.encryptionMethod.decrypt(key, this.getCipherData().getInputStream());
            }
        }
        return object;
    }

    private InputStream debugInput(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        System.out.println("<!-- -- Begin decrypted data from EncryptedData (id=" + this.id + ") ----->");
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        System.out.print(new String(byArray2));
        inputStream = new UnsyncByteArrayInputStream(byArray2);
        System.out.println("\n<!----- End decrypted data from EncryptedData (id=" + this.id + ")   -- -->");
        return inputStream;
    }

    public XMLOutputStream getXMLOutputStream(String string) throws XMLStreamException {
        try {
            return XMLOutputStreamFactory.newInstance().newOutputStream((Writer)new OutputStreamWriter(this.getOutputStream(), string));
        }
        catch (Exception exception) {
            return XMLOutputStreamFactory.newInstance().newOutputStream(this.getOutputStream());
        }
    }

    public OutputStream getOutputStream() throws EncryptionException {
        Key key = this.getKey();
        if (key == null && this.encryptionMethod != null) {
            KeyResult keyResult = null;
            try {
                keyResult = this.resolveKey(KeyPurpose.ENCRYPT, this.encryptionMethod.getURI(), this.getKeyInfo());
            }
            catch (KeyResolverException keyResolverException) {
                throw new EncryptionException("failed to resolve encryption key", (Throwable)((Object)keyResolverException));
            }
            key = keyResult.getKey();
        }
        if (key == null) {
            throw new EncryptionException("Must set key to perform encryption");
        }
        if (this.encryptionMethod == null) {
            throw new EncryptionException("Must set EncryptionMethod to perform encryption");
        }
        return this.encryptionMethod.encrypt(key, this.getCipherData().getOutputStream());
    }

    public void setEncryptionMethod(EncryptionMethod encryptionMethod) throws EncryptionException {
        if (!(encryptionMethod instanceof EncryptionAlgorithm)) {
            throw new EncryptionException(encryptionMethod.getURI() + " cannot be used as a block cipher");
        }
        this.encryptionMethod = (EncryptionAlgorithm)encryptionMethod;
    }

    EncryptionMethod getEncryptionMethodInternal() {
        return this.encryptionMethod;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EncryptedData").append(": \n");
        super.toString(stringBuffer);
        return stringBuffer.toString();
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        super.writeCommon(string, "EncryptedData", xMLOutputStream, n);
        StreamUtils.addEnd(xMLOutputStream, string, "EncryptedData", n);
        this.clear();
    }

    void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        super.readCommon(xMLInputStream, string);
        StreamUtils.closeScope(xMLInputStream, string, "EncryptedData");
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<EncryptedData Id=\"ED\" Type=\"http://www.w3.org/2001/04/xmlenc#Element\" xmlns=\"http://www.w3.org/2001/04/xmlenc#\">\n  <EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#tripledes-cbc\"/>\n  <ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">\n    <EncryptedKey Id=\"EK\" xmlns=\"http://www.w3.org/2001/04/xmlenc#\">\n       <EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#kw-tripledes\"/>\n      <ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">\n        <ds:KeyName>my-tripledes-key</ds:KeyName>\n      </ds:KeyInfo>\n      <CipherData>\n        <CipherValue>HgVuHoXxBQWD9fvi0gt9TanywZ5lJokM/12fcMG6gRoMjsCPulH+4A==</CipherValue>\n      </CipherData>\n      <ReferenceList>\n        <DataReference URI=\"#ED\"/>\n      </ReferenceList>\n     </EncryptedKey>\n  </ds:KeyInfo>\n  <CipherData>\n    <CipherValue>\n      yUMIHkj5EETckjZ59fpda4+m4YLCrkJsnuRz+Q3e5sP+VvHKRH1kdeGkXw3kYURVJM3nQjGl2egW80oUxSykQD2F9iDoIjNhLSgIbyuse64oo/5/v9IiaUpSvrAocwLPAzFIUmOrxmIagAkRGDOeMR8tdHLD6g84dQj4O/aGfwhL/2wUo/l+7onrbmsd6pVIfjNyvXm+eITuyUnkDTHrCR+dfb2sHaQ3g3McgyfP6ZjI/L50SPJZ/w==\n    </CipherValue>\n  </CipherData>\n</EncryptedData>\n");
        EncryptedData encryptedData = (EncryptedData)XMLEncReader.read(xMLInputStream);
        encryptedData.setKeyResolver(TestUtils.getDESKeyResolver());
        System.err.println("Deserialized:\n");
        System.out.println(encryptedData);
        System.err.println("\nReserialized:\n");
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        encryptedData.toXML(xMLOutputStream, "http://www.w3.org/2001/04/xmlenc#", 0);
        xMLOutputStream.flush();
        System.out.println("\n\nClear text:\n");
        XMLInputStream xMLInputStream2 = encryptedData.getXMLInputStream("UTF-8");
        XMLOutputStream xMLOutputStream2 = XMLOutputStreamFactory.newInstance().newOutputStream((OutputStream)System.out);
        xMLOutputStream2.add(xMLInputStream2);
        xMLOutputStream2.close();
    }
}

