/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.security.Key;
import java.security.PublicKey;
import weblogic.xml.security.encryption.EncryptedType;
import weblogic.xml.security.encryption.EncryptionAlgorithm;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.EncryptionMethod;
import weblogic.xml.security.encryption.KeyWrap;
import weblogic.xml.security.encryption.ReferenceList;
import weblogic.xml.security.keyinfo.KeyPurpose;
import weblogic.xml.security.keyinfo.KeyResolverException;
import weblogic.xml.security.keyinfo.KeyResult;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class EncryptedKey
extends EncryptedType {
    private ReferenceList referenceList;
    private String recipient;
    private String carriedKeyName;
    private KeyWrap encryptionMethod;
    private Key wrappedKey;

    public EncryptedKey(PublicKey publicKey) throws EncryptionException {
        this((Key)publicKey, "http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
    }

    public EncryptedKey(Key key, String string, String string2) throws EncryptionException {
        EncryptionMethod encryptionMethod = EncryptionMethod.get(string);
        if (!(encryptionMethod instanceof EncryptionAlgorithm)) {
            throw new EncryptionException(string + " cannot be used as a block cipher");
        }
        this.setKey(key);
        this.setEncryptionMethod(string2);
        this.setWrappedKey(((EncryptionAlgorithm)encryptionMethod).generateKey());
    }

    public EncryptedKey(Key key, Key key2, String string) throws EncryptionException {
        this.setKey(key);
        this.setEncryptionMethod(string);
        this.setWrappedKey(key2);
    }

    public EncryptedKey(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public void setEncryptionMethod(EncryptionMethod encryptionMethod) throws EncryptionException {
        if (!(encryptionMethod instanceof KeyWrap)) {
            throw new EncryptionException(encryptionMethod.getURI() + " cannot be used as a key wrap");
        }
        this.encryptionMethod = (KeyWrap)encryptionMethod;
    }

    EncryptionMethod getEncryptionMethodInternal() {
        return this.encryptionMethod;
    }

    public void setRecipient(String string) {
        this.recipient = string;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setCarriedKeyName(String string) {
        this.carriedKeyName = string;
    }

    public String getCarriedKeyName() {
        return this.carriedKeyName;
    }

    public ReferenceList getReferenceList() {
        return this.referenceList;
    }

    public void setReferenceList(ReferenceList referenceList) {
        this.referenceList = referenceList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EncryptedKey").append(": \n");
        super.toString(stringBuffer);
        return stringBuffer.toString();
    }

    public Key getWrappedKey() {
        return this.wrappedKey;
    }

    public Key getWrappedKey(EncryptionMethod encryptionMethod) throws EncryptionException {
        if (this.wrappedKey == null) {
            this.wrappedKey = EncryptedKey.getWrappedKey(encryptionMethod, this.getWrappedKeyBytes());
        }
        return this.wrappedKey;
    }

    public static Key getWrappedKey(EncryptionMethod encryptionMethod, byte[] byArray) throws EncryptionException {
        if (!(encryptionMethod instanceof EncryptionAlgorithm)) {
            throw new EncryptionException(encryptionMethod.getURI() + " cannot be used as a block cipher.");
        }
        EncryptionAlgorithm encryptionAlgorithm = (EncryptionAlgorithm)encryptionMethod;
        return encryptionAlgorithm.createKey(byArray);
    }

    protected final byte[] getWrappedKeyBytes() throws EncryptionException {
        Object object;
        Key key = this.getKey();
        if (key == null) {
            object = null;
            try {
                object = this.resolveKey(KeyPurpose.DECRYPT, this.encryptionMethod.getURI(), this.getKeyInfo());
            }
            catch (KeyResolverException keyResolverException) {
                throw new EncryptionException("Unable to resolve key wrapping key", (Throwable)((Object)keyResolverException));
            }
            key = ((KeyResult)object).getKey();
        }
        object = this.encryptionMethod.unwrap(key, this.getCipherData().getCipherBytes());
        return object;
    }

    public void setWrappedKey(Key key) throws EncryptionException {
        this.wrappedKey = key;
        Key key2 = this.getKey();
        if (key2 == null) {
            throw new EncryptionException("encrypting key not set");
        }
        byte[] byArray = key.getEncoded();
        if (this.encryptionMethod == null) {
            this.encryptionMethod = EncryptionMethod.getKeyWrap(key2.getAlgorithm());
        }
        byte[] byArray2 = this.encryptionMethod.wrap(key2, byArray);
        this.getCipherData().setCipherBytes(byArray2);
    }

    public void toXML(XMLOutputStream xMLOutputStream, int n) throws XMLStreamException {
        this.toXML(xMLOutputStream, "http://www.w3.org/2001/04/xmlenc#", n);
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        super.writeCommon(string, "EncryptedKey", xMLOutputStream, n);
        if (this.referenceList != null) {
            this.referenceList.toXML(xMLOutputStream, string, n + 2);
        }
        if (this.carriedKeyName != null) {
            StreamUtils.addElement(xMLOutputStream, string, "CarriedKeyName", this.carriedKeyName, n + 2);
        }
        StreamUtils.addEnd(xMLOutputStream, string, "EncryptedKey", n);
    }

    void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement = super.readCommon(xMLInputStream, string);
        this.recipient = StreamUtils.getAttribute(startElement, "Recipient");
        this.referenceList = ReferenceList.fromXML(xMLInputStream, string);
        this.carriedKeyName = StreamUtils.getValue(xMLInputStream, string, "CarriedKeyName");
        StreamUtils.closeScope(xMLInputStream, string, "EncryptedKey");
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<EncryptedKey Id=\"EK\" xmlns=\"http://www.w3.org/2001/04/xmlenc#\">\n  <EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#kw-tripledes\"/>\n  <ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">\n    <ds:KeyName>my-tripledes-key</ds:KeyName>\n  </ds:KeyInfo>\n  <CipherData>\n    <CipherValue>HgVuHoXxBQWD9fvi0gt9TanywZ5lJokM/12fcMG6gRoMjsCPulH+4A==</CipherValue>\n  </CipherData>\n</EncryptedKey>\n");
        EncryptedKey encryptedKey = new EncryptedKey(xMLInputStream, "http://www.w3.org/2001/04/xmlenc#");
        encryptedKey.setKeyResolver(TestUtils.getDESKeyResolver());
        System.out.println(encryptedKey);
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        encryptedKey.toXML(xMLOutputStream, "http://www.w3.org/2001/04/xmlenc#", 0);
        xMLOutputStream.flush();
    }
}

