/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.security.Key;
import weblogic.xml.security.encryption.EncryptedKey;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.EncryptionMethod;
import weblogic.xml.security.keyinfo.BaseKeyProvider;
import weblogic.xml.security.keyinfo.KeyProvider;
import weblogic.xml.security.keyinfo.KeyPurpose;
import weblogic.xml.security.keyinfo.KeyResult;
import weblogic.xml.security.keyinfo.Utils;

public class EncryptedKeyProvider
extends BaseKeyProvider {
    private final byte[] keyBytes;
    private KeyResult keyResult = null;
    private static final int TRIPLEDES_KEY_LENGTH = 24;

    public EncryptedKeyProvider(EncryptedKey encryptedKey) throws EncryptionException {
        super(encryptedKey.getCarriedKeyName(), null, encryptedKey.getId());
        this.keyBytes = encryptedKey.getWrappedKeyBytes();
    }

    public KeyResult getKey(String string, KeyPurpose keyPurpose) {
        try {
            if (this.keyResult != null) {
                return this.keyResult;
            }
            Key key = null;
            if (Utils.supports(KeyProvider.AES_ALGORITHMS, string)) {
                key = EncryptedKey.getWrappedKey(EncryptionMethod.get(string), this.keyBytes);
            } else if (Utils.supports(KeyProvider.TRIPLEDES_ALGORITHMS, string) && this.is3DESKey(this.keyBytes)) {
                key = EncryptedKey.getWrappedKey(EncryptionMethod.get(string), this.keyBytes);
            }
            if (key != null) {
                this.keyResult = new KeyResult(key);
            }
            return this.keyResult;
        }
        catch (EncryptionException encryptionException) {
            return null;
        }
    }

    private boolean is3DESKey(byte[] byArray) {
        return byArray.length == 24;
    }

    public String toString() {
        return "weblogic.xml.security.encryption.EncryptedKeyProvider{name=" + this.getName() + ", uri=" + this.getUri() + ", keyBytes=" + (this.keyBytes == null ? null : "length:" + this.keyBytes.length) + ", keyResult=" + this.keyResult + "}";
    }
}

