/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.xml.security.encryption.CipherData;
import weblogic.xml.security.encryption.CipherValue;
import weblogic.xml.security.encryption.EncryptedData;
import weblogic.xml.security.encryption.EncryptedKey;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.EncryptionMethod;
import weblogic.xml.security.encryption.XMLEncConstants;
import weblogic.xml.security.encryption.XMLEncReader;
import weblogic.xml.security.keyinfo.KeyInfo;
import weblogic.xml.security.keyinfo.KeyPurpose;
import weblogic.xml.security.keyinfo.KeyResolver;
import weblogic.xml.security.keyinfo.KeyResolverException;
import weblogic.xml.security.keyinfo.KeyResult;
import weblogic.xml.security.signature.DSIGReader;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class EncryptedType
implements XMLEncConstants {
    public static final String TYPE_ELEMENT_URI = "http://www.w3.org/2001/04/xmlenc#Element";
    public static final String TYPE_CONTENT_URI = "http://www.w3.org/2001/04/xmlenc#Content";
    public static final int TYPE_ELEMENT = 1;
    public static final int TYPE_CONTENT = 2;
    public static final int TYPE_OTHER = 3;
    KeyInfo keyInfo;
    CipherData cipherData;
    String id;
    int type;
    String mimeType;
    String encoding;
    private KeyResolver keyResolver;
    private Key key;
    protected Map nsMap;

    abstract EncryptionMethod getEncryptionMethodInternal();

    public abstract void setEncryptionMethod(EncryptionMethod var1) throws EncryptionException;

    public void setEncryptionMethod(String string) throws EncryptionException {
        this.setEncryptionMethod(EncryptionMethod.get(string));
    }

    public String getEncryptionMethod() {
        EncryptionMethod encryptionMethod = this.getEncryptionMethodInternal();
        if (encryptionMethod == null) {
            return null;
        }
        return encryptionMethod.getURI();
    }

    public void setType(String string) {
        this.type = TYPE_ELEMENT_URI.equals(string) ? 1 : (TYPE_CONTENT_URI.equals(string) ? 2 : 3);
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeURI() {
        switch (this.type) {
            case 1: {
                return TYPE_ELEMENT_URI;
            }
            case 2: {
                return TYPE_CONTENT_URI;
            }
        }
        return null;
    }

    public void setKeyResolver(KeyResolver keyResolver) {
        this.keyResolver = keyResolver;
    }

    public KeyResolver getKeyResolver() {
        return this.keyResolver;
    }

    KeyResult resolveKey(KeyPurpose keyPurpose, String string, KeyInfo keyInfo) throws EncryptionException, KeyResolverException {
        Iterator iterator;
        if (keyInfo != null && (iterator = keyInfo.getEncryptedKeys()).hasNext()) {
            EncryptedKey encryptedKey = (EncryptedKey)iterator.next();
            encryptedKey.setKeyResolver(this.keyResolver);
            Key key = encryptedKey.getWrappedKey(this.getEncryptionMethodInternal());
            return new KeyResult(key);
        }
        if (this.keyResolver != null) {
            return this.keyResolver.resolveKey(keyPurpose, this.getEncryptionMethod(), keyInfo);
        }
        throw new EncryptionException("Cannot resolve key for: " + keyInfo);
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.keyInfo = keyInfo;
    }

    public CipherData getCipherData() {
        if (this.cipherData == null) {
            this.cipherData = new CipherValue();
        }
        return this.cipherData;
    }

    public void setCipherData(CipherData cipherData) {
        this.cipherData = cipherData;
    }

    public void clear() {
        this.cipherData.clear();
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public void setKey(EncryptedKey encryptedKey) {
        this.setKey(encryptedKey.getWrappedKey());
    }

    public Key getKey() {
        return this.key;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EncryptedType").append(":\n");
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    void toString(StringBuffer stringBuffer) {
        stringBuffer.append("  ").append(this.getEncryptionMethod()).append("\n").append("  ").append(this.keyInfo).append("\n").append("  ").append(this.cipherData);
    }

    void writeCommon(String string, String string2, XMLOutputStream xMLOutputStream, int n) throws XMLStreamException {
        Attribute[] attributeArray = new Attribute[]{StreamUtils.createAttribute("Id", this.id), StreamUtils.createAttribute("Type", this.getTypeURI()), StreamUtils.createAttribute("MimeType", this.mimeType), StreamUtils.createAttribute("Encoding", this.encoding)};
        if (this instanceof EncryptedData && this.getType() == 1) {
            StreamUtils.addStart(xMLOutputStream, string, string2, attributeArray);
        } else {
            StreamUtils.addStart(xMLOutputStream, string, string2, attributeArray, n);
        }
        EncryptionMethod encryptionMethod = this.getEncryptionMethodInternal();
        if (encryptionMethod != null) {
            encryptionMethod.toXML(xMLOutputStream, string, n + 2);
        }
        if (this.keyInfo != null) {
            this.keyInfo.toXML(xMLOutputStream, n + 2);
        }
        this.cipherData.toXML(xMLOutputStream, string, n + 2);
    }

    StartElement readCommon(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement = (StartElement)xMLInputStream.next();
        this.nsMap = new HashMap();
        this.nsMap.putAll(startElement.getNamespaceMap());
        this.id = StreamUtils.getAttribute(startElement, "Id");
        this.setType(StreamUtils.getAttribute(startElement, "Type"));
        this.mimeType = StreamUtils.getAttribute(startElement, "MimeType");
        this.encoding = StreamUtils.getAttribute(startElement, "Encoding");
        EncryptionMethod encryptionMethod = (EncryptionMethod)XMLEncReader.read(xMLInputStream, 3);
        this.setEncryptionMethod(encryptionMethod);
        this.keyInfo = (KeyInfo)DSIGReader.read(xMLInputStream, 4);
        this.cipherData = CipherData.fromXML(xMLInputStream, string);
        StreamUtils.required(this.cipherData, "EncryptedType", "CipherData");
        return startElement;
    }
}

