/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.spec.SecretKeySpec;
import weblogic.xml.security.encryption.CipherWrapper;
import weblogic.xml.security.encryption.CipherWrapperInputStream;
import weblogic.xml.security.encryption.CipherWrapperOutputStream;
import weblogic.xml.security.encryption.EncryptionAlgorithm;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.EncryptionMethod;
import weblogic.xml.security.encryption.EncryptionMethodFactory;
import weblogic.xml.security.encryption.Utils;

final class EncryptionAlgorithmAES
extends EncryptionAlgorithm
implements EncryptionMethodFactory {
    static final String URI_128 = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    static final String URI_192 = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    static final String URI_256 = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    private static final String ALGORITHM_ID = "AES/CBC/NoPadding";
    private static final String KEY_FACTORY_ID = "AES";
    private static final int IV_LEN = 16;
    private final String uri;
    private final int keyLen;

    private EncryptionAlgorithmAES(String string, int n) {
        this.uri = string;
        this.keyLen = n;
    }

    public String getURI() {
        return this.uri;
    }

    static void init() {
        EncryptionMethod.register(new EncryptionAlgorithmAES(URI_128, 16));
        EncryptionMethod.register(new EncryptionAlgorithmAES(URI_192, 24));
        EncryptionMethod.register(new EncryptionAlgorithmAES(URI_256, 32));
    }

    public EncryptionMethod newEncryptionMethod() {
        return this;
    }

    public InputStream decrypt(Key key, InputStream inputStream) throws EncryptionException {
        byte[] byArray = new byte[16];
        Utils.readIV(inputStream, byArray);
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 2, key, byArray);
        return new CipherWrapperInputStream(inputStream, cipherWrapper);
    }

    public OutputStream encrypt(Key key, OutputStream outputStream) throws EncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 1, key);
        Utils.writeIV(outputStream, cipherWrapper.getIV());
        return new CipherWrapperOutputStream(outputStream, cipherWrapper);
    }

    public Key createKey(byte[] byArray) throws EncryptionException {
        return new SecretKeySpec(byArray, KEY_FACTORY_ID);
    }

    public Key generateKey() throws EncryptionException {
        byte[] byArray = new byte[this.keyLen];
        rand.nextBytes(byArray);
        return this.createKey(byArray);
    }

    public Key generateKey(byte[] byArray, byte[] byArray2) throws EncryptionException {
        try {
            if (byArray2 != null) {
                byte[] byArray3 = Utils.P_SHA1(byArray, byArray2, this.keyLen);
                return this.createKey(byArray3);
            }
            return this.createKey(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EncryptionException("unable to generate key", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new EncryptionException("unable to generate key", invalidKeyException);
        }
    }
}

