/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_SecretKey;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import weblogic.xml.security.encryption.CipherWrapper;
import weblogic.xml.security.encryption.CipherWrapperInputStream;
import weblogic.xml.security.encryption.CipherWrapperOutputStream;
import weblogic.xml.security.encryption.EncryptionAlgorithm;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.EncryptionMethod;
import weblogic.xml.security.encryption.EncryptionMethodFactory;
import weblogic.xml.security.encryption.Utils;

public final class EncryptionAlgorithmDES3
extends EncryptionAlgorithm
implements EncryptionMethodFactory {
    static final String URI = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    private static final String ALGORITHM_ID = "3DES_EDE/CBC/NoPad";
    private static final String KEY_FACTORY_ID = "DESEDE";
    private static final String JSAFE_KEY_FACTORY_ID = "3DES_EDE";
    private static final String JSAFE_PROVIDER = "Java";
    private static final int IV_LEN = 8;
    private final String uri;
    private static final int TRIPLE_DES_KEYLENGTH = 21;

    private EncryptionAlgorithmDES3(String string) {
        this.uri = string;
    }

    public String getURI() {
        return this.uri;
    }

    public static void init() {
        EncryptionMethod.register(new EncryptionAlgorithmDES3(URI));
    }

    public EncryptionMethod newEncryptionMethod() {
        return this;
    }

    public InputStream decrypt(Key key, InputStream inputStream) throws EncryptionException {
        byte[] byArray = new byte[8];
        Utils.readIV(inputStream, byArray);
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 2, key, byArray);
        return new CipherWrapperInputStream(inputStream, cipherWrapper);
    }

    public OutputStream encrypt(Key key, OutputStream outputStream) throws EncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 1, key);
        Utils.writeIV(outputStream, cipherWrapper.getIV());
        return new CipherWrapperOutputStream(outputStream, cipherWrapper);
    }

    public Key createKey(byte[] byArray) throws EncryptionException {
        try {
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(KEY_FACTORY_ID);
            return secretKeyFactory.generateSecret(dESedeKeySpec);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new EncryptionException("Invalid key supplied to " + this.getURI(), invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EncryptionException("Cannot locate JCE algorithm (DESEDE) necessary for generating a secret key for: " + this.getURI(), noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new EncryptionException("Unexpected exception when generating key for: " + this.getURI(), invalidKeySpecException);
        }
    }

    public Key generateKey() throws EncryptionException {
        try {
            JSAFE_SecretKey jSAFE_SecretKey = JSAFE_SecretKey.getInstance((String)JSAFE_KEY_FACTORY_ID, (String)JSAFE_PROVIDER);
            jSAFE_SecretKey.generateInit(null, Utils.getRNG());
            jSAFE_SecretKey.generate();
            return this.createKey(jSAFE_SecretKey.getSecretKeyData());
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new EncryptionException(jSAFE_Exception);
        }
    }

    public Key generateKey(byte[] byArray, byte[] byArray2) throws EncryptionException {
        try {
            byte[] byArray3 = Utils.P_SHA1(byArray, byArray2, 21);
            byte[] byArray4 = Utils.tripleDESParity(byArray3);
            return this.createKey(byArray4);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new EncryptionException("unable to generate key", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new EncryptionException("unable to generate key", invalidKeyException);
        }
    }
}

