/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.util.Locale;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.security.encryption.EncryptionAlgorithmAES;
import weblogic.xml.security.encryption.EncryptionAlgorithmDES3;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.EncryptionMethodFactory;
import weblogic.xml.security.encryption.KeyWrap;
import weblogic.xml.security.encryption.KeyWrapAES;
import weblogic.xml.security.encryption.KeyWrapDES3;
import weblogic.xml.security.encryption.KeyWrapFactory;
import weblogic.xml.security.encryption.KeyWrapRSA;
import weblogic.xml.security.encryption.KeyWrapRSAOAEP;
import weblogic.xml.security.encryption.XMLEncConstants;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class EncryptionMethod
implements XMLEncConstants {
    public static final String TRIPLEDES_CBC = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES128_CBC = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES192_CBC = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String AES256_CBC = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String KW_TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String KW_AES128 = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String KW_AES192 = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String KW_AES256 = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    public static final String KW_RSA_1_5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String KW_RSA_OAEP = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    private static final ConcurrentHashMap factories = new ConcurrentHashMap();
    private static final ConcurrentHashMap keyWraps = new ConcurrentHashMap();

    private static final void initFactories() {
        EncryptionAlgorithmDES3.init();
        EncryptionAlgorithmAES.init();
        KeyWrapDES3.init();
        KeyWrapAES.init();
        KeyWrapRSA.init();
        KeyWrapRSAOAEP.init();
    }

    public abstract String getURI();

    public String toString() {
        return "EncryptionMethod:  algorithmURI = " + this.getURI();
    }

    public static void register(EncryptionMethodFactory encryptionMethodFactory) {
        factories.put((Object)encryptionMethodFactory.getURI(), (Object)encryptionMethodFactory);
        if (encryptionMethodFactory instanceof KeyWrapFactory) {
            EncryptionMethod.registerKeyWrap((KeyWrapFactory)encryptionMethodFactory);
        }
    }

    private static void registerKeyWrap(KeyWrapFactory keyWrapFactory) {
        keyWraps.put((Object)keyWrapFactory.getAlgorithm().toLowerCase(Locale.ENGLISH), (Object)keyWrapFactory);
    }

    public static EncryptionMethod get(String string) throws EncryptionException {
        EncryptionMethodFactory encryptionMethodFactory = (EncryptionMethodFactory)factories.get((Object)string);
        if (encryptionMethodFactory == null) {
            throw new EncryptionException(string + " not supported");
        }
        return encryptionMethodFactory.newEncryptionMethod();
    }

    static KeyWrap getKeyWrap(String string) throws EncryptionException {
        KeyWrapFactory keyWrapFactory = (KeyWrapFactory)keyWraps.get((Object)string.toLowerCase(Locale.ENGLISH));
        if (keyWrapFactory == null) {
            throw new EncryptionException(string + " not supported");
        }
        return keyWrapFactory.newKeyWrap();
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Attribute[] attributeArray = new Attribute[]{ElementFactory.createAttribute("Algorithm", this.getURI())};
        StreamUtils.addStart(xMLOutputStream, string, "EncryptionMethod", attributeArray, n);
        this.toXMLInternal(xMLOutputStream, string, n);
        StreamUtils.addEnd(xMLOutputStream, string, "EncryptionMethod", n);
    }

    protected void toXMLInternal(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
    }

    static EncryptionMethod fromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        EncryptionMethod encryptionMethod = null;
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "EncryptionMethod");
        if (startElement != null) {
            String string2 = StreamUtils.getAttribute(startElement, "Algorithm");
            StreamUtils.requiredAttr(string2, "EncryptionMethod", "Algorithm");
            encryptionMethod = EncryptionMethod.get(string2);
            StreamUtils.getElement(xMLInputStream, string, "KeySize");
            encryptionMethod.fromXMLInternal(xMLInputStream, string);
            StreamUtils.closeScope(xMLInputStream, string, "EncryptionMethod");
        }
        return encryptionMethod;
    }

    protected void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<EncryptionMethod xmlns=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.w3.org/2001/04/xmlenc#tripledes-cbc\"/>\n");
        EncryptionMethod encryptionMethod = EncryptionMethod.fromXML(xMLInputStream, "http://www.w3.org/2001/04/xmlenc#");
        System.out.println(encryptionMethod);
        System.out.println("Implemented by: " + encryptionMethod.getClass().getName());
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        encryptionMethod.toXML(xMLOutputStream, "http://www.w3.org/2001/04/xmlenc#", 0);
        xMLOutputStream.flush();
    }

    static {
        EncryptionMethod.initFactories();
    }
}

