/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.security.Key;
import java.util.Arrays;
import weblogic.xml.security.encryption.CipherWrapper;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.EncryptionMethod;
import weblogic.xml.security.encryption.KeyWrap;
import weblogic.xml.security.encryption.KeyWrapFactory;

public class KeyWrapAES
extends KeyWrap
implements KeyWrapFactory {
    static final String URI_KW_128 = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    static final String URI_KW_192 = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    static final String URI_KW_256 = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    private static final String ALGORITHM_ID = "AES/ECB/NoPadding";
    private static final String KEY_FACTORY_ID = "AES";
    private static final int BLOCK_LEN = 8;
    private static final byte[] IV = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    private final String uri;

    private KeyWrapAES(String string) {
        this.uri = string;
    }

    public String getURI() {
        return this.uri;
    }

    public String getAlgorithm() {
        return KEY_FACTORY_ID;
    }

    public static void init() {
        EncryptionMethod.register(new KeyWrapAES(URI_KW_128));
        EncryptionMethod.register(new KeyWrapAES(URI_KW_192));
        EncryptionMethod.register(new KeyWrapAES(URI_KW_256));
    }

    public EncryptionMethod newEncryptionMethod() {
        return this;
    }

    public KeyWrap newKeyWrap() {
        return this;
    }

    public byte[] unwrap(Key key, byte[] byArray) throws EncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 2, key);
        int n = byArray.length;
        if (n % 8 != 0) {
            throw new EncryptionException("Invalid key passed to " + this.getURI() + " size=" + n * 8);
        }
        int n2 = (n >> 3) - 1;
        if (n2 < 2 || n2 > 4) {
            throw new AssertionError((Object)("Invalid key size: " + n2 * 8));
        }
        byte[] byArray2 = new byte[IV.length];
        byte[] byArray3 = new byte[n - IV.length];
        byte[] byArray4 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray3.length);
        for (int i = 5; i >= 0; --i) {
            for (int j = n2; j >= 1; --j) {
                int n3 = j + i * n2;
                byArray2[7] = (byte)(byArray2[7] ^ n3);
                System.arraycopy(byArray2, 0, byArray4, 0, 8);
                System.arraycopy(byArray3, (j - 1) * 8, byArray4, 8, 8);
                cipherWrapper.update(byArray4, 0, byArray4.length, byArray4, 0);
                System.arraycopy(byArray4, 0, byArray2, 0, 8);
                System.arraycopy(byArray4, 8, byArray3, (j - 1) * 8, 8);
            }
        }
        if (!Arrays.equals(byArray2, IV)) {
            throw new EncryptionException("Failed to unwrap key");
        }
        return byArray3;
    }

    public byte[] wrap(Key key, byte[] byArray) throws EncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 1, key);
        int n = byArray.length;
        if (n % 8 != 0) {
            throw new EncryptionException("Invalid key passed to " + this.getURI() + " size=" + n * 8);
        }
        int n2 = n >> 3;
        if (n2 < 2 || n2 > 4) {
            throw new AssertionError((Object)("Invalid key size: " + n2 * 8));
        }
        byte[] byArray2 = new byte[IV.length];
        System.arraycopy(IV, 0, byArray2, 0, IV.length);
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        byte[] byArray4 = new byte[16];
        for (int i = 0; i <= 5; ++i) {
            for (int j = 1; j <= n2; ++j) {
                int n3 = j + i * n2;
                System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                System.arraycopy(byArray3, (j - 1) * 8, byArray4, byArray2.length, 8);
                cipherWrapper.update(byArray4, 0, byArray4.length, byArray4, 0);
                System.arraycopy(byArray4, 0, byArray2, 0, 8);
                System.arraycopy(byArray4, 8, byArray3, (j - 1) * 8, 8);
                byArray2[7] = (byte)(byArray2[7] ^ n3);
            }
        }
        byte[] byArray5 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray5, byArray2.length, byArray3.length);
        return byArray5;
    }
}

