/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.security.Key;
import weblogic.xml.security.encryption.CipherWrapper;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.EncryptionMethod;
import weblogic.xml.security.encryption.KeyWrap;
import weblogic.xml.security.encryption.KeyWrapFactory;

public class KeyWrapRSA
extends KeyWrap
implements KeyWrapFactory {
    public static final String URI = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    private static final String ALGORITHM_ID = "RSA";
    private static final String KEY_FACTORY_ID = "RSA";
    private final String uri;

    private KeyWrapRSA(String string) {
        this.uri = string;
    }

    public String getURI() {
        return this.uri;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public static void init() {
        EncryptionMethod.register(new KeyWrapRSA(URI));
    }

    public EncryptionMethod newEncryptionMethod() {
        return this;
    }

    public KeyWrap newKeyWrap() {
        return this;
    }

    public byte[] unwrap(Key key, byte[] byArray) throws EncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance("RSA", 2, key);
        return cipherWrapper.decrypt(byArray);
    }

    public byte[] wrap(Key key, byte[] byArray) throws EncryptionException {
        CipherWrapper cipherWrapper = CipherWrapper.getInstance("RSA", 1, key);
        return cipherWrapper.encrypt(byArray);
    }
}

