/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import com.bea.security.utils.random.SecureRandomData;
import java.security.Key;
import java.security.MessageDigest;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import weblogic.xml.security.encryption.CipherWrapper;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.EncryptionMethod;
import weblogic.xml.security.encryption.KeyWrap;
import weblogic.xml.security.encryption.KeyWrapFactory;
import weblogic.xml.security.encryption.Utils;
import weblogic.xml.security.encryption.XMLEncConstants;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DSIGReader;
import weblogic.xml.security.signature.DigestMethod;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.XMLSecurityException;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class KeyWrapRSAOAEP
extends KeyWrap
implements KeyWrapFactory,
XMLEncConstants,
DSIGConstants {
    public static final String URI = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    private static final String ALGORITHM_ID = "RSA/NoPad";
    private static final String KEY_FACTORY_ID = "RSA";
    private final String uri;
    private byte[] oaepParams = new byte[0];
    private DigestMethod digestMethod;

    private KeyWrapRSAOAEP(String string) {
        this.uri = string;
    }

    public String getURI() {
        return this.uri;
    }

    public String getAlgorithm() {
        return KEY_FACTORY_ID;
    }

    public static void init() {
        EncryptionMethod.register(new KeyWrapRSAOAEP(URI));
    }

    public byte[] getOAEPParams() {
        return this.oaepParams;
    }

    public void setOAEPParams(byte[] byArray) {
        this.oaepParams = byArray;
    }

    public void setDigestMethod(String string) throws XMLSecurityException {
        this.digestMethod = DigestMethod.get(string);
    }

    protected void toXMLInternal(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        if (this.oaepParams != null && this.oaepParams.length > 0) {
            String string2 = Utils.base64(this.oaepParams);
            StreamUtils.addElement(xMLOutputStream, string, "OAEPparams", string2, n + 2);
            this.digestMethod.toXML(xMLOutputStream, string, n + 2);
        }
    }

    public void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        String string2 = StreamUtils.getValue(xMLInputStream, string, "OAEPparams");
        if (string2 != null) {
            this.oaepParams = Utils.base64(string2);
        }
        this.digestMethod = (DigestMethod)DSIGReader.read(xMLInputStream, 2);
    }

    public EncryptionMethod newEncryptionMethod() {
        return new KeyWrapRSAOAEP(URI);
    }

    public KeyWrap newKeyWrap() {
        return new KeyWrapRSAOAEP(URI);
    }

    public byte[] unwrap(Key key, byte[] byArray) throws EncryptionException {
        if (!(key instanceof RSAPrivateKey)) {
            throw new EncryptionException("Invalid key supplied to: " + this.getURI() + ", expecting RSAPrivateKey");
        }
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 2, key);
        byte[] byArray2 = cipherWrapper.decrypt(byArray);
        int n = (rSAPrivateKey.getModulus().bitLength() + 7) / 8;
        byte[] byArray3 = new byte[n - 1];
        int n2 = Math.min(byArray2.length, byArray3.length);
        int n3 = byArray2.length - n2;
        int n4 = byArray3.length - n2;
        System.arraycopy(byArray2, n3, byArray3, n4, n2);
        byArray2 = byArray3;
        if (this.digestMethod == null) {
            this.digestMethod = KeyWrapRSAOAEP.getDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        }
        MessageDigest messageDigest = this.digestMethod.getMessageDigest();
        return KeyWrapRSAOAEP.oaepDecode(messageDigest, byArray2, this.oaepParams);
    }

    public byte[] wrap(Key key, byte[] byArray) throws EncryptionException {
        if (!(key instanceof RSAPublicKey)) {
            throw new EncryptionException("Invalid key supplied to: " + this.getURI() + ", expecting RSAPublicKey");
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
        CipherWrapper cipherWrapper = CipherWrapper.getInstance(ALGORITHM_ID, 1, key);
        int n = (rSAPublicKey.getModulus().bitLength() + 7) / 8;
        if (this.digestMethod == null) {
            this.digestMethod = KeyWrapRSAOAEP.getDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        }
        MessageDigest messageDigest = this.digestMethod.getMessageDigest();
        byte[] byArray2 = KeyWrapRSAOAEP.oaepEncode(messageDigest, byArray, this.oaepParams, n - 1);
        byte[] byArray3 = new byte[byArray2.length + 1];
        System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
        byArray2 = byArray3;
        return cipherWrapper.encrypt(byArray2);
    }

    static byte[] oaepDecode(MessageDigest messageDigest, byte[] byArray, byte[] byArray2) throws EncryptionException {
        int n;
        int n2 = messageDigest.getDigestLength();
        if (byArray.length < 2 * n2 + 1) {
            throw new EncryptionException("decoding error");
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        byte[] byArray4 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray4, 0, byArray.length - n2);
        byte[] byArray5 = new byte[n2];
        DigestMethod digestMethod = KeyWrapRSAOAEP.getDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        MessageDigest messageDigest2 = digestMethod.getMessageDigest();
        KeyWrapRSAOAEP.mgf1(messageDigest2, byArray4, byArray5);
        for (int i = 0; i < n2; ++i) {
            int n3 = i;
            byArray3[n3] = (byte)(byArray3[n3] ^ byArray5[i]);
        }
        messageDigest2.reset();
        byte[] byArray6 = new byte[byArray.length - n2];
        KeyWrapRSAOAEP.mgf1(messageDigest2, byArray3, byArray6);
        for (int i = 0; i < byArray4.length; ++i) {
            int n4 = i;
            byArray4[n4] = (byte)(byArray4[n4] ^ byArray6[i]);
        }
        messageDigest.update(byArray2);
        byte[] byArray7 = messageDigest.digest();
        for (n = 0; n < byArray7.length; ++n) {
            if (byArray7[n] == byArray4[n]) continue;
            throw new EncryptionException("decoding error");
        }
        n = -1;
        for (int i = n2; i < byArray4.length; ++i) {
            if (byArray4[i] != 1) continue;
            n = i + 1;
            break;
        }
        if (n == -1) {
            throw new EncryptionException("decoding error");
        }
        byte[] byArray8 = new byte[byArray4.length - n];
        System.arraycopy(byArray4, n, byArray8, 0, byArray8.length);
        return byArray8;
    }

    static byte[] oaepEncode(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, int n) throws EncryptionException {
        int n2 = messageDigest.getDigestLength();
        if (byArray.length > n - 2 * n2 - 1) {
            throw new EncryptionException("Export strength certificates not supported");
        }
        byte[] byArray3 = messageDigest.digest(byArray2);
        byte[] byArray4 = new byte[n - n2];
        System.arraycopy(byArray3, 0, byArray4, 0, n2);
        int n3 = byArray4.length - byArray.length;
        System.arraycopy(byArray, 0, byArray4, n3, byArray.length);
        byArray4[n3 - 1] = 1;
        byte[] byArray5 = SecureRandomData.getInstance().getRandomBytes(n2);
        byte[] byArray6 = new byte[byArray4.length];
        DigestMethod digestMethod = KeyWrapRSAOAEP.getDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        MessageDigest messageDigest2 = digestMethod.getMessageDigest();
        KeyWrapRSAOAEP.mgf1(messageDigest2, byArray5, byArray6);
        for (int i = 0; i < byArray4.length; ++i) {
            int n4 = i;
            byArray6[n4] = (byte)(byArray6[n4] ^ byArray4[i]);
        }
        byte[] byArray7 = new byte[n2];
        messageDigest2.reset();
        KeyWrapRSAOAEP.mgf1(messageDigest2, byArray6, byArray7);
        for (int i = 0; i < byArray7.length; ++i) {
            int n5 = i;
            byArray7[n5] = (byte)(byArray7[n5] ^ byArray5[i]);
        }
        byte[] byArray8 = new byte[byArray7.length + byArray4.length];
        System.arraycopy(byArray7, 0, byArray8, 0, byArray7.length);
        System.arraycopy(byArray6, 0, byArray8, byArray7.length, byArray6.length);
        return byArray8;
    }

    static void mgf1(MessageDigest messageDigest, byte[] byArray, byte[] byArray2) {
        int n = byArray2.length;
        int n2 = messageDigest.getDigestLength();
        int n3 = 0;
        int n4 = n / n2 + (1 % n2 > 0 ? 1 : 0);
        byte[] byArray3 = new byte[byArray.length + 4];
        for (int i = 0; i < n4; ++i) {
            messageDigest.update(byArray);
            messageDigest.update(KeyWrapRSAOAEP.i2osp(i));
            byte[] byArray4 = messageDigest.digest();
            int n5 = Math.min(n2, n - n3);
            System.arraycopy(byArray4, 0, byArray2, n3, n5);
            n3 += n5;
        }
    }

    private static DigestMethod getDigestMethod(String string) throws EncryptionException {
        try {
            return DigestMethod.get(string);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new EncryptionException("DigestMethod: " + string + " not available");
        }
    }

    static byte[] i2osp(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)(n >>> 0)};
        return byArray;
    }
}

