/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import weblogic.xml.security.encryption.DataReference;
import weblogic.xml.security.encryption.KeyReference;
import weblogic.xml.security.encryption.XMLEncConstants;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class ReferenceList
implements XMLEncConstants {
    private List references = new LinkedList();

    public ReferenceList() {
    }

    public ReferenceList(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public void addReference(DataReference dataReference) {
        this.references.add(dataReference);
    }

    public void addReference(KeyReference keyReference) {
        this.references.add(keyReference);
    }

    public Iterator getReferences() {
        return this.references.iterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ReferenceList:\n");
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("  ").append(iterator.next()).append("\n");
        }
        return stringBuffer.toString();
    }

    static ReferenceList fromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        if (StreamUtils.peekElement(xMLInputStream, string, "ReferenceList")) {
            return new ReferenceList(xMLInputStream, string);
        }
        return null;
    }

    private void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        xMLInputStream.skip();
        XMLEncConstants xMLEncConstants = null;
        do {
            if ((xMLEncConstants = DataReference.fromXML(xMLInputStream, string)) == null) {
                xMLEncConstants = KeyReference.fromXML(xMLInputStream, string);
            }
            if (xMLEncConstants == null) continue;
            this.references.add(xMLEncConstants);
        } while (xMLEncConstants != null);
        StreamUtils.closeScope(xMLInputStream, string, "ReferenceList");
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        StreamUtils.addStart(xMLOutputStream, string, "ReferenceList", n);
        for (Object e : this.references) {
            if (e instanceof DataReference) {
                ((DataReference)e).toXML(xMLOutputStream, string, n + 2);
                continue;
            }
            ((KeyReference)e).toXML(xMLOutputStream, string, n + 2);
        }
        StreamUtils.addEnd(xMLOutputStream, string, "ReferenceList", n);
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<ReferenceList xmlns=\"http://www.w3.org/2001/04/xmlenc#\">\n  <DataReference URI=\"#ED1\"/>\n  <KeyReference URI=\"#EK1\"/>\n  <DataReference URI=\"#ED2\"/>\n</ReferenceList>\n ");
        ReferenceList referenceList = new ReferenceList(xMLInputStream, "http://www.w3.org/2001/04/xmlenc#");
        System.out.println(referenceList);
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        referenceList.toXML(xMLOutputStream, "http://www.w3.org/2001/04/xmlenc#", 0);
        xMLOutputStream.flush();
    }
}

