/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import weblogic.xml.security.encryption.EncryptionException;

public class Utils
extends weblogic.xml.security.utils.Utils {
    private static final int DES_KEYLENGTH = 7;
    private static final int TRIPLEDES_KEYLENGTH = 21;
    private static final String ALGORITHM_ID_SHA1 = "HmacSHA1";
    private static final String KEY_FACTORY_ID = "AES";

    static byte[] stripLeadingZeros(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length && byArray[n] == 0; ++n) {
        }
        if (n > 0) {
            byte[] byArray2 = new byte[byArray.length - n];
            System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public static boolean readIV(InputStream inputStream, byte[] byArray) throws EncryptionException {
        int n = 0;
        for (int i = 0; i < byArray.length; i += n) {
            try {
                n = inputStream.read(byArray, i, byArray.length - i);
            }
            catch (IOException iOException) {
                n = -1;
            }
            if (n != -1) continue;
            throw new EncryptionException("Could not read IV");
        }
        return true;
    }

    public static void writeIV(OutputStream outputStream, byte[] byArray) throws EncryptionException {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new EncryptionException("Could not write IV", iOException);
        }
    }

    public static byte[] P_SHA1(byte[] byArray, byte[] byArray2, int n) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(ALGORITHM_ID_SHA1);
        byte[] byArray3 = new byte[n];
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, KEY_FACTORY_ID);
        byte[] byArray4 = byArray2;
        int n2 = 0;
        do {
            mac.init(secretKeySpec);
            byArray4 = mac.doFinal(byArray4);
            mac.reset();
            mac.init(secretKeySpec);
            mac.update(byArray4);
            byte[] byArray5 = mac.doFinal(byArray2);
            mac.reset();
            for (int i = 0; n2 < n && i < byArray5.length; ++n2, ++i) {
                byArray3[n2] = byArray5[i];
            }
        } while (n2 < n);
        return byArray3;
    }

    public static byte[] DESParity(byte[] byArray, byte[] byArray2) {
        int n;
        byte[] byArray3;
        if (byArray.length != 7) {
            throw new IllegalArgumentException("key must be 56 bits");
        }
        if (byArray2 != null && byArray2.length == 8) {
            byArray3 = byArray2;
            for (n = 0; n < 8; ++n) {
                byArray3[n] = 0;
            }
        } else {
            byArray3 = new byte[8];
        }
        n = 0;
        for (int i = 7; i >= 0; --i) {
            boolean bl = true;
            int n2 = 1;
            while (n2 < 8) {
                boolean bl2;
                boolean bl3 = bl2 = (byArray[6 - n / 8] & 1 << n % 8) > 0;
                if (bl2) {
                    int n3 = i;
                    byArray3[n3] = (byte)(byArray3[n3] | 1 << n2);
                    bl = !bl;
                }
                ++n2;
                ++n;
            }
            if (!bl) continue;
            int n4 = i;
            byArray3[n4] = (byte)(byArray3[n4] | 1);
        }
        return byArray3;
    }

    public static byte[] tripleDESParity(byte[] byArray) {
        if (byArray.length != 21) {
            throw new IllegalArgumentException("key must be 168 bits");
        }
        byte[] byArray2 = new byte[24];
        byte[] byArray3 = new byte[7];
        byte[] byArray4 = new byte[8];
        for (int i = 0; i < 3; ++i) {
            int n;
            for (n = 0; n < 7; ++n) {
                byArray3[n] = byArray[i * 7 + n];
            }
            byArray4 = Utils.DESParity(byArray3, byArray4);
            for (n = 0; n < 8; ++n) {
                byArray2[n + i * 8] = byArray4[n];
            }
        }
        return byArray2;
    }
}

