/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.encryption;

import weblogic.xml.security.encryption.EncryptedData;
import weblogic.xml.security.encryption.EncryptedKey;
import weblogic.xml.security.encryption.EncryptionMethod;
import weblogic.xml.security.encryption.ReferenceList;
import weblogic.xml.security.encryption.XMLEncConstants;
import weblogic.xml.security.utils.XMLObjectReader;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public class XMLEncReader
extends XMLObjectReader
implements XMLEncConstants {
    private static XMLEncReader singleton = new XMLEncReader();

    private XMLEncReader() {
        this.register("http://www.w3.org/2001/04/xmlenc#", "EncryptedData", 1);
        this.register("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey", 2);
        this.register("http://www.w3.org/2001/04/xmlenc#", "ReferenceList", 4);
        this.register("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod", 3);
    }

    public Object readObjectInternal(int n, String string, XMLInputStream xMLInputStream) throws XMLStreamException {
        switch (n) {
            case 1: {
                return new EncryptedData(xMLInputStream, string);
            }
            case 2: {
                return new EncryptedKey(xMLInputStream, string);
            }
            case 4: {
                return new ReferenceList(xMLInputStream, string);
            }
            case 3: {
                return EncryptionMethod.fromXML(xMLInputStream, string);
            }
        }
        throw new AssertionError((Object)("Unknown typecode: " + n));
    }

    public static Object read(XMLInputStream xMLInputStream) throws XMLStreamException {
        return singleton.readObject(xMLInputStream);
    }

    public static Object read(XMLInputStream xMLInputStream, int n) throws XMLStreamException {
        return singleton.readObject(xMLInputStream, n);
    }
}

