/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.keyinfo;

import java.math.BigInteger;
import weblogic.xml.security.keyinfo.KeyProvider;
import weblogic.xml.security.keyinfo.KeyPurpose;
import weblogic.xml.security.keyinfo.KeyResult;
import weblogic.xml.security.keyinfo.Utils;

public abstract class BaseKeyProvider
implements KeyProvider {
    private final byte[] identifier;
    private final String name;
    private final String uri;

    protected BaseKeyProvider(String string, byte[] byArray, String string2) {
        this.name = string;
        this.identifier = byArray;
        this.uri = string2;
    }

    public KeyResult getKeyByIdentifier(byte[] byArray, String string, KeyPurpose keyPurpose) {
        if (Utils.matches(byArray, this.identifier)) {
            return this.getKey(string, keyPurpose);
        }
        return null;
    }

    public KeyResult getKeyByName(String string, String string2, KeyPurpose keyPurpose) {
        if (string != null && string.equals(this.name)) {
            return this.getKey(string2, keyPurpose);
        }
        return null;
    }

    public KeyResult getKeyByURI(String string, String string2, KeyPurpose keyPurpose) {
        if (string != null && string.equals(this.uri)) {
            return this.getKey(string2, keyPurpose);
        }
        return null;
    }

    public KeyResult getKeyBySubjectName(String string, String string2, KeyPurpose keyPurpose) {
        return null;
    }

    public KeyResult getKeyByIssuerSerial(String string, BigInteger bigInteger, String string2, KeyPurpose keyPurpose) {
        return null;
    }

    public byte[] getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        return "weblogic.xml.security.keyinfo.BaseKeyProvider{identifier=" + (this.identifier == null ? null : "length:" + this.identifier.length) + ", name='" + this.name + "'" + ", uri='" + this.uri + "'" + "}";
    }
}

