/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.keyinfo;

import java.math.BigInteger;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import weblogic.xml.security.keyinfo.KeyPurpose;
import weblogic.xml.security.keyinfo.KeyResult;
import weblogic.xml.security.keyinfo.KeypairProvider;
import weblogic.xml.security.keyinfo.X509KeyResult;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.security.wsse.BinarySecurityToken;

public class CertificateKeyProvider
extends KeypairProvider {
    private final X509Certificate cert;

    public CertificateKeyProvider(X509Certificate x509Certificate, PrivateKey privateKey, String string, String string2) {
        super(x509Certificate.getPublicKey(), privateKey, string, Utils.getSubjectKeyIdentifier(x509Certificate), string2);
        this.cert = x509Certificate;
    }

    public CertificateKeyProvider(BinarySecurityToken binarySecurityToken, String string, String string2) {
        this(binarySecurityToken.getCertificate(), binarySecurityToken.getPrivateKey(), string, string2);
    }

    public KeyResult getKeyBySubjectName(String string, String string2, KeyPurpose keyPurpose) {
        if (string == null) {
            throw new IllegalArgumentException("SubjectName cannot be null");
        }
        Principal principal = this.cert.getSubjectDN();
        String string3 = principal.getName();
        if (string.equals(string3)) {
            return this.getKey(string2, keyPurpose);
        }
        return null;
    }

    public KeyResult getKeyByIssuerSerial(String string, BigInteger bigInteger, String string2, KeyPurpose keyPurpose) {
        if (string == null) {
            throw new IllegalArgumentException("IssuerName cannot be null");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("Serial number cannot be null");
        }
        Principal principal = this.cert.getIssuerDN();
        String string3 = principal.getName();
        if (!string.equals(string3)) {
            return null;
        }
        BigInteger bigInteger2 = this.cert.getSerialNumber();
        if (!bigInteger.equals(bigInteger2)) {
            return null;
        }
        return this.getKey(string2, keyPurpose);
    }

    protected KeyResult getResult(Key key) {
        return new X509KeyResult(key, this.cert);
    }
}

