/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.keyinfo;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import weblogic.xml.security.keyinfo.KeyInfoValidationException;
import weblogic.xml.security.keyinfo.KeyValue;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public final class DSAKeyValue
extends KeyValue
implements DSIGConstants {
    private static final String ALGORITHM_DSA = "DSA";
    private DSAPublicKey publicKey;
    private boolean validated = false;
    private String p;
    private String q;
    private String g;
    private String y;

    DSAKeyValue(DSAPublicKey dSAPublicKey) {
        this.publicKey = dSAPublicKey;
        this.validated = true;
    }

    DSAKeyValue(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public PublicKey getPublicKey() throws KeyInfoValidationException {
        if (!this.validated) {
            this.validate();
        }
        return this.publicKey;
    }

    private BigInteger getP() {
        return this.publicKey.getParams().getP();
    }

    private BigInteger getQ() {
        return this.publicKey.getParams().getQ();
    }

    private BigInteger getG() {
        return this.publicKey.getParams().getG();
    }

    private BigInteger getY() {
        return this.publicKey.getY();
    }

    public void validate() throws KeyInfoValidationException {
        if (this.validated) {
            return;
        }
        DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(Utils.fromCryptoBinary(this.y), Utils.fromCryptoBinary(this.p), Utils.fromCryptoBinary(this.q), Utils.fromCryptoBinary(this.g));
        this.publicKey = (DSAPublicKey)this.createFromKeySpec(ALGORITHM_DSA, dSAPublicKeySpec);
        this.validated = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DSAPublicKey:\n").append("P: ").append(this.getP()).append("\n").append("Q: ").append(this.getQ()).append("\n").append("G: ").append(this.getG()).append("\n").append("Y: ").append(this.getY()).append("\n");
        return stringBuffer.toString();
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        this.p = Utils.toCryptoBinary(this.getP());
        this.q = Utils.toCryptoBinary(this.getQ());
        this.g = Utils.toCryptoBinary(this.getG());
        this.y = Utils.toCryptoBinary(this.getY());
        StreamUtils.addStart(xMLOutputStream, string, "DSAKeyValue", n);
        if (this.p != null) {
            StreamUtils.addElement(xMLOutputStream, string, "P", this.p, n + 2, 2);
            StreamUtils.addElement(xMLOutputStream, string, "Q", this.q, n + 2, 2);
        }
        if (this.g != null) {
            StreamUtils.addElement(xMLOutputStream, string, "G", this.g, n + 2, 2);
        }
        if (this.y != null) {
            StreamUtils.addElement(xMLOutputStream, string, "Y", this.y, n + 2, 2);
        }
        StreamUtils.addEnd(xMLOutputStream, string, "DSAKeyValue", n);
    }

    private void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        xMLInputStream.next();
        this.p = StreamUtils.getValue(xMLInputStream, string, "P");
        if (this.p != null) {
            this.q = StreamUtils.getValue(xMLInputStream, string, "Q");
            StreamUtils.required(this.q, "DSAKeyValue", "Q");
        }
        this.g = StreamUtils.getValue(xMLInputStream, string, "G");
        this.y = StreamUtils.getValue(xMLInputStream, string, "Y");
        StreamUtils.required(this.y, "DSAKeyValue", "Y");
        StreamUtils.closeScope(xMLInputStream, string, "DSAKeyValue");
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<DSAKeyValue xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n  <P>\n    3eOeAvqnEyFpW+uTSgrdj7YLjaTkpyHecKFIoLu8QZNkGTQI1ciITBH0lqfIkdCH\n    Si8fiUC3DTq3J9FsJef4YVtDF7JpUvHTOQqtq7Zgx6KC8Wxkz6rQCxOr7F0ApOYi\n    89zLRoe4MkDGe6ux0+WtyOTQoVIGNTDDUFXrUQNbLrE=\n  </P>\n  <Q>\n    hDLcFK0GO/Hz1arxOOvsgM/VLyU=\n  </Q>\n  <G>\n    nnx7hbdWozGbtnFgnbFnopfRl7XRacpkPJRGf5P2IUgVspEUSUoN6i1fDBfBg43z\n    Kt7dlEaQL7b5+JTZt3MhZNPosxsgxVuT7Ts/g5k7EnpdYv0a5hw5Bw29fjbGHfgM\n    8d2rhd2Ui0xHbk0D451nhLxVWulviOSPhzKKvXrbySA=\n  </G>\n  <Y>\n    cfYpihpAQeepbNFS4MAbQRhdXpDi5wLrwxE5hIvoYqo1L8BQVu8fY1TFAPtoae1i\n    Bg/GIJyP3iLfyuBJaDvJJLP30wBH9i/s5J3656PevpOVdTfi777Fi9Gj6y/ib2Vv\n    +OZfJkkp4L50+p5TUhPmQLJtREsgtl+tnIOyJT++G9U=\n  </Y>\n</DSAKeyValue>\n");
        DSAKeyValue dSAKeyValue = new DSAKeyValue(xMLInputStream, "http://www.w3.org/2000/09/xmldsig#");
        dSAKeyValue.validate();
        System.out.println(dSAKeyValue);
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        dSAKeyValue.toXML(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#", 0);
        xMLOutputStream.flush();
    }
}

