/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.keyinfo;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.xml.security.encryption.EncryptedKey;
import weblogic.xml.security.encryption.XMLEncReader;
import weblogic.xml.security.keyinfo.KeyInfoException;
import weblogic.xml.security.keyinfo.KeyInfoValidationException;
import weblogic.xml.security.keyinfo.KeyValue;
import weblogic.xml.security.keyinfo.X509Data;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DSIGReader;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.security.wsse.SecurityTokenReference;
import weblogic.xml.security.wsse.Token;
import weblogic.xml.security.wsse.WSSEReader;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class KeyInfo
implements DSIGConstants {
    private List keyNames = new ArrayList();
    private List keyValues = new ArrayList();
    private List x509Data = new ArrayList();
    private List encryptedKeys = new ArrayList();
    private List tokenRefs = new ArrayList();
    private boolean validated = false;

    public KeyInfo(String string) {
        this.addKeyName(string);
    }

    public KeyInfo(X509Certificate x509Certificate) throws KeyInfoException {
        this.addKeyValue(KeyValue.getKeyValue(x509Certificate.getPublicKey()));
        X509Data x509Data = new X509Data(x509Certificate);
        this.addX509Data(x509Data);
        Iterator iterator = x509Data.getSubjectNames();
        while (iterator.hasNext()) {
            this.addKeyName((String)iterator.next());
        }
        this.validated = true;
    }

    public KeyInfo(Token token) {
        this.addSecurityTokenReference(token.getSecurityTokenReference());
        this.validated = true;
    }

    public KeyInfo(EncryptedKey encryptedKey) {
        this.addEncryptedKey(encryptedKey);
    }

    public KeyInfo(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public void addKeyName(String string) {
        this.keyNames.add(string);
    }

    public void removeKeyName(String string) {
        this.keyNames.remove(string);
    }

    public String getKeyName() {
        if (this.keyNames.size() == 0) {
            return null;
        }
        return (String)this.keyNames.get(0);
    }

    public Iterator getKeyNames() {
        return this.keyNames.iterator();
    }

    public void addKeyValue(KeyValue keyValue) {
        this.keyValues.add(keyValue);
    }

    public void removeKeyValue(KeyValue keyValue) {
        this.keyValues.remove(keyValue);
    }

    public Iterator getKeyValues() {
        return this.keyValues.iterator();
    }

    public void addX509Data(X509Data x509Data) {
        this.x509Data.add(x509Data);
    }

    public void removeX509Data(X509Data x509Data) {
        this.x509Data.remove(x509Data);
    }

    public Iterator getX509Data() {
        return this.x509Data.iterator();
    }

    public void addEncryptedKey(EncryptedKey encryptedKey) {
        this.encryptedKeys.add(encryptedKey);
    }

    public void removeEncryptedKey(EncryptedKey encryptedKey) {
        this.encryptedKeys.remove(encryptedKey);
    }

    public Iterator getEncryptedKeys() {
        return this.encryptedKeys.iterator();
    }

    public void addSecurityTokenReference(SecurityTokenReference securityTokenReference) {
        this.tokenRefs.add(securityTokenReference);
    }

    public void addSecurityTokenReference(Token token) {
        this.addSecurityTokenReference(token.getSecurityTokenReference());
    }

    public void removeSecurityTokenReference(SecurityTokenReference securityTokenReference) {
        this.tokenRefs.remove(securityTokenReference);
    }

    public Iterator getSecurityTokenReferences() {
        return this.tokenRefs.iterator();
    }

    public Iterator getSubjectNames() throws KeyInfoValidationException {
        if (!this.validated) {
            this.validate();
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getX509Data();
        while (iterator.hasNext()) {
            X509Data x509Data = (X509Data)iterator.next();
            Iterator iterator2 = x509Data.getSubjectNames();
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
        }
        return arrayList.iterator();
    }

    public Iterator getCertificates() throws KeyInfoValidationException {
        if (!this.validated) {
            this.validate();
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getX509Data();
        while (iterator.hasNext()) {
            X509Data x509Data = (X509Data)iterator.next();
            Iterator iterator2 = x509Data.getCertificates();
            while (iterator2.hasNext()) {
                arrayList.add(iterator2.next());
            }
        }
        return arrayList.iterator();
    }

    public Iterator getPublicKeys() throws KeyInfoValidationException {
        if (!this.validated) {
            this.validate();
        }
        ArrayList<PublicKey> arrayList = new ArrayList<PublicKey>();
        Iterator iterator = this.getKeyValues();
        while (iterator.hasNext()) {
            KeyValue keyValue = (KeyValue)iterator.next();
            arrayList.add(keyValue.getPublicKey());
        }
        return arrayList.iterator();
    }

    public void validate() throws KeyInfoValidationException {
        for (DSIGConstants dSIGConstants : this.keyValues) {
            ((KeyValue)dSIGConstants).validate();
        }
        for (DSIGConstants dSIGConstants : this.x509Data) {
            ((X509Data)dSIGConstants).validate();
        }
        this.validated = true;
    }

    public void toXML(XMLOutputStream xMLOutputStream, int n) throws XMLStreamException {
        this.toXML(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#", n);
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        StreamUtils.addStart(xMLOutputStream, string, "KeyInfo", n);
        int n2 = n + 2;
        if (this.keyNames.size() > 0) {
            Iterator iterator = this.keyNames.iterator();
            while (iterator.hasNext()) {
                StreamUtils.addElement(xMLOutputStream, string, "KeyName", (String)iterator.next(), n2);
            }
        }
        if (this.keyValues.size() > 0) {
            for (Object object : this.keyValues) {
                StreamUtils.addStart(xMLOutputStream, string, "KeyValue", n2);
                ((KeyValue)object).toXML(xMLOutputStream, string, n2 + 2);
                StreamUtils.addEnd(xMLOutputStream, string, "KeyValue", n2);
            }
        }
        if (this.x509Data.size() > 0) {
            for (Object object : this.x509Data) {
                ((X509Data)object).toXML(xMLOutputStream, string, n2);
            }
        }
        if (this.encryptedKeys.size() > 0) {
            for (Object object : this.encryptedKeys) {
                ((EncryptedKey)object).toXML(xMLOutputStream, n2);
            }
        }
        if (!this.tokenRefs.isEmpty()) {
            for (Object object : this.tokenRefs) {
                object.toXML(xMLOutputStream);
            }
        }
        StreamUtils.addEnd(xMLOutputStream, string, "KeyInfo", n);
    }

    private void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        xMLInputStream.next();
        while (!xMLInputStream.peek().isEndElement()) {
            String string2 = StreamUtils.getValue(xMLInputStream, string, "KeyName");
            if (string2 != null) {
                this.addKeyName(string2);
                continue;
            }
            KeyValue keyValue = (KeyValue)DSIGReader.read(xMLInputStream, 5);
            if (keyValue != null) {
                this.addKeyValue(keyValue);
                continue;
            }
            X509Data x509Data = (X509Data)DSIGReader.read(xMLInputStream, 11);
            if (x509Data != null) {
                this.addX509Data(x509Data);
                continue;
            }
            EncryptedKey encryptedKey = (EncryptedKey)XMLEncReader.read(xMLInputStream, 2);
            if (encryptedKey != null) {
                this.addEncryptedKey(encryptedKey);
                continue;
            }
            SecurityTokenReference securityTokenReference = (SecurityTokenReference)WSSEReader.read(xMLInputStream, 5);
            if (securityTokenReference != null) {
                this.addSecurityTokenReference(securityTokenReference);
                continue;
            }
            if (xMLInputStream.peek().isEndElement()) break;
            if (xMLInputStream.peek().isStartElement()) {
                xMLInputStream.skipElement();
                continue;
            }
            xMLInputStream.skip();
        }
        StreamUtils.closeScope(xMLInputStream, string, "KeyInfo");
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n  <KeyName>Carol</KeyName>\n  <KeyValue>\n    <DSAKeyValue>\n      <P>\n        3eOeAvqnEyFpW+uTSgrdj7YLjaTkpyHecKFIoLu8QZNkGTQI1ciITBH0lqfIkdCH\n        Si8fiUC3DTq3J9FsJef4YVtDF7JpUvHTOQqtq7Zgx6KC8Wxkz6rQCxOr7F0ApOYi\n        89zLRoe4MkDGe6ux0+WtyOTQoVIGNTDDUFXrUQNbLrE=\n      </P>\n      <Q>\n        hDLcFK0GO/Hz1arxOOvsgM/VLyU=\n      </Q>\n      <G>\n        nnx7hbdWozGbtnFgnbFnopfRl7XRacpkPJRGf5P2IUgVspEUSUoN6i1fDBfBg43z\n        Kt7dlEaQL7b5+JTZt3MhZNPosxsgxVuT7Ts/g5k7EnpdYv0a5hw5Bw29fjbGHfgM\n        8d2rhd2Ui0xHbk0D451nhLxVWulviOSPhzKKvXrbySA=\n      </G>\n      <Y>\n        cfYpihpAQeepbNFS4MAbQRhdXpDi5wLrwxE5hIvoYqo1L8BQVu8fY1TFAPtoae1i\n        Bg/GIJyP3iLfyuBJaDvJJLP30wBH9i/s5J3656PevpOVdTfi777Fi9Gj6y/ib2Vv\n        +OZfJkkp4L50+p5TUhPmQLJtREsgtl+tnIOyJT++G9U=\n      </Y>\n    </DSAKeyValue>\n  </KeyValue>\n  <X509Data>\n    <X509Certificate>\nMIIDUDCCAxCgAwIBAgIGAOz5IVHTMAkGByqGSM44BAMwdjELMAkGA1UEBhMCSUUx\nDzANBgNVBAgTBkR1YmxpbjEkMCIGA1UEChMbQmFsdGltb3JlIFRlY2hub2xvZ2ll\ncyBMdGQuMREwDwYDVQQLEwhYL1NlY3VyZTEdMBsGA1UEAxMUQW5vdGhlciBUcmFu\nc2llbnQgQ0EwHhcNMDIwNDAyMjM1OTUyWhcNMTIwNDAyMjI1OTQ2WjBoMQswCQYD\nVQQGEwJJRTEPMA0GA1UECBMGRHVibGluMSQwIgYDVQQKExtCYWx0aW1vcmUgVGVj\naG5vbG9naWVzIEx0ZC4xETAPBgNVBAsTCFgvU2VjdXJlMQ8wDQYDVQQDEwZNb3Jp\nZ3UwggG2MIIBKwYHKoZIzjgEATCCAR4CgYEAhIqwSieM0aAez+6H71gqCfBnwG3d\nPu7JAElb13GkwXRw9RfPh0VtIVjhDJbyKAIuzCk5r54ccRixa8TQ2vWVwodQ9eru\n7jUknAc2rVEAV5mJTrBr7UUve/X9PWsCDN6lXvFLiJp/Pi/F0cyV/CAp+jIp+rol\nTXOhUz9qEjnFYMMCFQCYS/p4gmsHgo3R89EAE/Hc0dhyWQKBgCWG5hn8DM+1rv5s\nTkJBqyZJXNzy4z974s3sAGURfBBGTpB9kFxfxNt480TxkWeDhR+39DMA5TEAsRPu\nQoB6Tgl7K2nNzRdgJjK4YkBObgX1ljWkAnnJCZSbC8Nh2VpkniV0bM79HnsS+eCf\n8bi2qOOiLSzHeOrtzO8PB0YeeTLQA4GEAAKBgH1NBJ9Az5TwY4tDE0dPYVHHABt+\nyLspnT3k9G6YWUMFhZ/+3RuqEPjnKrPfUoXTTJGIACgPU3/PkqwrPVD0JMdpOcnZ\nLHiJ/P7QRQeMwDRoBrs7genB1bDd4pSJrEUcjrkA5uRrIj2Z5fL+UuLiLGPO2rM7\nBNQRIq3QFPdX++NuozowODAOBgNVHQ8BAf8EBAMCB4AwEQYDVR0OBAoECIK7Ljjh\n+EsfMBMGA1UdIwQMMAqACIocVjBaMhJ9MAkGByqGSM44BAMDLwAwLAIUEJJCOHw8\nppxoRyz3s+Vmb4NKIfMCFDgJoZn9zh/3WoYNBURODwLvyBOy\n    </X509Certificate>\n  </X509Data>\n  <wsse:SecurityTokenReference xmlns:wsse=\"" + WSSEConstants.WSSE_URI + "\"\n" + "      Id=\"STR\">\n" + "    <wsse:Reference URI=\"#bingo\" />\n" + "  </wsse:SecurityTokenReference>" + "</KeyInfo>\n");
        KeyInfo keyInfo = (KeyInfo)DSIGReader.read(xMLInputStream, 4);
        keyInfo.validate();
        System.out.println(keyInfo);
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        keyInfo.toXML(xMLOutputStream, 0);
        xMLOutputStream.flush();
    }

    public String toString() {
        return "weblogic.xml.security.keyinfo.KeyInfo{keyNames=" + (this.keyNames == null ? null : "size:" + this.keyNames.size() + this.keyNames) + ", keyValues=" + (this.keyValues == null ? null : "size:" + this.keyValues.size() + this.keyValues) + ", x509Data=" + (this.x509Data == null ? null : "size:" + this.x509Data.size() + this.x509Data) + ", encryptedKeys=" + (this.encryptedKeys == null ? null : "size:" + this.encryptedKeys.size() + this.encryptedKeys) + ", tokenRefs=" + (this.tokenRefs == null ? null : "size:" + this.tokenRefs.size() + this.tokenRefs) + "}";
    }
}

