/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.keyinfo;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import weblogic.xml.security.keyinfo.CertificateKeyProvider;
import weblogic.xml.security.keyinfo.KeyProvider;
import weblogic.xml.security.keyinfo.KeypairProvider;
import weblogic.xml.security.wsse.BinarySecurityToken;
import weblogic.xml.security.wsse.Token;

public class KeyProviderFactory {
    public static KeyProvider create(PrivateKey privateKey) {
        return new KeypairProvider(null, privateKey, null, null, null);
    }

    public static KeyProvider create(BinarySecurityToken binarySecurityToken) {
        return new CertificateKeyProvider(binarySecurityToken.getCertificate(), binarySecurityToken.getPrivateKey(), null, KeyProviderFactory.getURI(binarySecurityToken));
    }

    public static KeyProvider create(X509Certificate x509Certificate, PrivateKey privateKey) {
        KeyProvider keyProvider = x509Certificate == null ? KeyProviderFactory.create(privateKey) : new CertificateKeyProvider(x509Certificate, privateKey, null, null);
        return keyProvider;
    }

    private static String getURI(Token token) {
        String string = token.getId();
        String string2 = string != null ? "#" + token.getId() : null;
        return string2;
    }
}

