/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.keyinfo;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class KeyPurpose {
    private final String description;
    public static final KeyPurpose SIGN = new KeyPurpose("signing");
    public static final KeyPurpose VERIFY = new KeyPurpose("verifying");
    public static final KeyPurpose ENCRYPT = new KeyPurpose("encryption");
    public static final KeyPurpose DECRYPT = new KeyPurpose("decryption");
    public static final KeyPurpose[] ALL_PURPOSES = new KeyPurpose[]{SIGN, VERIFY, ENCRYPT, DECRYPT};
    public static final KeyPurpose[] PRIVATE_KEY_PURPOSES = new KeyPurpose[]{SIGN, DECRYPT};
    public static final KeyPurpose[] PUBLIC_KEY_PURPOSES = new KeyPurpose[]{VERIFY, ENCRYPT};
    public static final KeyPurpose[] DSA_PRIVATE_KEY_PURPOSES = new KeyPurpose[]{SIGN};
    public static final KeyPurpose[] DSA_PUBLIC_KEY_PURPOSES = new KeyPurpose[]{VERIFY};

    private KeyPurpose(String string) {
        this.description = string;
    }

    public String toString() {
        return this.description;
    }

    public boolean served(KeyPurpose[] keyPurposeArray) {
        if (keyPurposeArray == ALL_PURPOSES) {
            return true;
        }
        for (int i = 0; i < keyPurposeArray.length; ++i) {
            KeyPurpose keyPurpose = keyPurposeArray[i];
            if (this != keyPurpose) continue;
            return true;
        }
        return false;
    }

    protected static final boolean serves(KeyPurpose[] keyPurposeArray, KeyPurpose keyPurpose) {
        return keyPurpose.served(keyPurposeArray);
    }

    public static final KeyPurpose[] getPurposes(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Provided null, expected key");
        }
        if (key instanceof PublicKey) {
            return "DSA".equals(key.getAlgorithm()) ? DSA_PUBLIC_KEY_PURPOSES : PUBLIC_KEY_PURPOSES;
        }
        if (key instanceof PrivateKey) {
            return "DSA".equals(key.getAlgorithm()) ? DSA_PRIVATE_KEY_PURPOSES : PRIVATE_KEY_PURPOSES;
        }
        return ALL_PURPOSES;
    }
}

