/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.keyinfo;

import java.io.Serializable;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.xml.security.keyinfo.KeyInfo;
import weblogic.xml.security.keyinfo.KeyInfoValidationException;
import weblogic.xml.security.keyinfo.KeyProvider;
import weblogic.xml.security.keyinfo.KeyPurpose;
import weblogic.xml.security.keyinfo.KeyResolverException;
import weblogic.xml.security.keyinfo.KeyResult;
import weblogic.xml.security.keyinfo.Utils;
import weblogic.xml.security.keyinfo.X509Data;
import weblogic.xml.security.keyinfo.X509IssuerSerial;
import weblogic.xml.security.keyinfo.X509KeyResult;
import weblogic.xml.security.wsse.KeyIdentifier;
import weblogic.xml.security.wsse.SecurityTokenReference;

public class KeyResolver {
    private final List keyProviders;
    protected static Accessor BY_ALG_AND_PURPOSE = new Accessor(){

        public KeyResult getKey(Object object, String string, KeyPurpose keyPurpose, KeyProvider keyProvider) {
            return keyProvider.getKey(string, keyPurpose);
        }
    };
    protected static Accessor BY_TOKEN_REFERENCE = new Accessor(){

        public KeyResult getKey(Object object, String string, KeyPurpose keyPurpose, KeyProvider keyProvider) {
            Object object2;
            SecurityTokenReference securityTokenReference = (SecurityTokenReference)object;
            KeyResult keyResult = null;
            KeyIdentifier keyIdentifier = securityTokenReference.getKeyIdentifier();
            if (keyIdentifier != null) {
                keyResult = keyProvider.getKeyByIdentifier(keyIdentifier.getIdentifier(), string, keyPurpose);
            } else {
                object2 = securityTokenReference.getX509IssuerSerial();
                if (object2 != null) {
                    keyResult = keyProvider.getKeyByIssuerSerial(((X509IssuerSerial)object2).getIssuerName(), ((X509IssuerSerial)object2).getIssuerSerialNumber(), string, keyPurpose);
                }
            }
            if (keyResult != null) {
                return keyResult;
            }
            object2 = securityTokenReference.getReference();
            return keyProvider.getKeyByURI((String)object2, string, keyPurpose);
        }
    };
    protected static Accessor BY_X509_DATA = new Accessor(){

        public KeyResult getKey(Object object, String string, KeyPurpose keyPurpose, KeyProvider keyProvider) {
            Object object2;
            X509Data x509Data = (X509Data)object;
            Iterator iterator = x509Data.getSubjectNames();
            KeyResult keyResult = null;
            while (iterator.hasNext() && keyResult == null) {
                object2 = (String)iterator.next();
                keyResult = keyProvider.getKeyBySubjectName((String)object2, string, keyPurpose);
            }
            if (keyResult == null) {
                object2 = x509Data.getIssuerSerials();
                while (object2.hasNext() && keyResult == null) {
                    X509IssuerSerial x509IssuerSerial = (X509IssuerSerial)object2.next();
                    keyResult = keyProvider.getKeyByIssuerSerial(x509IssuerSerial.getIssuerName(), x509IssuerSerial.getIssuerSerialNumber(), string, keyPurpose);
                }
            }
            return keyResult;
        }
    };
    protected static Accessor BY_KEY_NAME = new Accessor(){

        public KeyResult getKey(Object object, String string, KeyPurpose keyPurpose, KeyProvider keyProvider) {
            String string2 = (String)object;
            return keyProvider.getKeyByName(string2, string, keyPurpose);
        }
    };

    private KeyResolver(List list) {
        this.keyProviders = list;
    }

    public KeyResolver() {
        this(new ArrayList());
    }

    public KeyResolver(KeyProvider[] keyProviderArray) {
        this(new ArrayList());
        for (int i = 0; i < keyProviderArray.length; ++i) {
            KeyProvider keyProvider = keyProviderArray[i];
            this.keyProviders.add(keyProvider);
        }
    }

    public KeyResolver copy() {
        ArrayList arrayList = new ArrayList(this.keyProviders);
        return new KeyResolver(arrayList);
    }

    public void addKeyProvider(KeyProvider keyProvider) {
        if (keyProvider == null) {
            throw new IllegalArgumentException("Provider cannot be null");
        }
        this.keyProviders.add(keyProvider);
    }

    public boolean removeKeyProvider(KeyProvider keyProvider) {
        return this.keyProviders.remove(keyProvider);
    }

    public KeyProvider[] getKeyProviders() {
        KeyProvider[] keyProviderArray = new KeyProvider[this.keyProviders.size()];
        this.keyProviders.toArray(keyProviderArray);
        return keyProviderArray;
    }

    public KeyResult resolveKey(KeyPurpose keyPurpose, String string, KeyInfo keyInfo) throws KeyResolverException {
        KeyResult keyResult = null;
        KeyProvider[] keyProviderArray = this.getKeyProviders();
        if (keyInfo != null) {
            Iterator iterator = keyInfo.getSecurityTokenReferences();
            keyResult = this.getKey(iterator, BY_TOKEN_REFERENCE, string, keyPurpose, keyProviderArray);
            if (keyResult != null) {
                return keyResult;
            }
            iterator = keyInfo.getKeyNames();
            keyResult = this.getKey(iterator, BY_KEY_NAME, string, keyPurpose, keyProviderArray);
            if (keyResult != null) {
                return keyResult;
            }
            iterator = keyInfo.getX509Data();
            keyResult = this.getKey(iterator, BY_X509_DATA, string, keyPurpose, keyProviderArray);
            if (keyResult != null) {
                return keyResult;
            }
            try {
                Serializable serializable;
                iterator = keyInfo.getCertificates();
                while (iterator.hasNext()) {
                    serializable = (X509Certificate)iterator.next();
                    PublicKey publicKey = serializable.getPublicKey();
                    if (!KeyPurpose.serves(KeyPurpose.getPurposes(publicKey), keyPurpose) || !Utils.supports(Utils.getAlgorithms(publicKey), string)) continue;
                    return new X509KeyResult(publicKey, (X509Certificate)serializable);
                }
                iterator = keyInfo.getPublicKeys();
                while (iterator.hasNext()) {
                    serializable = (PublicKey)iterator.next();
                    if (!KeyPurpose.serves(KeyPurpose.getPurposes((Key)serializable), keyPurpose) || !Utils.supports(Utils.getAlgorithms((Key)serializable), string)) continue;
                    return new KeyResult((Key)serializable);
                }
            }
            catch (KeyInfoValidationException keyInfoValidationException) {
                throw new KeyResolverException("Unable to resolveKey key", keyInfoValidationException, keyInfo);
            }
        }
        if ((keyResult = this.getKey((Object)null, BY_ALG_AND_PURPOSE, string, keyPurpose, keyProviderArray)) != null) {
            return keyResult;
        }
        throw new KeyResolverException("Failed to resolve key from providers " + this.providersToString(), keyInfo);
    }

    private String providersToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (KeyProvider keyProvider : this.keyProviders) {
            stringBuffer.append(keyProvider).append(" ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private KeyResult getKey(Iterator iterator, Accessor accessor, String string, KeyPurpose keyPurpose, KeyProvider[] keyProviderArray) {
        KeyResult keyResult = null;
        while (iterator.hasNext() && keyResult == null) {
            Object e = iterator.next();
            keyResult = this.getKey(e, accessor, string, keyPurpose, keyProviderArray);
        }
        return keyResult;
    }

    private KeyResult getKey(Object object, Accessor accessor, String string, KeyPurpose keyPurpose, KeyProvider[] keyProviderArray) {
        KeyResult keyResult = null;
        for (int i = 0; keyResult == null && i < keyProviderArray.length; ++i) {
            KeyProvider keyProvider = keyProviderArray[i];
            keyResult = accessor.getKey(object, string, keyPurpose, keyProvider);
        }
        return keyResult;
    }

    protected static interface Accessor {
        public KeyResult getKey(Object var1, String var2, KeyPurpose var3, KeyProvider var4);
    }
}

