/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.keyinfo;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import weblogic.xml.security.keyinfo.DSAKeyValue;
import weblogic.xml.security.keyinfo.KeyInfoException;
import weblogic.xml.security.keyinfo.KeyInfoValidationException;
import weblogic.xml.security.keyinfo.RSAKeyValue;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class KeyValue
implements DSIGConstants {
    public static KeyValue getKeyValue(PublicKey publicKey) throws KeyInfoException {
        if (publicKey instanceof DSAPublicKey) {
            return new DSAKeyValue((DSAPublicKey)publicKey);
        }
        if (publicKey instanceof RSAPublicKey) {
            return new RSAKeyValue((RSAPublicKey)publicKey);
        }
        throw new KeyInfoException("Unknown PublicKey type: " + publicKey);
    }

    protected PublicKey createFromKeySpec(String string, KeySpec keySpec) throws KeyInfoValidationException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string2 = string + " KeyFactory implementation not registered";
            throw new KeyInfoValidationException(string2, noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            String string3 = "Invalid DSA key parameters";
            throw new KeyInfoValidationException(string3, invalidKeySpecException);
        }
    }

    public abstract PublicKey getPublicKey() throws KeyInfoValidationException;

    public abstract void validate() throws KeyInfoValidationException;

    public abstract void toXML(XMLOutputStream var1, String var2, int var3) throws XMLStreamException;

    public static KeyValue fromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        KeyValue keyValue = null;
        if (StreamUtils.getElement(xMLInputStream, string, "KeyValue") != null) {
            if (StreamUtils.peekElement(xMLInputStream, string, "DSAKeyValue")) {
                keyValue = new DSAKeyValue(xMLInputStream, string);
            } else if (StreamUtils.peekElement(xMLInputStream, string, "RSAKeyValue")) {
                keyValue = new RSAKeyValue(xMLInputStream, string);
            }
            StreamUtils.closeScope(xMLInputStream, string, "KeyValue");
        }
        return keyValue;
    }
}

