/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.keyinfo;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import weblogic.xml.security.keyinfo.BaseKeyProvider;
import weblogic.xml.security.keyinfo.KeyPurpose;
import weblogic.xml.security.keyinfo.KeyResult;
import weblogic.xml.security.keyinfo.Utils;

public class KeypairProvider
extends BaseKeyProvider {
    private final String[] algs;
    private final PublicKey pubKey;
    private final PrivateKey privKey;

    public KeypairProvider(PublicKey publicKey, PrivateKey privateKey, String string, byte[] byArray, String string2) {
        super(string, byArray, string2);
        if (publicKey == null && privateKey == null) {
            throw new IllegalArgumentException("Received null for public key and private key");
        }
        this.pubKey = publicKey;
        this.privKey = privateKey;
        this.algs = publicKey != null ? Utils.getAlgorithms(publicKey) : Utils.getAlgorithms(privateKey);
    }

    protected KeyResult getResult(Key key) {
        return new KeyResult(key);
    }

    public KeyResult getKey(String string, KeyPurpose keyPurpose) {
        if (Utils.supports(this.algs, string)) {
            if (this.pubKey != null && keyPurpose.served(KeyPurpose.getPurposes(this.pubKey))) {
                return this.getResult(this.pubKey);
            }
            if (this.privKey != null && keyPurpose.served(KeyPurpose.getPurposes(this.privKey))) {
                return this.getResult(this.privKey);
            }
        }
        return null;
    }
}

