/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.keyinfo;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import weblogic.xml.security.keyinfo.KeyInfoValidationException;
import weblogic.xml.security.keyinfo.KeyValue;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class RSAKeyValue
extends KeyValue
implements DSIGConstants {
    private static final String ALGORITHM_RSA = "RSA";
    private RSAPublicKey publicKey;
    private boolean validated = false;
    private String modulus;
    private String exponent;

    public RSAKeyValue(RSAPublicKey rSAPublicKey) {
        this.publicKey = rSAPublicKey;
        this.validated = true;
    }

    public RSAKeyValue(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public PublicKey getPublicKey() throws KeyInfoValidationException {
        if (!this.validated) {
            this.validate();
        }
        return this.publicKey;
    }

    private BigInteger getModulus() {
        return this.publicKey.getModulus();
    }

    private BigInteger getPublicExponent() {
        return this.publicKey.getPublicExponent();
    }

    public void validate() throws KeyInfoValidationException {
        if (this.validated) {
            return;
        }
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(Utils.fromCryptoBinary(this.modulus), Utils.fromCryptoBinary(this.exponent));
        this.publicKey = (RSAPublicKey)this.createFromKeySpec(ALGORITHM_RSA, rSAPublicKeySpec);
        this.validated = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RSAPublicKey:\n").append("  Modulus: " + this.getModulus()).append("\n").append("  Exponent: " + this.getPublicExponent()).append("\n");
        return stringBuffer.toString();
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        this.modulus = Utils.toCryptoBinary(this.getModulus());
        this.exponent = Utils.toCryptoBinary(this.getPublicExponent());
        StreamUtils.addStart(xMLOutputStream, string, "RSAKeyValue", n);
        StreamUtils.addElement(xMLOutputStream, string, "Modulus", this.modulus, n + 2, 2);
        StreamUtils.addElement(xMLOutputStream, string, "Exponent", this.exponent, n + 2);
        StreamUtils.addEnd(xMLOutputStream, string, "RSAKeyValue", n);
    }

    public void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        xMLInputStream.next();
        this.modulus = StreamUtils.getValue(xMLInputStream, string, "Modulus");
        StreamUtils.required(this.modulus, "RSAKeyValue", "Modulus");
        this.exponent = StreamUtils.getValue(xMLInputStream, string, "Exponent");
        StreamUtils.required(this.exponent, "RSAKeyValue", "Exponent");
        StreamUtils.closeScope(xMLInputStream, string, "RSAKeyValue");
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<RSAKeyValue xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n  <Modulus>\nq07hpxA5DGFfvJFZueFl/LI85XxQxrvqgVugL25V090A9MrlLBg5PmAsxFTe+G6axvWJQwYOVHj/nuiCnNLa9a7uAtPFiTtW+v5H3wlLaY3ws4atRBNOQlYkIBp38sTfQBkk4i8PEU1GQ2M0CLIJq4/2Akfv1wxzSQ9+8oWkArc=\n  </Modulus>\n  <Exponent>\n    AQAB\n  </Exponent>\n</RSAKeyValue>\n");
        RSAKeyValue rSAKeyValue = new RSAKeyValue(xMLInputStream, "http://www.w3.org/2000/09/xmldsig#");
        rSAKeyValue.validate();
        System.out.println(rSAKeyValue);
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        rSAKeyValue.toXML(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#", 0);
        xMLOutputStream.flush();
    }
}

