/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.keyinfo;

import java.security.Key;
import weblogic.xml.security.keyinfo.KeyProvider;

public class Utils {
    public static final boolean supports(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static final String[] getAlgorithms(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Provided null, expected key");
        }
        String string = key.getAlgorithm();
        if ("DESede".equals(string)) {
            return KeyProvider.TRIPLEDES_ALGORITHMS;
        }
        if ("AES".equals(string)) {
            return KeyProvider.AES_ALGORITHMS;
        }
        if ("RSA".equals(string)) {
            return KeyProvider.RSA_ALGORITHMS;
        }
        if ("DSA".equals(string)) {
            return KeyProvider.DSA_ALGORITHMS;
        }
        throw new IllegalArgumentException("Unsupported algorithm: " + string);
    }

    public static boolean matches(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            byte by2 = byArray2[i];
            if (by == by2) continue;
            return false;
        }
        return true;
    }
}

