/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.keyinfo;

import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.xml.security.keyinfo.KeyInfoValidationException;
import weblogic.xml.security.keyinfo.X509IssuerSerial;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DSIGReader;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class X509Data
implements DSIGConstants {
    private List issuerSerials = new ArrayList();
    private List subjectNames = new ArrayList();
    private List certs = new ArrayList();
    private List certificateBase64s = new ArrayList();
    private boolean validated = false;

    public X509Data(X509Certificate x509Certificate) {
        this.addCertificate(x509Certificate);
        this.addSubjectName(x509Certificate.getSubjectX500Principal().getName("RFC2253"));
        this.addIssuerSerial(new X509IssuerSerial(x509Certificate.getIssuerX500Principal().getName("RFC2253"), x509Certificate.getSerialNumber()));
        this.validated = true;
    }

    public X509Data(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public void addIssuerSerial(X509IssuerSerial x509IssuerSerial) {
        this.issuerSerials.add(x509IssuerSerial);
    }

    public void removeIssuerSerial(X509IssuerSerial x509IssuerSerial) {
        this.issuerSerials.remove(x509IssuerSerial);
    }

    public Iterator getIssuerSerials() {
        return this.issuerSerials.iterator();
    }

    public void addSubjectName(String string) {
        this.subjectNames.add(string);
    }

    public void removeSubjectName(String string) {
        this.subjectNames.remove(string);
    }

    public Iterator getSubjectNames() {
        return this.subjectNames.iterator();
    }

    public void addCertificate(X509Certificate x509Certificate) {
        this.certs.add(x509Certificate);
    }

    public void removeCertificate(X509Certificate x509Certificate) {
        this.certs.remove(x509Certificate);
    }

    public Iterator getCertificates() throws KeyInfoValidationException {
        this.validate();
        return this.certs.iterator();
    }

    private String getCertificateBase64(X509Certificate x509Certificate) {
        byte[] byArray;
        try {
            byArray = x509Certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AssertionError((Object)certificateEncodingException);
        }
        return Utils.base64(byArray);
    }

    public void validate() throws KeyInfoValidationException {
        if (this.validated) {
            return;
        }
        for (String string : this.certificateBase64s) {
            this.addCertificate(this.convertCert(string));
        }
        this.validated = true;
    }

    private X509Certificate convertCert(String string) throws KeyInfoValidationException {
        try {
            return Utils.certFromBase64(string);
        }
        catch (CertificateException certificateException) {
            throw new KeyInfoValidationException("cannot decode certificate", certificateException);
        }
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        StreamUtils.addStart(xMLOutputStream, string, "X509Data", n);
        for (Object object : this.subjectNames) {
            StreamUtils.addElement(xMLOutputStream, string, "X509SubjectName", (String)object, n + 2, 2);
        }
        for (Object object : this.issuerSerials) {
            ((X509IssuerSerial)object).toXML(xMLOutputStream, string, n + 2);
        }
        for (Object object : this.certs) {
            StreamUtils.addElement(xMLOutputStream, string, "X509Certificate", this.getCertificateBase64((X509Certificate)object), n + 2, 2);
        }
        StreamUtils.addEnd(xMLOutputStream, string, "X509Data", n);
    }

    private void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        XMLEvent xMLEvent = xMLInputStream.next();
        while (!xMLInputStream.peek().isEndElement()) {
            String string2 = StreamUtils.getValue(xMLInputStream, string, "X509SubjectName");
            if (string2 != null) {
                this.addSubjectName(string2);
                continue;
            }
            X509IssuerSerial x509IssuerSerial = X509IssuerSerial.fromXML(xMLInputStream, string);
            if (x509IssuerSerial != null) {
                this.addIssuerSerial(x509IssuerSerial);
                continue;
            }
            String string3 = StreamUtils.getValue(xMLInputStream, string, "X509Certificate");
            if (string3 != null) {
                this.certificateBase64s.add(string3);
                continue;
            }
            if (xMLInputStream.peek().isEndElement()) break;
            if (xMLInputStream.peek().isStartElement()) {
                xMLInputStream.skipElement();
                continue;
            }
            xMLInputStream.skip();
        }
        StreamUtils.closeScope(xMLInputStream, string, "X509Data");
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<X509Data xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n  <X509SubjectName>\n    CN=Joe User,O=BEA Systems,L=Liberty Corner,ST=New Jersey,C=US\n  </X509SubjectName>\n  <X509IssuerSerial>\n  <X509IssuerName>\n      O=BEA Systems,L=San Francisco,ST=California,C=US\n  </X509IssuerName>\n    <X509SerialNumber>1017788370348</X509SerialNumber>\n  </X509IssuerSerial>\n  <X509Certificate>\nMIIDUDCCAxCgAwIBAgIGAOz5IVHTMAkGByqGSM44BAMwdjELMAkGA1UEBhMCSUUx\nDzANBgNVBAgTBkR1YmxpbjEkMCIGA1UEChMbQmFsdGltb3JlIFRlY2hub2xvZ2ll\ncyBMdGQuMREwDwYDVQQLEwhYL1NlY3VyZTEdMBsGA1UEAxMUQW5vdGhlciBUcmFu\nc2llbnQgQ0EwHhcNMDIwNDAyMjM1OTUyWhcNMTIwNDAyMjI1OTQ2WjBoMQswCQYD\nVQQGEwJJRTEPMA0GA1UECBMGRHVibGluMSQwIgYDVQQKExtCYWx0aW1vcmUgVGVj\naG5vbG9naWVzIEx0ZC4xETAPBgNVBAsTCFgvU2VjdXJlMQ8wDQYDVQQDEwZNb3Jp\nZ3UwggG2MIIBKwYHKoZIzjgEATCCAR4CgYEAhIqwSieM0aAez+6H71gqCfBnwG3d\nPu7JAElb13GkwXRw9RfPh0VtIVjhDJbyKAIuzCk5r54ccRixa8TQ2vWVwodQ9eru\n7jUknAc2rVEAV5mJTrBr7UUve/X9PWsCDN6lXvFLiJp/Pi/F0cyV/CAp+jIp+rol\nTXOhUz9qEjnFYMMCFQCYS/p4gmsHgo3R89EAE/Hc0dhyWQKBgCWG5hn8DM+1rv5s\nTkJBqyZJXNzy4z974s3sAGURfBBGTpB9kFxfxNt480TxkWeDhR+39DMA5TEAsRPu\nQoB6Tgl7K2nNzRdgJjK4YkBObgX1ljWkAnnJCZSbC8Nh2VpkniV0bM79HnsS+eCf\n8bi2qOOiLSzHeOrtzO8PB0YeeTLQA4GEAAKBgH1NBJ9Az5TwY4tDE0dPYVHHABt+\nyLspnT3k9G6YWUMFhZ/+3RuqEPjnKrPfUoXTTJGIACgPU3/PkqwrPVD0JMdpOcnZ\nLHiJ/P7QRQeMwDRoBrs7genB1bDd4pSJrEUcjrkA5uRrIj2Z5fL+UuLiLGPO2rM7\nBNQRIq3QFPdX++NuozowODAOBgNVHQ8BAf8EBAMCB4AwEQYDVR0OBAoECIK7Ljjh\n+EsfMBMGA1UdIwQMMAqACIocVjBaMhJ9MAkGByqGSM44BAMDLwAwLAIUEJJCOHw8\nppxoRyz3s+Vmb4NKIfMCFDgJoZn9zh/3WoYNBURODwLvyBOy\n  </X509Certificate>\n</X509Data>\n");
        X509Data x509Data = (X509Data)DSIGReader.read(xMLInputStream, 11);
        x509Data.validate();
        System.out.println(x509Data);
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        x509Data.toXML(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#", 0);
        xMLOutputStream.flush();
    }
}

