/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.keyinfo;

import java.math.BigInteger;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class X509IssuerSerial
implements DSIGConstants {
    private String issuerName;
    private BigInteger serialNumber;

    public X509IssuerSerial(String string, BigInteger bigInteger) {
        this.issuerName = string;
        this.serialNumber = bigInteger;
    }

    private X509IssuerSerial(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public BigInteger getIssuerSerialNumber() {
        return this.serialNumber;
    }

    public String toString() {
        return "IssuerSerial:  issuerName=" + this.issuerName + "  serialNumber=" + this.serialNumber;
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        StreamUtils.addStart(xMLOutputStream, string, "X509IssuerSerial", n + 2);
        StreamUtils.addElement(xMLOutputStream, string, "X509IssuerName", this.issuerName, n + 4, 2);
        StreamUtils.addElement(xMLOutputStream, string, "X509SerialNumber", this.serialNumber.toString(), n + 4);
        StreamUtils.addEnd(xMLOutputStream, string, "X509IssuerSerial", n + 2);
    }

    public static X509IssuerSerial fromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        if (StreamUtils.peekElement(xMLInputStream, string, "X509IssuerSerial")) {
            return new X509IssuerSerial(xMLInputStream, string);
        }
        return null;
    }

    private void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        XMLEvent xMLEvent = xMLInputStream.next();
        this.issuerName = StreamUtils.getValue(xMLInputStream, string, "X509IssuerName");
        String string2 = StreamUtils.getValue(xMLInputStream, string, "X509SerialNumber");
        try {
            this.serialNumber = new BigInteger(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLStreamException(string2 + " is not a valid Integer");
        }
        StreamUtils.closeScope(xMLInputStream, string, "X509IssuerSerial");
    }
}

