/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.io.OutputStream;
import java.util.Map;
import weblogic.utils.Debug;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.schema.types.XSDNMTokens;
import weblogic.xml.security.signature.CanonicalizationMethodFactory;
import weblogic.xml.security.signature.CanonicalizationMethodW3C;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DSIGReader;
import weblogic.xml.security.signature.XMLSignatureException;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class CanonicalizationMethod
implements DSIGConstants {
    public static final String W3C = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String W3C_WC = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String EXC = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private static final ConcurrentHashMap factories = new ConcurrentHashMap();
    private String[] inclusiveNamespaces = null;

    private static final void initFactories() {
        CanonicalizationMethodW3C.init();
    }

    public abstract String getURI();

    public String toString() {
        return "CanonicalizationMethod:  algorithmURI = " + this.getURI();
    }

    public static void register(CanonicalizationMethodFactory canonicalizationMethodFactory) {
        factories.put((Object)canonicalizationMethodFactory.getURI(), (Object)canonicalizationMethodFactory);
    }

    public static CanonicalizationMethod get(String string) throws XMLSignatureException {
        CanonicalizationMethodFactory canonicalizationMethodFactory = (CanonicalizationMethodFactory)factories.get((Object)string);
        if (canonicalizationMethodFactory == null) {
            throw new XMLSignatureException(string + " not supported");
        }
        return canonicalizationMethodFactory.newCanonicalizationMethod();
    }

    public abstract XMLOutputStream canonicalize(OutputStream var1, Map var2);

    protected String[] getInclusiveNamesspacesPrefixList() {
        return this.inclusiveNamespaces;
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Attribute[] attributeArray = new Attribute[]{ElementFactory.createAttribute("Algorithm", this.getURI())};
        StreamUtils.addElement(xMLOutputStream, string, "CanonicalizationMethod", null, attributeArray, n, 2);
    }

    static CanonicalizationMethod fromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        CanonicalizationMethod canonicalizationMethod = null;
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "CanonicalizationMethod");
        if (startElement != null) {
            String string2 = StreamUtils.getAttribute(startElement, "Algorithm");
            StreamUtils.requiredAttr(string2, "CanonicalizationMethod", "Algorithm");
            canonicalizationMethod = CanonicalizationMethod.get(string2);
            String[] stringArray = CanonicalizationMethod.getInclusiveNamesSpacesFromXml(xMLInputStream, string);
            canonicalizationMethod.inclusiveNamespaces = stringArray;
            StreamUtils.closeScope(xMLInputStream, string, "CanonicalizationMethod");
        }
        return canonicalizationMethod;
    }

    protected static String[] getInclusiveNamesSpacesFromXml(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        String[] stringArray = null;
        XMLEvent xMLEvent = StreamUtils.peekElement(xMLInputStream);
        if (StreamUtils.matches(xMLEvent, "InclusiveNamespaces")) {
            XMLEvent xMLEvent2 = xMLInputStream.next();
            String string2 = StreamUtils.getAttributeByName("PrefixList", null, (StartElement)xMLEvent2);
            if (string2 != null) {
                stringArray = XSDNMTokens.convertXml((String)string2, (String)"#default");
                if (VERBOSE) {
                    CanonicalizationMethod.print(stringArray);
                }
            }
            StreamUtils.closeScope(xMLInputStream, "InclusiveNamespaces");
        }
        return stringArray;
    }

    private static void print(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                string = string + " ";
            }
            string = string + stringArray[i];
        }
        Debug.say((String)(" +++ - " + string + " - "));
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<CanonicalizationMethod xmlns=\"http://www.w3.org/2000/09/xmldsig#\" Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"/>\n");
        CanonicalizationMethod canonicalizationMethod = (CanonicalizationMethod)DSIGReader.read(xMLInputStream, 1);
        System.out.println(canonicalizationMethod);
        System.out.println("Implemented by: " + canonicalizationMethod.getClass().getName());
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        canonicalizationMethod.toXML(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#", 0);
        xMLOutputStream.flush();
    }

    static {
        CanonicalizationMethod.initFactories();
    }
}

