/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import weblogic.xml.babel.stream.CanonicalWriter;
import weblogic.xml.babel.stream.ExclusiveCanonicalWriter;
import weblogic.xml.babel.stream.XMLOutputStreamBase;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.security.signature.CanonicalizationMethod;
import weblogic.xml.security.signature.CanonicalizationMethodFactory;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.stream.XMLOutputStream;

class CanonicalizationMethodW3C
extends CanonicalizationMethod
implements CanonicalizationMethodFactory,
DSIGConstants {
    public static final String URI = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String URI_WC = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String URI_EXC = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private final String uri;
    private final boolean withComments;
    private final boolean exclusive;

    private CanonicalizationMethodW3C(String string, boolean bl, boolean bl2) {
        this.uri = string;
        this.withComments = bl;
        this.exclusive = bl2;
    }

    public String getURI() {
        return this.uri;
    }

    static void init() {
        CanonicalizationMethod.register(new CanonicalizationMethodW3C(URI, false, false));
        CanonicalizationMethod.register(new CanonicalizationMethodW3C(URI_WC, true, false));
        CanonicalizationMethod.register(new CanonicalizationMethodW3C(URI_EXC, false, true));
    }

    public CanonicalizationMethod newCanonicalizationMethod() {
        return this;
    }

    public XMLOutputStream canonicalize(OutputStream outputStream, Map map) {
        CanonicalWriter canonicalWriter;
        OutputStreamWriter outputStreamWriter;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        if (this.exclusive) {
            canonicalWriter = new ExclusiveCanonicalWriter((Writer)outputStreamWriter, this.getInclusiveNamesspacesPrefixList());
        } else {
            canonicalWriter = new CanonicalWriter((Writer)outputStreamWriter, map);
            if (this.withComments) {
                canonicalWriter.setWriteComments(this.withComments);
            }
        }
        return new XMLOutputStreamBase((XMLWriter)canonicalWriter);
    }
}

