/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import weblogic.xml.security.keyinfo.KeyInfo;
import weblogic.xml.security.keyinfo.KeyValue;
import weblogic.xml.security.keyinfo.X509Data;
import weblogic.xml.security.signature.CanonicalizationMethod;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DigestMethod;
import weblogic.xml.security.signature.Reference;
import weblogic.xml.security.signature.Signature;
import weblogic.xml.security.signature.SignatureMethod;
import weblogic.xml.security.signature.SignedInfo;
import weblogic.xml.security.transforms.Transforms;
import weblogic.xml.security.utils.XMLObjectReader;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public class DSIGReader
extends XMLObjectReader
implements DSIGConstants {
    private static DSIGReader singleton = new DSIGReader();

    private DSIGReader() {
        this.register("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod", 1);
        this.register("http://www.w3.org/2000/09/xmldsig#", "DigestMethod", 2);
        this.register("http://www.w3.org/2000/09/xmldsig#", "KeyInfo", 4);
        this.register("http://www.w3.org/2000/09/xmldsig#", "KeyValue", 5);
        this.register("http://www.w3.org/2000/09/xmldsig#", "Reference", 6);
        this.register("http://www.w3.org/2000/09/xmldsig#", "Signature", 8);
        this.register("http://www.w3.org/2000/09/xmldsig#", "SignatureMethod", 9);
        this.register("http://www.w3.org/2000/09/xmldsig#", "SignedInfo", 10);
        this.register("http://www.w3.org/2000/09/xmldsig#", "X509Data", 11);
        this.register("http://www.w3.org/2000/09/xmldsig#", "Transforms", 12);
    }

    public Object readObjectInternal(int n, String string, XMLInputStream xMLInputStream) throws XMLStreamException {
        switch (n) {
            case 1: {
                return CanonicalizationMethod.fromXML(xMLInputStream, string);
            }
            case 2: {
                return DigestMethod.fromXML(xMLInputStream, string);
            }
            case 4: {
                return new KeyInfo(xMLInputStream, string);
            }
            case 5: {
                return KeyValue.fromXML(xMLInputStream, string);
            }
            case 6: {
                return Reference.fromXML(xMLInputStream, string);
            }
            case 8: {
                return new Signature(xMLInputStream, string);
            }
            case 9: {
                return SignatureMethod.fromXML(xMLInputStream, string);
            }
            case 10: {
                return new SignedInfo(xMLInputStream, string);
            }
            case 11: {
                return new X509Data(xMLInputStream, string);
            }
            case 12: {
                return Transforms.fromXML(xMLInputStream, string);
            }
        }
        throw new AssertionError((Object)("Unknown typecode: " + n));
    }

    public static Object read(XMLInputStream xMLInputStream, int n) throws XMLStreamException {
        return singleton.readObject(xMLInputStream, n);
    }
}

