/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.security.MessageDigest;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DigestMethodFactory;
import weblogic.xml.security.signature.JCEDigestMethod;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.security.utils.XMLSecurityException;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class DigestMethod
implements DSIGConstants {
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    private static final ConcurrentHashMap factories = new ConcurrentHashMap();

    private static final void initFactories() {
        JCEDigestMethod.init();
    }

    public abstract MessageDigest getMessageDigest();

    public abstract String getURI();

    public String toString() {
        return "DigestMethod:  algorithmURI = " + this.getURI();
    }

    public static void register(DigestMethodFactory digestMethodFactory) {
        factories.put((Object)digestMethodFactory.getURI(), (Object)digestMethodFactory);
    }

    public static DigestMethod get(String string) throws XMLSecurityException {
        DigestMethodFactory digestMethodFactory = (DigestMethodFactory)factories.get((Object)string);
        if (digestMethodFactory == null) {
            throw new XMLSecurityException(string + " not supported");
        }
        return digestMethodFactory.newDigestMethod();
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Attribute[] attributeArray = new Attribute[]{ElementFactory.createAttribute("Algorithm", this.getURI())};
        StreamUtils.addElement(xMLOutputStream, string, "DigestMethod", null, attributeArray, n, 2);
    }

    static DigestMethod fromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        DigestMethod digestMethod = null;
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "DigestMethod");
        if (startElement != null) {
            String string2 = StreamUtils.getAttribute(startElement, "Algorithm");
            StreamUtils.requiredAttr(string2, "DigestMethod", "Algorithm");
            digestMethod = DigestMethod.get(string2);
            digestMethod.fromXMLInternal(xMLInputStream, string);
            StreamUtils.closeScope(xMLInputStream, string, "DigestMethod");
        }
        return digestMethod;
    }

    public void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"/>\n");
        DigestMethod digestMethod = DigestMethod.fromXML(xMLInputStream, "http://www.w3.org/2000/09/xmldsig#");
        System.out.println(digestMethod);
        System.out.println("Implemented by: " + digestMethod.getClass().getName());
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        digestMethod.toXML(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#", 0);
        xMLOutputStream.flush();
    }

    static {
        DigestMethod.initFactories();
    }
}

