/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.util.Iterator;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DigestMethod;
import weblogic.xml.security.signature.InternalReference;
import weblogic.xml.security.signature.InvalidReferenceException;
import weblogic.xml.security.transforms.Transforms;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class EnvelopingReference
extends InternalReference
implements DSIGConstants {
    public EnvelopingReference(String string, DigestMethod digestMethod) {
        super(string, digestMethod);
    }

    protected void process(Transforms transforms) throws InvalidReferenceException {
        try {
            XMLOutputStream xMLOutputStream = this.getXOS(transforms);
            this.writeEnveloped(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#");
            xMLOutputStream.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new InvalidReferenceException("cannot process reference", xMLStreamException, this);
        }
    }

    void writeEnveloped(XMLOutputStream xMLOutputStream, String string) throws XMLStreamException {
        String string2 = this.getURI();
        string2 = string2.substring(1, string2.length());
        Attribute[] attributeArray = new Attribute[]{ElementFactory.createAttribute("Id", string2)};
        StreamUtils.addStart(xMLOutputStream, string, "Object", attributeArray);
        Iterator iterator = this.observed.iterator();
        while (iterator.hasNext()) {
            xMLOutputStream.add((XMLEvent)iterator.next());
        }
        StreamUtils.addEnd(xMLOutputStream, string, "Object");
    }

    public boolean consumes() {
        return true;
    }
}

