/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DigestMethod;
import weblogic.xml.security.signature.InvalidReferenceException;
import weblogic.xml.security.signature.Reference;
import weblogic.xml.security.transforms.C14NTransform;
import weblogic.xml.security.transforms.IncompatibleTransformException;
import weblogic.xml.security.transforms.NodeTransform;
import weblogic.xml.security.transforms.Transform;
import weblogic.xml.security.transforms.Transforms;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.utils.Observer;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class InternalReference
extends Reference
implements DSIGConstants,
Observer {
    private int nesting = 0;
    protected List observed = new LinkedList();
    private Map namespaces;

    public InternalReference(String string) {
        super(string);
    }

    public InternalReference(String string, DigestMethod digestMethod) {
        super(string, digestMethod);
    }

    public boolean observe(XMLEvent xMLEvent) throws XMLStreamException {
        switch (xMLEvent.getType()) {
            case 2: {
                ++this.nesting;
                break;
            }
            case 4: {
                --this.nesting;
            }
        }
        this.observed.add(xMLEvent);
        return this.nesting > 0;
    }

    XMLOutputStream getXOS(Transforms transforms) throws XMLStreamException {
        XMLOutputStream xMLOutputStream = null;
        boolean bl = false;
        for (int i = 0; i < transforms.size(); ++i) {
            if (!(transforms.get(i) instanceof NodeTransform)) continue;
            bl = true;
        }
        if (bl) {
            return transforms.getXMLOutputStream();
        }
        Transform transform = transforms.get(transforms.size() - 1);
        C14NTransform c14NTransform = new C14NTransform(false);
        if (this.namespaces != null) {
            ((Transform)c14NTransform).setNamespaces(this.namespaces);
        }
        try {
            transforms.remove(transform);
            transforms.add(c14NTransform);
            transforms.add(transform);
            xMLOutputStream = transforms.getXMLOutputStream();
            xMLOutputStream = new NamespaceAwareXOS(xMLOutputStream, this.namespaces);
            ((NamespaceAwareXOS)xMLOutputStream).addPrefix("http://www.w3.org/2000/09/xmldsig#", "dsig");
            transforms.remove(c14NTransform);
        }
        catch (IncompatibleTransformException incompatibleTransformException) {
            throw new AssertionError((Object)incompatibleTransformException);
        }
        return xMLOutputStream;
    }

    protected void process(Transforms transforms) throws InvalidReferenceException {
        try {
            XMLOutputStream xMLOutputStream = this.getXOS(transforms);
            for (XMLEvent xMLEvent : this.observed) {
                xMLOutputStream.add(xMLEvent);
            }
            xMLOutputStream.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new InvalidReferenceException(xMLStreamException, (Reference)this);
        }
    }

    public boolean consumes() {
        return false;
    }

    void setNamespaces(Map map) {
        this.namespaces = new HashMap();
        this.namespaces.putAll(map);
    }
}

