/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import weblogic.xml.security.encryption.XMLEncConstants;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DigestMethod;
import weblogic.xml.security.signature.DigestMethodFactory;
import weblogic.xml.security.utils.XMLSecurityException;

public class JCEDigestMethod
extends DigestMethod
implements DigestMethodFactory,
DSIGConstants,
XMLEncConstants {
    public static final String URI_SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String URI_SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String URI_SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    private static final String JCE_SHA1 = "SHA-1";
    private static final String JCE_SHA256 = "SHA-256";
    private static final String JCE_SHA512 = "SHA-512";
    private final String algorithmURI;
    private final String jceAlgorithmID;
    private final MessageDigest messageDigest;

    private JCEDigestMethod(String string, String string2) throws XMLSecurityException {
        this.algorithmURI = string;
        this.jceAlgorithmID = string2;
        try {
            this.messageDigest = MessageDigest.getInstance(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLSecurityException("No such algorithm: " + string2);
        }
    }

    public static void init() {
        try {
            JCEDigestMethod.register(new JCEDigestMethod(URI_SHA1, JCE_SHA1));
        }
        catch (XMLSecurityException xMLSecurityException) {
            // empty catch block
        }
    }

    public DigestMethod newDigestMethod() throws XMLSecurityException {
        return new JCEDigestMethod(this.algorithmURI, this.jceAlgorithmID);
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public String getURI() {
        return this.algorithmURI;
    }
}

