/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import weblogic.utils.io.NullOutputStream;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DSIGReader;
import weblogic.xml.security.signature.DigestMethod;
import weblogic.xml.security.signature.EnvelopedReference;
import weblogic.xml.security.signature.ExternalReference;
import weblogic.xml.security.signature.InternalReference;
import weblogic.xml.security.signature.InvalidReferenceException;
import weblogic.xml.security.transforms.DigestTransform;
import weblogic.xml.security.transforms.IncompatibleTransformException;
import weblogic.xml.security.transforms.Transform;
import weblogic.xml.security.transforms.Transforms;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.security.utils.XMLSecurityException;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class Reference
implements DSIGConstants {
    private static final OutputStream NULL_OS = new NullOutputStream();
    private String uri;
    private DigestMethod digestMethod;
    private String digestValue;
    private Transforms transforms = new Transforms();

    public Reference(String string) {
        this.uri = string;
        try {
            this.digestMethod = DigestMethod.get("http://www.w3.org/2000/09/xmldsig#sha1");
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new AssertionError((Object)xMLSecurityException);
        }
    }

    public Reference(String string, DigestMethod digestMethod) {
        this.uri = string;
        this.digestMethod = digestMethod;
    }

    private Reference(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public String getURI() {
        return this.uri;
    }

    public void addTransform(Transform transform) throws IncompatibleTransformException {
        this.transforms.add(transform);
    }

    protected abstract void process(Transforms var1) throws InvalidReferenceException;

    void digest() throws InvalidReferenceException {
        this.digestValue = Utils.base64(this.getDigest());
    }

    public void print(String string, byte[] byArray) {
        if (VERBOSE) {
            System.out.println(" +++++++ Printing " + string + " : " + Utils.base64(byArray));
        }
    }

    void validate() throws InvalidReferenceException {
        byte[] byArray = this.getDigest();
        this.print("computedDigest", byArray);
        byte[] byArray2 = Utils.base64(this.digestValue);
        this.print("referenceDigest", byArray2);
        if (!Arrays.equals(byArray, byArray2)) {
            throw new InvalidReferenceException("Invalid digest", this);
        }
    }

    private byte[] getDigest() throws InvalidReferenceException {
        if (this.digestMethod == null) {
            throw new InvalidReferenceException("No DigestMethod set", this);
        }
        MessageDigest messageDigest = this.digestMethod.getMessageDigest();
        DigestTransform digestTransform = null;
        if (VERBOSE) {
            System.out.println("<!-- -- Begin Reference" + this.refDebug() + " ----->");
            digestTransform = new DigestTransform(new UncloseableOutputStream(System.out), messageDigest);
        } else {
            digestTransform = new DigestTransform(NULL_OS, messageDigest);
        }
        try {
            this.transforms.add(digestTransform);
            this.process(this.transforms);
            this.transforms.remove(digestTransform);
        }
        catch (IncompatibleTransformException incompatibleTransformException) {
            throw new AssertionError((Object)incompatibleTransformException);
        }
        if (VERBOSE) {
            System.out.println("\n<!----- End Reference " + this.refDebug() + "  -- -->");
        }
        byte[] byArray = messageDigest.digest();
        return byArray;
    }

    private final String refDebug() {
        return this.uri == null ? "" : "(uri=" + this.uri + ")";
    }

    public final Transform[] getTransforms() {
        return this.transforms.getTransforms();
    }

    void copyDigestValue(Reference reference) {
        this.digestValue = reference.digestValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Reference:  URI=").append(this.uri).append("\n").append("  digest: ").append(this.digestValue).append("\n").append("  digestMethod: ").append(this.digestMethod).append("\n").append("  transforms: ").append(this.transforms).append("\n");
        return stringBuffer.toString();
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Attribute[] attributeArray = new Attribute[]{ElementFactory.createAttribute("URI", this.uri)};
        StreamUtils.addStart(xMLOutputStream, string, "Reference", attributeArray, n);
        this.transforms.toXML(xMLOutputStream, string, n + 2);
        this.digestMethod.toXML(xMLOutputStream, string, n + 2);
        StreamUtils.addElement(xMLOutputStream, string, "DigestValue", this.digestValue, n + 2, 2);
        StreamUtils.addEnd(xMLOutputStream, string, "Reference", n);
    }

    static Reference fromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        InternalReference internalReference;
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "Reference");
        String string2 = StreamUtils.getAttribute(startElement, "URI");
        StreamUtils.requiredAttr(string2, "Reference", "URI");
        if (string2.equals("")) {
            internalReference = new EnvelopedReference();
        } else if (string2.startsWith("#")) {
            internalReference = new InternalReference(string2);
            ((InternalReference)internalReference).setNamespaces(startElement.getNamespaceMap());
        } else {
            internalReference = new ExternalReference(string2);
        }
        super.fromXMLInternal(xMLInputStream, string);
        return internalReference;
    }

    private void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.transforms = (Transforms)DSIGReader.read(xMLInputStream, 12);
        if (this.transforms == null) {
            this.transforms = new Transforms();
        }
        this.digestMethod = (DigestMethod)DSIGReader.read(xMLInputStream, 2);
        this.digestValue = StreamUtils.getValue(xMLInputStream, string, "DigestValue");
        StreamUtils.closeScope(xMLInputStream, string, "Reference");
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<Reference xmlns=\"http://www.w3.org/2000/09/xmldsig#\" URI=\"#MyData\">\n  <Transforms>\n    <Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#enveloped-signature\"/>\n  </Transforms>\n  <DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"/>\n  <DigestValue>fdy6S2NLpnT4fMdokUHSHsmpcvo=</DigestValue>\n</Reference>\n");
        Reference reference = (Reference)DSIGReader.read(xMLInputStream, 6);
        reference.digest();
        System.out.println(reference);
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        reference.toXML(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#", 0);
        xMLOutputStream.flush();
    }

    private static class UncloseableOutputStream
    extends OutputStream {
        private final OutputStream destination;

        public UncloseableOutputStream(OutputStream outputStream) {
            this.destination = outputStream;
        }

        public void write(int n) throws IOException {
            this.destination.write(n);
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
            this.destination.flush();
        }
    }
}

