/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import weblogic.xml.babel.stream.XMLOutputStreamBase;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.EnvelopingReference;
import weblogic.xml.security.signature.InternalReference;
import weblogic.xml.security.signature.Reference;
import weblogic.xml.security.signature.Signature;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.utils.Observer;
import weblogic.xml.security.utils.XMLStreamObserver;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class SignXMLOutputStream
extends XMLOutputStreamBase
implements DSIGConstants,
NSOutputStream {
    private NSOutputStream dest;
    private boolean firstPass = true;
    private XMLEvent firstElement;
    private XMLEvent lastSpace;
    private List nodes = new LinkedList();
    private XMLStreamObserver unresolvedReferences = new XMLStreamObserver("http://www.w3.org/2000/09/xmldsig#");
    private Signature pendingSignature;
    private final boolean streamSignature;

    public SignXMLOutputStream(XMLOutputStream dest) {
        this(dest, true);
    }

    public SignXMLOutputStream(XMLOutputStream dest, boolean streamSignature) {
        this.dest = !(dest instanceof NSOutputStream) ? new NamespaceAwareXOS(dest) : (NSOutputStream)dest;
        this.addPrefix("http://www.w3.org/2000/09/xmldsig#", "dsig");
        this.streamSignature = streamSignature;
    }

    public void sign(Signature signature) throws XMLStreamException {
        this.pendingSignature = signature;
    }

    protected void addXMLEvent(XMLEvent event) throws XMLStreamException {
        if (event == null) {
            return;
        }
        if (this.firstElement == null && event.isStartElement()) {
            this.firstElement = event;
        }
        if (this.pendingSignature != null && event.isStartElement()) {
            boolean needToWrite;
            Iterator references = this.pendingSignature.getReferences();
            while (references.hasNext()) {
                Reference ref = (Reference)references.next();
                if (!(ref instanceof InternalReference)) continue;
                InternalReference iref = (InternalReference)ref;
                if (iref instanceof EnvelopingReference) {
                    this.unresolvedReferences.add(event, (Observer)iref);
                    continue;
                }
                String uri = ref.getURI();
                if (uri == null || uri.equals("")) {
                    this.unresolvedReferences.add(this.firstElement, (Observer)iref);
                    continue;
                }
                this.unresolvedReferences.add(uri, (Observer)iref);
            }
            boolean bl = needToWrite = !this.unresolvedReferences.observe(event);
            if (needToWrite) {
                this.nodes.add(event);
            }
            this.nodes.add(this.pendingSignature);
            this.pendingSignature = null;
            return;
        }
        if (!this.unresolvedReferences.observe(event)) {
            this.nodes.add(event);
        }
    }

    private int calculateIndent() {
        if (this.lastSpace == null) {
            return 0;
        }
        String content = ((CharacterData)this.lastSpace).getContent();
        int i = content.lastIndexOf(10);
        if (i == -1) {
            return content.length();
        }
        return content.length() - (i + 1);
    }

    public Signature process() throws XMLStreamException {
        XMLEvent next;
        Object o;
        if (this.firstPass) {
            this.lastStartElement = null;
            this.firstPass = false;
        }
        if (this.pendingSignature != null) {
            if (this.streamSignature) {
                this.pendingSignature.toXML(this.dest, "http://www.w3.org/2000/09/xmldsig#", this.calculateIndent());
            }
            this.pendingSignature = null;
        }
        Iterator i = this.nodes.iterator();
        while (i.hasNext()) {
            o = i.next();
            if (o instanceof Signature || !this.unresolvedReferences.observe(next = (XMLEvent)o)) continue;
            i.remove();
        }
        while (this.nodes.size() > 0) {
            o = this.nodes.remove(0);
            if (o instanceof Signature) {
                this.pendingSignature = (Signature)o;
                this.pendingSignature.setIndent(this.calculateIndent());
                this.pendingSignature.setNamespaces(this.dest.getNamespaces());
                return this.pendingSignature;
            }
            next = (XMLEvent)o;
            if (next.isSpace()) {
                this.lastSpace = next;
            }
            this.dest.add(next);
        }
        return null;
    }

    public void flush() throws XMLStreamException {
        if (this.process() != null && this.streamSignature) {
            throw new XMLStreamException("attempt to flush unsigned Signatures");
        }
        this.dest.flush();
    }

    public void close() throws XMLStreamException {
        this.flush();
        this.dest.close();
    }

    public void close(boolean flush) throws XMLStreamException {
        this.process();
        if (flush) {
            this.flush();
        }
        this.dest.close(flush);
    }

    public void addPrefix(String namespaceURI, String prefix) {
        this.dest.addPrefix(namespaceURI, prefix);
    }

    public Map getNamespaces() {
        return this.dest.getNamespaces();
    }
}

