/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.security.Key;
import java.util.Iterator;
import java.util.Map;
import weblogic.xml.security.keyinfo.KeyInfo;
import weblogic.xml.security.keyinfo.KeyInfoValidationException;
import weblogic.xml.security.keyinfo.KeyPurpose;
import weblogic.xml.security.keyinfo.KeyResolver;
import weblogic.xml.security.keyinfo.KeyResolverException;
import weblogic.xml.security.keyinfo.KeyResult;
import weblogic.xml.security.signature.CanonicalizationMethod;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DSIGReader;
import weblogic.xml.security.signature.EnvelopingReference;
import weblogic.xml.security.signature.InternalReference;
import weblogic.xml.security.signature.Reference;
import weblogic.xml.security.signature.SignatureMethod;
import weblogic.xml.security.signature.SignatureValidationException;
import weblogic.xml.security.signature.SignedInfo;
import weblogic.xml.security.signature.XMLSignatureException;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public final class Signature
implements DSIGConstants {
    private SignedInfo signedInfo;
    private KeyInfo keyInfo;
    private String signatureValue;
    private KeyResult validatingKey = null;
    private XMLInputStream objectSubstream;

    public Signature() {
        this.signedInfo = new SignedInfo();
    }

    Signature(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public void setSignatureMethod(String string) throws XMLSignatureException {
        this.signedInfo.setSignatureMethod(SignatureMethod.get(string));
    }

    public String getSignatureMethod() {
        return this.signedInfo.getSignatureMethodURI();
    }

    public void setCanonicalizationMethod(String string) throws XMLSignatureException {
        this.signedInfo.setCanonicalizationMethod(string);
    }

    public void setCanonicalizationMethod(CanonicalizationMethod canonicalizationMethod) {
        this.signedInfo.setCanonicalizationMethod(canonicalizationMethod);
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.keyInfo = keyInfo;
    }

    public KeyInfo getKeyInfo() throws KeyInfoValidationException {
        if (this.keyInfo != null) {
            this.keyInfo.validate();
        }
        return this.keyInfo;
    }

    public void addReference(Reference reference) {
        this.signedInfo.addReference(reference);
    }

    public Iterator getReferences() {
        return this.signedInfo.getReferences();
    }

    public void sign(Key key) throws XMLSignatureException {
        this.signatureValue = this.signedInfo.sign(key);
    }

    public void validate(Key key) throws XMLSignatureException {
        this.signedInfo.validate(key, this.signatureValue);
    }

    private void validateSignature(KeyResult keyResult) throws XMLSignatureException {
        this.signedInfo.validateSignature(keyResult.getKey(), this.signatureValue);
        this.validatingKey = keyResult;
    }

    public void validateSignature(KeyResolver keyResolver) throws XMLSignatureException {
        try {
            this.validateSignature(keyResolver.resolveKey(KeyPurpose.VERIFY, this.getSignatureMethod(), this.getKeyInfo()));
        }
        catch (KeyResolverException keyResolverException) {
            throw new SignatureValidationException("Could not resolve key for signature " + this, (Throwable)((Object)keyResolverException));
        }
        catch (KeyInfoValidationException keyInfoValidationException) {
            throw new SignatureValidationException("Could not valid keyInfo for signature " + this, keyInfoValidationException);
        }
    }

    public void validateReferences() throws XMLSignatureException {
        this.signedInfo.validateReferences();
    }

    public KeyResult getValidatingKey() {
        return this.validatingKey;
    }

    void setIndent(int n) {
        this.signedInfo.setIndent(n + 2);
    }

    void setNamespaces(Map map) {
        this.signedInfo.setNamespaces(map);
        Iterator iterator = this.getReferences();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            if (!(reference instanceof InternalReference)) continue;
            ((InternalReference)reference).setNamespaces(map);
        }
    }

    private EnvelopingReference getEnvelopingReference() {
        Iterator iterator = this.getReferences();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof EnvelopingReference)) continue;
            return (EnvelopingReference)e;
        }
        return null;
    }

    XMLInputStream getEmbeddedObject() {
        return this.objectSubstream;
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        EnvelopingReference envelopingReference;
        StreamUtils.addStart(xMLOutputStream, string, "Signature");
        this.signedInfo.toXML(xMLOutputStream, string, n + 2);
        StreamUtils.addElement(xMLOutputStream, string, "SignatureValue", this.signatureValue, n + 2, 2);
        if (this.keyInfo != null) {
            this.keyInfo.toXML(xMLOutputStream, string, n + 2);
        }
        if ((envelopingReference = this.getEnvelopingReference()) != null) {
            envelopingReference.writeEnveloped(xMLOutputStream, string);
        }
        StreamUtils.addEnd(xMLOutputStream, string, "Signature", n);
    }

    private void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        xMLInputStream.next();
        this.signedInfo = (SignedInfo)DSIGReader.read(xMLInputStream, 10);
        StreamUtils.required(this.signedInfo, "Signature", "SignedInfo");
        this.signatureValue = StreamUtils.getValue(xMLInputStream, string, "SignatureValue");
        StreamUtils.required(this.signatureValue, "Signature", "SignatureValue");
        this.keyInfo = (KeyInfo)DSIGReader.read(xMLInputStream, 4);
        if (StreamUtils.peekElement(xMLInputStream, string, "Object")) {
            this.objectSubstream = xMLInputStream.getSubStream();
            xMLInputStream.skipElement();
        }
        while (StreamUtils.peekElement(xMLInputStream, string, "Object")) {
            xMLInputStream.skipElement();
        }
        StreamUtils.closeScope(xMLInputStream, string, "Signature");
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n  <SignedInfo>\n    <CanonicalizationMethod Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"></CanonicalizationMethod>\n    <SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#dsa-sha1\"></SignatureMethod>\n    <Reference URI=\"file:///d|/weblogic/dev/sandbox/billjg/dsig/alpha.txt\">\n      <DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></DigestMethod>      <DigestValue>gCVvOanTCGUKyQ2b6acqlWJFRXQ=</DigestValue>\n    </Reference>\n  </SignedInfo>\n  <SignatureValue>\n    TIthi3ukKCZ5sRkDlcijVAuHAX4kHq24NXGbS4Hk+RTbOxAjxKdVqw==\n  </SignatureValue>\n  <KeyInfo>\n    <X509Data>\n      <X509Certificate>\nMIIDJTCCAuMCBD1ROTgwCwYHKoZIzjgEAwUAMHgxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpOZXcgSmVyc2V5MRcwFQYDVQQHEw5MaWJlcnR5IENvcm5lcjEMMAoGA1UEChMDQkVBMRQwEgYDVQQLEwtFbmdpbmVlcmluZzEXMBUGA1UEAxMOQmlsbCBHYWxsYWdoZXIwHhcNMDIwODA3MTUxNDAwWhcNMDIxMTA1MTUxNDAwWjB4MQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3IEplcnNleTEXMBUGA1UEBxMOTGliZXJ0eSBDb3JuZXIxDDAKBgNVBAoTA0JFQTEUMBIGA1UECxMLRW5naW5lZXJpbmcxFzAVBgNVBAMTDkJpbGwgR2FsbGFnaGVyMIIBuDCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYUAAoGBANOS8gWryNFVnLtJDhGmCL/O9yKducC6kz1HJ3+yYhsvL8nlsojxCpy4kJoNOqTx4iUssInrw6xA7eI8E8QWENAh8IzynOClENm8lZHZNRrLxoqNYNUEnfcyYNLlQsnOoRFoG+Z1qpHIlSqIOkljregQmGQQUZqJZgyniRdAUV11MAsGByqGSM44BAMFAAMvADAsAhREg+kPv4wa3OG2ruOADwOv+VWrewIUQVUbn8cAEImOJ/0iChsTiKV86q0=\n      </X509Certificate>\n    </X509Data>\n  </KeyInfo>\n</Signature>\n");
        Signature signature = (Signature)DSIGReader.read(xMLInputStream, 8);
        System.out.println(signature);
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        signature.toXML(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#", 0);
        xMLOutputStream.flush();
    }
}

